/*
 * Decompiled with CFR 0.152.
 */
package com.datatorrent.lib.util;

import com.datatorrent.lib.util.BaseKeyOperator;
import javax.validation.constraints.NotNull;

public class BaseNumberValueOperator<V extends Number>
extends BaseKeyOperator<V> {
    @NotNull
    protected V_TYPE type = V_TYPE.DOUBLE;

    public V_TYPE getVType() {
        return this.type;
    }

    public void setVType(V_TYPE type) {
        this.type = type;
    }

    public V_TYPE getType() {
        return this.type;
    }

    public void setType(Class<V> ctype) {
        this.type = ctype == Double.class ? V_TYPE.DOUBLE : (ctype == Integer.class ? V_TYPE.INTEGER : (ctype == Float.class ? V_TYPE.FLOAT : (ctype == Long.class ? V_TYPE.LONG : (ctype == Short.class ? V_TYPE.SHORT : V_TYPE.UNKNOWN))));
    }

    public V getValue(Number num) {
        Number val;
        switch (this.type) {
            case DOUBLE: {
                val = new Double(num.doubleValue());
                break;
            }
            case INTEGER: {
                val = new Integer(num.intValue());
                break;
            }
            case FLOAT: {
                val = new Float(num.floatValue());
                break;
            }
            case LONG: {
                val = new Long(num.longValue());
                break;
            }
            case SHORT: {
                val = new Short(num.shortValue());
                break;
            }
            default: {
                val = new Double(num.doubleValue());
            }
        }
        return (V)val;
    }

    public static enum V_TYPE {
        DOUBLE,
        INTEGER,
        FLOAT,
        LONG,
        SHORT,
        UNKNOWN;

    }
}

