/*
 * Decompiled with CFR 0.152.
 */
package com.datatorrent.lib.util;

import com.datatorrent.lib.util.AbstractDimensionTimeBucketOperator;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang.mutable.MutableDouble;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DimensionTimeBucketSumOperator
extends AbstractDimensionTimeBucketOperator {
    private static final Logger LOG = LoggerFactory.getLogger(DimensionTimeBucketSumOperator.class);
    private Map<String, Map<String, Number>> dataMap;

    @Override
    public void process(String timeBucket, String key, String field, Number value) {
        String finalKey = timeBucket + "|" + key;
        Map<String, Number> m = this.dataMap.get(finalKey);
        if (value == null) {
            return;
        }
        if (m == null) {
            m = new HashMap<String, Number>();
            m.put(field, (Number)new MutableDouble(value));
            this.dataMap.put(finalKey, m);
        } else {
            Number n = m.get(field);
            if (n == null) {
                m.put(field, (Number)new MutableDouble(value));
            } else {
                ((MutableDouble)n).add(value);
            }
        }
    }

    @Override
    public void beginWindow(long windowId) {
        super.beginWindow(windowId);
        this.dataMap = new HashMap<String, Map<String, Number>>();
    }

    public void endWindow() {
        if (!this.dataMap.isEmpty()) {
            this.out.emit(this.dataMap);
            LOG.info("Number of keyval pairs: {}", (Object)this.dataMap.size());
        }
    }
}

