/*
 * Decompiled with CFR 0.152.
 */
package com.datatorrent.lib.util;

import javax.validation.constraints.NotNull;
import org.apache.commons.lang3.ClassUtils;

public class FieldInfo {
    @NotNull
    private String columnName;
    @NotNull
    private String pojoFieldExpression;
    private SupportType type;

    public FieldInfo() {
    }

    public FieldInfo(String columnName, String pojoFieldExpression, SupportType type) {
        this.setColumnName(columnName);
        this.setPojoFieldExpression(pojoFieldExpression);
        this.setType(type);
    }

    public String getColumnName() {
        return this.columnName;
    }

    public void setColumnName(String columnName) {
        this.columnName = columnName;
    }

    public String getPojoFieldExpression() {
        return this.pojoFieldExpression;
    }

    public void setPojoFieldExpression(String expression) {
        this.pojoFieldExpression = expression;
    }

    public int hashCode() {
        return this.columnName.toLowerCase().hashCode();
    }

    public boolean equals(Object obj) {
        if (obj == null || !(obj instanceof FieldInfo)) {
            return false;
        }
        return this.columnName.equalsIgnoreCase(((FieldInfo)obj).getColumnName());
    }

    public SupportType getType() {
        return this.type;
    }

    public void setType(SupportType type) {
        this.type = type;
    }

    public static enum SupportType {
        BOOLEAN(Boolean.class),
        SHORT(Short.class),
        INTEGER(Integer.class),
        LONG(Long.class),
        FLOAT(Float.class),
        DOUBLE(Double.class),
        STRING(String.class),
        OBJECT(Object.class);

        private Class javaType;

        private SupportType(Class javaType) {
            this.javaType = javaType;
        }

        public Class getJavaType() {
            return this.javaType;
        }

        public static SupportType getFromJavaType(Class type) {
            for (SupportType supportType : SupportType.values()) {
                if (supportType.getJavaType() != ClassUtils.primitiveToWrapper((Class)type)) continue;
                return supportType;
            }
            return OBJECT;
        }
    }
}

