/*
 * Decompiled with CFR 0.152.
 */
package com.datatorrent.lib.util;

import com.datatorrent.lib.util.FieldInfo;
import com.datatorrent.lib.util.PojoUtils;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class FieldValueGenerator<T extends FieldInfo> {
    protected Map<T, PojoUtils.Getter<Object, Object>> fieldGetterMap = new HashMap<T, PojoUtils.Getter<Object, Object>>();
    protected Map<T, PojoUtils.Setter<Object, Object>> fieldSetterMap = new HashMap<T, PojoUtils.Setter<Object, Object>>();
    protected Map<String, T> fieldInfoMap = new HashMap<String, T>();

    protected FieldValueGenerator() {
    }

    public static <T extends FieldInfo> FieldValueGenerator<T> getFieldValueGenerator(Class<?> clazz, List<T> fieldInfos) {
        return new FieldValueGenerator<T>(clazz, fieldInfos);
    }

    protected FieldValueGenerator(Class<?> clazz, List<T> fieldInfos) {
        for (FieldInfo fieldInfo : fieldInfos) {
            this.fieldInfoMap.put(fieldInfo.getColumnName(), fieldInfo);
            PojoUtils.Getter getter = PojoUtils.createGetter(clazz, fieldInfo.getPojoFieldExpression(), fieldInfo.getType().getJavaType());
            this.fieldGetterMap.put(fieldInfo, getter);
        }
        for (FieldInfo fieldInfo : fieldInfos) {
            PojoUtils.Setter setter = PojoUtils.createSetter(clazz, fieldInfo.getPojoFieldExpression(), fieldInfo.getType().getJavaType());
            this.fieldSetterMap.put(fieldInfo, setter);
        }
    }

    public void handleFieldsValue(Object obj, FieldValueHandler fieldValueHandler) {
        for (Map.Entry<T, PojoUtils.Getter<Object, Object>> entry : this.fieldGetterMap.entrySet()) {
            PojoUtils.Getter<Object, Object> getter = entry.getValue();
            if (getter == null) continue;
            Object value = getter.get(obj);
            fieldValueHandler.handleFieldValue((FieldInfo)entry.getKey(), value);
        }
    }

    public Map<String, Object> getFieldsValueAsMap(Object obj) {
        HashMap<String, Object> fieldsValue = new HashMap<String, Object>();
        for (Map.Entry<T, PojoUtils.Getter<Object, Object>> entry : this.fieldGetterMap.entrySet()) {
            PojoUtils.Getter<Object, Object> getter = entry.getValue();
            if (getter == null) continue;
            Object value = getter.get(obj);
            fieldsValue.put(((FieldInfo)entry.getKey()).getColumnName(), value);
        }
        return fieldsValue;
    }

    public void setColumnValue(Object instance, String columnName, Object value, ValueConverter<T> valueConverter) {
        FieldInfo fieldInfo = (FieldInfo)this.fieldInfoMap.get(columnName);
        PojoUtils.Setter<Object, Object> setter = this.fieldSetterMap.get(fieldInfo);
        setter.set(instance, valueConverter == null ? value : valueConverter.convertValue(fieldInfo, value));
    }

    public static interface ValueConverter<T extends FieldInfo> {
        public Object convertValue(T var1, Object var2);
    }

    public static interface FieldValueHandler<T extends FieldInfo> {
        public void handleFieldValue(T var1, Object var2);
    }
}

