/*
 * Decompiled with CFR 0.152.
 */
package com.datatorrent.lib.util;

import com.datatorrent.api.Context;
import com.datatorrent.lib.util.FilterOperator;
import java.util.Map;
import javax.script.Invocable;
import javax.script.ScriptContext;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineManager;
import javax.script.ScriptException;
import javax.script.SimpleBindings;
import javax.script.SimpleScriptContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JavaScriptFilterOperator
extends FilterOperator {
    protected transient ScriptEngineManager sem = new ScriptEngineManager();
    protected transient ScriptEngine engine = this.sem.getEngineByName("JavaScript");
    protected transient SimpleScriptContext scriptContext = new SimpleScriptContext();
    protected transient SimpleBindings scriptBindings = new SimpleBindings();
    protected String functionName;
    protected String setupScript;
    private static final Logger LOG = LoggerFactory.getLogger(JavaScriptFilterOperator.class);

    public String getFunctionName() {
        return this.functionName;
    }

    public void setFunctionName(String script) {
        this.functionName = script;
    }

    public String getSetupScript() {
        return this.setupScript;
    }

    public void setSetupScript(String script) {
        this.setupScript = script;
    }

    public void setup(Context.OperatorContext context) {
        this.scriptContext.setBindings(this.scriptBindings, 100);
        this.engine.setContext(this.scriptContext);
        try {
            if (this.setupScript != null) {
                this.engine.eval(this.setupScript, (ScriptContext)this.scriptContext);
            }
        }
        catch (ScriptException ex) {
            LOG.error("script \"{}\" has error", (Object)this.setupScript);
            throw new RuntimeException(ex);
        }
    }

    @Override
    public boolean satisfiesFilter(Object tuple) {
        if (tuple instanceof Map) {
            Map map = (Map)tuple;
            for (Map.Entry entry : map.entrySet()) {
                LOG.debug("Putting {} = {}", entry.getKey(), entry.getValue());
                this.engine.put((String)entry.getKey(), entry.getValue());
            }
        }
        try {
            Object result = ((Invocable)((Object)this.engine)).invokeFunction(this.functionName, new Object[0]);
            if (result instanceof Boolean) {
                return (Boolean)result;
            }
            if (result instanceof Integer) {
                return (Integer)result != 0;
            }
            if (result instanceof Long) {
                return (Long)result != 0L;
            }
            if (result instanceof String) {
                return Boolean.getBoolean((String)result);
            }
            LOG.warn("The script result (type: {}) cannot be converted to boolean. Returning false.", (Object)(result == null ? "null" : result.getClass().getName()));
            return false;
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }
}

