/*
 * Decompiled with CFR 0.152.
 */
package com.datatorrent.lib.util;

import com.esotericsoftware.kryo.Kryo;
import com.esotericsoftware.kryo.io.Input;
import com.esotericsoftware.kryo.io.Output;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Array;
import org.apache.commons.io.IOUtils;

public class KryoCloneUtils<T> {
    private final Kryo kryo;
    private final byte[] bin;
    private final Class<T> clazz;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private KryoCloneUtils(Kryo kryo, T t) {
        this.kryo = kryo;
        ByteArrayOutputStream bos = null;
        Output output = null;
        try {
            bos = new ByteArrayOutputStream();
            output = new Output((OutputStream)bos);
            kryo.writeObject(output, t);
            output.close();
            this.bin = bos.toByteArray();
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly(output);
            IOUtils.closeQuietly((OutputStream)bos);
            throw throwable;
        }
        IOUtils.closeQuietly((OutputStream)output);
        IOUtils.closeQuietly((OutputStream)bos);
        this.clazz = t.getClass();
        kryo.setClassLoader(this.clazz.getClassLoader());
    }

    public T getClone() {
        try (Input input = new Input(this.bin);){
            Object object = this.kryo.readObject(input, this.clazz);
            return (T)object;
        }
    }

    public T[] getClones(int num) {
        Object[] ts = (Object[])Array.newInstance(this.clazz, num);
        try (Input input = new Input(this.bin);){
            for (int i = 0; i < ts.length; ++i) {
                input.rewind();
                ts[i] = this.kryo.readObject(input, this.clazz);
            }
        }
        return ts;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <SRC> SRC cloneObject(Kryo kryo, SRC src) {
        Object object;
        kryo.setClassLoader(src.getClass().getClassLoader());
        ByteArrayOutputStream bos = null;
        Input input = null;
        try {
            bos = new ByteArrayOutputStream();
            Output output = new Output((OutputStream)bos);
            kryo.writeObject(output, src);
            output.close();
            input = new Input(bos.toByteArray());
            object = kryo.readObject(input, src.getClass());
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly(input);
            IOUtils.closeQuietly((OutputStream)bos);
            throw throwable;
        }
        IOUtils.closeQuietly((InputStream)input);
        IOUtils.closeQuietly((OutputStream)bos);
        return (SRC)object;
    }

    public static <SRC> SRC cloneObject(SRC src) {
        return KryoCloneUtils.cloneObject(new Kryo(), src);
    }

    public static <SRC> KryoCloneUtils<SRC> createCloneUtils(SRC template) {
        return KryoCloneUtils.createCloneUtils(new Kryo(), template);
    }

    public static <SRC> KryoCloneUtils<SRC> createCloneUtils(Kryo kryo, SRC template) {
        return new KryoCloneUtils<SRC>(kryo, template);
    }
}

