/*
 * Decompiled with CFR 0.152.
 */
package com.datatorrent.lib.util;

import com.datatorrent.lib.expression.Expression;
import com.datatorrent.lib.expression.JavaExpressionParser;
import com.google.common.base.Preconditions;
import com.google.common.collect.Maps;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.Map;
import org.apache.commons.lang3.ClassUtils;
import org.apache.commons.lang3.StringUtils;
import org.codehaus.commons.compiler.CompileException;
import org.codehaus.commons.compiler.CompilerFactoryFactory;
import org.codehaus.commons.compiler.IScriptEvaluator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PojoUtils {
    private static final Logger logger = LoggerFactory.getLogger(PojoUtils.class);
    public static final String DEFAULT_EXP_OBJECT_PLACEHOLDER = "{$}";
    public static final String DEFAULT_EXP_VAL_PLACEHOLDER = "{#}";
    public static final String DEFAULT_EXPRESSION_OBJ_PLACEHOLDER = "$";
    private static final String OBJECT = "object";
    private static final String VAL = "val";
    private static final String GET = "get";
    private static final String IS = "is";
    private static final String SET = "set";
    private static final Map<Class<?>, Class<?>> primitiveClassToGetterInterface = Maps.newHashMap();
    private static final Map<Class<?>, Class<?>> primitiveClassToSetterInterface = Maps.newHashMap();

    private PojoUtils() {
    }

    public static <T> GetterBoolean<T> createGetterBoolean(Class<? extends T> pojoClass, String getterExpr) {
        return PojoUtils.createGetterBoolean(pojoClass, getterExpr, DEFAULT_EXP_OBJECT_PLACEHOLDER);
    }

    public static <T> GetterBoolean<T> createGetterBoolean(Class<? extends T> pojoClass, String getterExpr, String exprObjectPlaceholder) {
        return (GetterBoolean)PojoUtils.createGetter(pojoClass, getterExpr, exprObjectPlaceholder, Boolean.TYPE, GetterBoolean.class);
    }

    public static <T> GetterByte<T> createGetterByte(Class<? extends T> pojoClass, String getterExpr) {
        return PojoUtils.createGetterByte(pojoClass, getterExpr, DEFAULT_EXP_OBJECT_PLACEHOLDER);
    }

    public static <T> GetterByte<T> createGetterByte(Class<? extends T> pojoClass, String getterExpr, String exprObjectPlaceholder) {
        return (GetterByte)PojoUtils.createGetter(pojoClass, getterExpr, exprObjectPlaceholder, Byte.TYPE, GetterByte.class);
    }

    public static <T> GetterChar<T> createGetterChar(Class<? extends T> pojoClass, String getterExpr) {
        return PojoUtils.createGetterChar(pojoClass, getterExpr, DEFAULT_EXP_OBJECT_PLACEHOLDER);
    }

    public static <T> GetterChar<T> createGetterChar(Class<? extends T> pojoClass, String getterExpr, String exprObjectPlaceholder) {
        return (GetterChar)PojoUtils.createGetter(pojoClass, getterExpr, exprObjectPlaceholder, Character.TYPE, GetterChar.class);
    }

    public static <T> GetterShort<T> createGetterShort(Class<? extends T> pojoClass, String getterExpr) {
        return PojoUtils.createGetterShort(pojoClass, getterExpr, DEFAULT_EXP_OBJECT_PLACEHOLDER);
    }

    public static <T> GetterShort<T> createGetterShort(Class<? extends T> pojoClass, String getterExpr, String exprObjectPlaceholder) {
        return (GetterShort)PojoUtils.createGetter(pojoClass, getterExpr, exprObjectPlaceholder, Short.TYPE, GetterShort.class);
    }

    public static <T> GetterInt<T> createGetterInt(Class<? extends T> pojoClass, String getterExpr) {
        return PojoUtils.createGetterInt(pojoClass, getterExpr, DEFAULT_EXP_OBJECT_PLACEHOLDER);
    }

    public static <T> GetterInt<T> createGetterInt(Class<? extends T> pojoClass, String getterExpr, String exprObjectPlaceholder) {
        return (GetterInt)PojoUtils.createGetter(pojoClass, getterExpr, exprObjectPlaceholder, Integer.TYPE, GetterInt.class);
    }

    public static <T> GetterLong<T> createGetterLong(Class<? extends T> pojoClass, String getterExpr) {
        return PojoUtils.createGetterLong(pojoClass, getterExpr, DEFAULT_EXP_OBJECT_PLACEHOLDER);
    }

    public static <T> GetterLong<T> createGetterLong(Class<? extends T> pojoClass, String getterExpr, String exprObjectPlaceholder) {
        return (GetterLong)PojoUtils.createGetter(pojoClass, getterExpr, exprObjectPlaceholder, Long.TYPE, GetterLong.class);
    }

    public static <T> GetterFloat<T> createGetterFloat(Class<? extends T> pojoClass, String getterExpr) {
        return PojoUtils.createGetterFloat(pojoClass, getterExpr, DEFAULT_EXP_OBJECT_PLACEHOLDER);
    }

    public static <T> GetterFloat<T> createGetterFloat(Class<? extends T> pojoClass, String getterExpr, String exprObjectPlaceholder) {
        return (GetterFloat)PojoUtils.createGetter(pojoClass, getterExpr, exprObjectPlaceholder, Float.TYPE, GetterFloat.class);
    }

    public static <T> GetterDouble<T> createGetterDouble(Class<? extends T> pojoClass, String getterExpr) {
        return PojoUtils.createGetterDouble(pojoClass, getterExpr, DEFAULT_EXP_OBJECT_PLACEHOLDER);
    }

    public static <T> GetterDouble<T> createGetterDouble(Class<? extends T> pojoClass, String getterExpr, String exprObjectPlaceholder) {
        return (GetterDouble)PojoUtils.createGetter(pojoClass, getterExpr, exprObjectPlaceholder, Double.TYPE, GetterDouble.class);
    }

    public static <T, V> Getter<T, V> createGetter(Class<? extends T> pojoClass, String getterExpr, Class<? extends V> exprClass) {
        return PojoUtils.createGetter(pojoClass, getterExpr, DEFAULT_EXP_OBJECT_PLACEHOLDER, exprClass);
    }

    public static <T, V> Getter<T, V> createGetter(Class<? extends T> pojoClass, String getterExpr, String exprObjectPlaceholder, Class<? extends V> exprClass) {
        if (primitiveClassToGetterInterface.get(exprClass) != null) {
            throw new IllegalArgumentException("createGetter does not allow primitive class \"" + exprClass.getName() + "\" for exprClass argument. Use createGetter" + PojoUtils.upperCaseWord(exprClass.getName()) + " or constructGetter().");
        }
        return (Getter)PojoUtils.createGetter(pojoClass, getterExpr, exprObjectPlaceholder, exprClass, Getter.class);
    }

    public static Object constructGetter(Class<?> pojoClass, String getterExpr, Class<?> exprClass) {
        return PojoUtils.constructGetter(pojoClass, getterExpr, DEFAULT_EXP_OBJECT_PLACEHOLDER, exprClass);
    }

    public static Object constructGetter(Class<?> pojoClass, String getterExpr, String exprObjectPlaceholder, Class<?> exprClass) {
        Class<Object> interfaceToImplement = primitiveClassToGetterInterface.get(exprClass);
        if (interfaceToImplement == null) {
            interfaceToImplement = Getter.class;
        }
        return PojoUtils.createGetter(pojoClass, getterExpr, exprObjectPlaceholder, exprClass, interfaceToImplement);
    }

    public static <T> SetterBoolean<T> createSetterBoolean(Class<? extends T> pojoClass, String setterExpr) {
        return PojoUtils.createSetterBoolean(pojoClass, setterExpr, DEFAULT_EXP_OBJECT_PLACEHOLDER, DEFAULT_EXP_VAL_PLACEHOLDER);
    }

    public static <T> SetterBoolean<T> createSetterBoolean(Class<? extends T> pojoClass, String setterExpr, String exprObjectPlaceholder, String exprValuePlaceholder) {
        return (SetterBoolean)PojoUtils.createSetter(pojoClass, setterExpr, exprObjectPlaceholder, exprValuePlaceholder, Boolean.TYPE, SetterBoolean.class);
    }

    public static <T> SetterByte<T> createSetterByte(Class<? extends T> pojoClass, String setterExpr) {
        return PojoUtils.createSetterByte(pojoClass, setterExpr, DEFAULT_EXP_OBJECT_PLACEHOLDER, DEFAULT_EXP_VAL_PLACEHOLDER);
    }

    public static <T> SetterByte<T> createSetterByte(Class<? extends T> pojoClass, String setterExpr, String exprObjectPlaceholder, String exprValuePlaceholder) {
        return (SetterByte)PojoUtils.createSetter(pojoClass, setterExpr, exprObjectPlaceholder, exprValuePlaceholder, Byte.TYPE, SetterByte.class);
    }

    public static <T> SetterChar<T> createSetterChar(Class<? extends T> pojoClass, String setterExpr) {
        return PojoUtils.createSetterChar(pojoClass, setterExpr, DEFAULT_EXP_OBJECT_PLACEHOLDER, DEFAULT_EXP_VAL_PLACEHOLDER);
    }

    public static <T> SetterChar<T> createSetterChar(Class<? extends T> pojoClass, String setterExpr, String exprObjectPlaceholder, String exprValuePlaceholder) {
        return (SetterChar)PojoUtils.createSetter(pojoClass, setterExpr, exprObjectPlaceholder, exprValuePlaceholder, Character.TYPE, SetterChar.class);
    }

    public static <T> SetterShort<T> createSetterShort(Class<? extends T> pojoClass, String setterExpr) {
        return PojoUtils.createSetterShort(pojoClass, setterExpr, DEFAULT_EXP_OBJECT_PLACEHOLDER, DEFAULT_EXP_VAL_PLACEHOLDER);
    }

    public static <T> SetterShort<T> createSetterShort(Class<? extends T> pojoClass, String setterExpr, String exprObjectPlaceholder, String exprValuePlaceholder) {
        return (SetterShort)PojoUtils.createSetter(pojoClass, setterExpr, exprObjectPlaceholder, exprValuePlaceholder, Short.TYPE, SetterShort.class);
    }

    public static <T> SetterInt<T> createSetterInt(Class<? extends T> pojoClass, String setterExpr) {
        return PojoUtils.createSetterInt(pojoClass, setterExpr, DEFAULT_EXP_OBJECT_PLACEHOLDER, DEFAULT_EXP_VAL_PLACEHOLDER);
    }

    public static <T> SetterInt<T> createSetterInt(Class<? extends T> pojoClass, String setterExpr, String exprObjectPlaceholder, String exprValuePlaceholder) {
        return (SetterInt)PojoUtils.createSetter(pojoClass, setterExpr, exprObjectPlaceholder, exprValuePlaceholder, Integer.TYPE, SetterInt.class);
    }

    public static <T> SetterLong<T> createSetterLong(Class<? extends T> pojoClass, String setterExpr) {
        return PojoUtils.createSetterLong(pojoClass, setterExpr, DEFAULT_EXP_OBJECT_PLACEHOLDER, DEFAULT_EXP_VAL_PLACEHOLDER);
    }

    public static <T> SetterLong<T> createSetterLong(Class<? extends T> pojoClass, String setterExpr, String exprObjectPlaceholder, String exprValuePlaceholder) {
        return (SetterLong)PojoUtils.createSetter(pojoClass, setterExpr, exprObjectPlaceholder, exprValuePlaceholder, Long.TYPE, SetterLong.class);
    }

    public static <T> SetterFloat<T> createSetterFloat(Class<? extends T> pojoClass, String setterExpr) {
        return PojoUtils.createSetterFloat(pojoClass, setterExpr, DEFAULT_EXP_OBJECT_PLACEHOLDER, DEFAULT_EXP_VAL_PLACEHOLDER);
    }

    public static <T> SetterFloat<T> createSetterFloat(Class<? extends T> pojoClass, String setterExpr, String exprObjectPlaceholder, String exprValuePlaceholder) {
        return (SetterFloat)PojoUtils.createSetter(pojoClass, setterExpr, exprObjectPlaceholder, exprValuePlaceholder, Float.TYPE, SetterFloat.class);
    }

    public static <T> SetterDouble<T> createSetterDouble(Class<? extends T> pojoClass, String setterExpr) {
        return PojoUtils.createSetterDouble(pojoClass, setterExpr, DEFAULT_EXP_OBJECT_PLACEHOLDER, DEFAULT_EXP_VAL_PLACEHOLDER);
    }

    public static <T> SetterDouble<T> createSetterDouble(Class<? extends T> pojoClass, String setterExpr, String exprObjectPlaceholder, String exprValuePlaceholder) {
        return (SetterDouble)PojoUtils.createSetter(pojoClass, setterExpr, exprObjectPlaceholder, exprValuePlaceholder, Double.TYPE, SetterDouble.class);
    }

    public static <T, V> Setter<T, V> createSetter(Class<? extends T> pojoClass, String setterExpr, Class<? extends V> exprClass) {
        return PojoUtils.createSetter(pojoClass, setterExpr, DEFAULT_EXP_OBJECT_PLACEHOLDER, DEFAULT_EXP_VAL_PLACEHOLDER, exprClass);
    }

    public static <T, V> Setter<T, V> createSetter(Class<? extends T> pojoClass, String setterExpr, String exprObjectPlaceholder, String exprValuePlaceholder, Class<? extends V> exprClass) {
        if (primitiveClassToSetterInterface.get(exprClass) != null) {
            throw new IllegalArgumentException("createSetter does not allow primitive class \"" + exprClass.getName() + "\" for exprClass argument. Use createSetter" + PojoUtils.upperCaseWord(exprClass.getName()) + " or constructSetter().");
        }
        return (Setter)PojoUtils.createSetter(pojoClass, setterExpr, exprObjectPlaceholder, exprValuePlaceholder, exprClass, Setter.class);
    }

    public static Object constructSetter(Class<?> pojoClass, String setterExpr, Class<?> exprClass) {
        return PojoUtils.constructSetter(pojoClass, setterExpr, DEFAULT_EXP_OBJECT_PLACEHOLDER, DEFAULT_EXP_VAL_PLACEHOLDER, exprClass);
    }

    public static Object constructSetter(Class<?> pojoClass, String setterExpr, String exprObjectPlaceholder, String exprValPlaceholder, Class<?> exprClass) {
        Class<Object> interfaceToImplement = primitiveClassToSetterInterface.get(exprClass);
        if (interfaceToImplement == null) {
            interfaceToImplement = Setter.class;
        }
        return PojoUtils.createSetter(pojoClass, setterExpr, exprObjectPlaceholder, exprValPlaceholder, exprClass, interfaceToImplement);
    }

    private static String upperCaseWord(String field) {
        Preconditions.checkArgument((!field.isEmpty() ? 1 : 0) != 0, (Object)field);
        return field.substring(0, 1).toUpperCase() + field.substring(1);
    }

    private static String getSingleFieldGetterExpression(Class<?> pojoClass, String fieldExpression, Class<?> exprClass) {
        Method method;
        JavaReturnStatement code = new JavaReturnStatement(pojoClass.getName().length() + fieldExpression.length() + exprClass.getName().length() + 32, exprClass);
        ((JavaStatement)code).appendCastToTypeExpr(pojoClass, OBJECT).append(".");
        try {
            Field field = pojoClass.getField(fieldExpression);
            if (ClassUtils.isAssignable(field.getType(), exprClass)) {
                return code.append(field.getName()).getStatement();
            }
            logger.debug("Field {} can not be assigned to {}. Proceeding to locate a getter method.", (Object)field, exprClass);
        }
        catch (NoSuchFieldException ex) {
            logger.debug("{} does not have field {}. Proceeding to locate a getter method.", pojoClass, (Object)fieldExpression);
        }
        catch (SecurityException ex) {
            logger.debug("{} does not have field {}. Proceeding to locate a getter method.", pojoClass, (Object)fieldExpression);
        }
        String methodName = GET + PojoUtils.upperCaseWord(fieldExpression);
        try {
            method = pojoClass.getMethod(methodName, new Class[0]);
            if (ClassUtils.isAssignable(method.getReturnType(), exprClass)) {
                return code.append(methodName).append("()").getStatement();
            }
            logger.debug("method {} of the {} returns {} that can not be assigned to {}. Proceeding to locate another getter method.", new Object[]{pojoClass, methodName, method.getReturnType(), exprClass});
        }
        catch (NoSuchMethodException | SecurityException ex) {
            logger.debug("{} does not have method {}. Proceeding to locate another getter method.", pojoClass, (Object)methodName);
        }
        methodName = IS + PojoUtils.upperCaseWord(fieldExpression);
        try {
            method = pojoClass.getMethod(methodName, new Class[0]);
            if (ClassUtils.isAssignable(method.getReturnType(), exprClass)) {
                return code.append(methodName).append("()").getStatement();
            }
            logger.debug("method {} of the {} returns {} that can not be assigned to {}. Proceeding with the original expression {}.", new Object[]{pojoClass, methodName, method.getReturnType(), exprClass, fieldExpression});
        }
        catch (NoSuchMethodException | SecurityException ex) {
            logger.debug("{} does not have method {}. Proceeding with the original expression {}.", new Object[]{pojoClass, methodName, fieldExpression});
        }
        return code.append(fieldExpression).getStatement();
    }

    private static Object createGetter(Class<?> pojoClass, String getterExpr, String exprObjectPlaceholder, Class<?> exprClass, Class<?> getterClass) {
        logger.debug("{} {} {} {}", new Object[]{pojoClass, getterExpr, exprClass, getterClass});
        JavaExpressionParser javaExpressionParser = new JavaExpressionParser();
        javaExpressionParser.setInputObjectPlaceholder(DEFAULT_EXPRESSION_OBJ_PLACEHOLDER, OBJECT);
        String code = javaExpressionParser.convertToCompilableExpression(getterExpr, pojoClass, exprClass);
        return PojoUtils.compileExpression(code, getterClass, new String[]{OBJECT});
    }

    private static String getSingleFieldSetterExpression(Class<?> pojoClass, String fieldExpression, Class<?> exprClass) {
        JavaStatement code = new JavaStatement(pojoClass.getName().length() + fieldExpression.length() + exprClass.getName().length() + 32);
        code.appendCastToTypeExpr(pojoClass, OBJECT).append(".");
        try {
            Field field = pojoClass.getField(fieldExpression);
            if (ClassUtils.isAssignable(exprClass, field.getType())) {
                return code.append(field.getName()).append(" = ").appendCastToTypeExpr(exprClass, VAL).getStatement();
            }
            logger.debug("{} can not be assigned to {}. Proceeding to locate a setter method.", exprClass, (Object)field);
        }
        catch (NoSuchFieldException ex) {
            logger.debug("{} does not have field {}. Proceeding to locate a setter method.", pojoClass, (Object)fieldExpression);
        }
        catch (SecurityException ex) {
            logger.debug("{} does not have field {}. Proceeding to locate a setter method.", pojoClass, (Object)fieldExpression);
        }
        String setMethodName = SET + PojoUtils.upperCaseWord(fieldExpression);
        Method bestMatchMethod = null;
        ArrayList<Method> candidates = new ArrayList<Method>();
        for (Method method : pojoClass.getMethods()) {
            Class<?>[] parameterTypes;
            if (!setMethodName.equals(method.getName()) || (parameterTypes = method.getParameterTypes()).length != 1) continue;
            if (exprClass == parameterTypes[0]) {
                bestMatchMethod = method;
                break;
            }
            if (!ClassUtils.isAssignable(exprClass, parameterTypes[0])) continue;
            candidates.add(method);
        }
        if (bestMatchMethod == null) {
            if (candidates.size() == 0) {
                logger.debug("{} does not have suitable setter method {}. Returning original expression {}.", new Object[]{pojoClass, setMethodName, fieldExpression});
                return code.append(fieldExpression).append(" = ").appendCastToTypeExpr(exprClass, VAL).getStatement();
            }
            bestMatchMethod = (Method)candidates.get(0);
        }
        return code.append(bestMatchMethod.getName()).append("(").appendCastToTypeExpr(exprClass, VAL).append(")").getStatement();
    }

    private static Object createSetter(Class<?> pojoClass, String setterExpr, String exprObjectPlaceholder, String exprValPlaceholder, Class<?> exprClass, Class<?> setterClass) {
        if (setterExpr.startsWith(".")) {
            setterExpr = setterExpr.substring(1);
        }
        if (setterExpr.isEmpty()) {
            throw new IllegalArgumentException("The setter expression: \"" + setterExpr + "\" is invalid.");
        }
        logger.debug("{} {} {} {}", new Object[]{pojoClass, setterExpr, exprClass, setterClass});
        String code = StringUtils.replaceEach((String)setterExpr, (String[])new String[]{exprObjectPlaceholder, exprValPlaceholder}, (String[])new String[]{new JavaStatement().appendCastToTypeExpr(pojoClass, OBJECT).toString(), new JavaStatement().appendCastToTypeExpr(exprClass, VAL).toString()});
        if (code != setterExpr) {
            code = new JavaStatement(code.length() + 1).append(code).getStatement();
            logger.debug("Original expression {} is a complex expression. Replacing it with {}.", (Object)setterExpr, (Object)code);
        } else {
            code = PojoUtils.getSingleFieldSetterExpression(pojoClass, setterExpr, exprClass);
        }
        return PojoUtils.compileExpression(code, setterClass, new String[]{OBJECT, VAL});
    }

    public static Expression createExpression(Class<?> inputType, String expr, Class<?> returnType) {
        return PojoUtils.createExpression(inputType, expr, returnType, null);
    }

    public static Expression createExpression(Class<?> inputType, String expr, Class<?> returnType, String[] defaultImports) {
        JavaExpressionParser javaExpressionParser = new JavaExpressionParser();
        javaExpressionParser.setInputObjectPlaceholder(DEFAULT_EXPRESSION_OBJ_PLACEHOLDER, OBJECT);
        return PojoUtils.createExpression(inputType, expr, returnType, defaultImports, javaExpressionParser);
    }

    public static Expression createExpression(Class<?> inputType, String expr, Class<?> returnType, String[] defaultImports, Expression.ExpressionParser parser) {
        String code = parser.convertToCompilableExpression(expr, inputType, returnType);
        return (Expression)PojoUtils.compileExpression(code, Expression.class, new String[]{OBJECT}, defaultImports);
    }

    private static Object compileExpression(String code, Class<?> implClass, String[] params) {
        return PojoUtils.compileExpression(code, implClass, params, null);
    }

    private static Object compileExpression(String code, Class<?> implClass, String[] params, String[] defaultImports) {
        IScriptEvaluator se;
        LinkedList<String> imports = new LinkedList<String>();
        if (defaultImports != null && defaultImports.length != 0) {
            for (String defaultImport : defaultImports) {
                if (defaultImport == null) continue;
                if (!defaultImport.startsWith("static")) {
                    imports.add("static " + defaultImport);
                    continue;
                }
                imports.add(defaultImport);
            }
        }
        try {
            se = CompilerFactoryFactory.getDefaultCompilerFactory().newScriptEvaluator();
            se.setDefaultImports(imports.toArray(new String[imports.size()]));
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
        try {
            logger.debug("code: {}", (Object)code);
            return se.createFastEvaluator(code, implClass, params);
        }
        catch (CompileException ex) {
            throw new RuntimeException(ex);
        }
    }

    static {
        primitiveClassToGetterInterface.put(Boolean.TYPE, GetterBoolean.class);
        primitiveClassToGetterInterface.put(Byte.TYPE, GetterByte.class);
        primitiveClassToGetterInterface.put(Character.TYPE, GetterChar.class);
        primitiveClassToGetterInterface.put(Short.TYPE, GetterShort.class);
        primitiveClassToGetterInterface.put(Integer.TYPE, GetterInt.class);
        primitiveClassToGetterInterface.put(Long.TYPE, GetterLong.class);
        primitiveClassToGetterInterface.put(Float.TYPE, GetterFloat.class);
        primitiveClassToGetterInterface.put(Double.TYPE, GetterDouble.class);
        primitiveClassToSetterInterface.put(Boolean.TYPE, SetterBoolean.class);
        primitiveClassToSetterInterface.put(Byte.TYPE, SetterByte.class);
        primitiveClassToSetterInterface.put(Character.TYPE, SetterChar.class);
        primitiveClassToSetterInterface.put(Short.TYPE, SetterShort.class);
        primitiveClassToSetterInterface.put(Integer.TYPE, SetterInt.class);
        primitiveClassToSetterInterface.put(Long.TYPE, SetterLong.class);
        primitiveClassToSetterInterface.put(Float.TYPE, SetterFloat.class);
        primitiveClassToSetterInterface.put(Double.TYPE, SetterDouble.class);
    }

    private static class JavaReturnStatement
    extends JavaStatement {
        private JavaReturnStatement(Class<?> returnType) {
            this.append("return (").append(returnType.getName()).append(")");
        }

        private JavaReturnStatement(int length, Class<?> returnType) {
            super(length);
            this.append("return ((").append(returnType.getName()).append(")");
        }

        @Override
        protected String getStatement() {
            this.append(")");
            return super.getStatement();
        }
    }

    private static class JavaStatement {
        private final StringBuilder javaStatement;
        private final int capacity;

        private JavaStatement() {
            this.javaStatement = new StringBuilder();
            this.capacity = this.javaStatement.capacity();
        }

        private JavaStatement(int length) {
            this.javaStatement = new StringBuilder(length);
            this.capacity = this.javaStatement.capacity();
        }

        public String toString() {
            return this.javaStatement.toString();
        }

        protected JavaStatement append(String string) {
            this.javaStatement.append(string);
            return this;
        }

        private JavaStatement appendCastToTypeExpr(Class<?> type, String expr) {
            return this.append("((").append(type.getName()).append(")(").append(expr).append("))");
        }

        protected String getStatement() {
            if (this.capacity < this.javaStatement.length() + 1) {
                logger.debug("Java statement capacity {} was not sufficient for the statement length {}. Actual statement {}", new Object[]{this.capacity, this.javaStatement.length(), this.javaStatement});
            }
            return this.javaStatement.append(";").toString();
        }
    }

    public static interface Setter<T, V> {
        public void set(T var1, V var2);
    }

    public static interface SetterDouble<T> {
        public void set(T var1, double var2);
    }

    public static interface SetterFloat<T> {
        public void set(T var1, float var2);
    }

    public static interface SetterLong<T> {
        public void set(T var1, long var2);
    }

    public static interface SetterInt<T> {
        public void set(T var1, int var2);
    }

    public static interface SetterShort<T> {
        public void set(T var1, short var2);
    }

    public static interface SetterChar<T> {
        public void set(T var1, char var2);
    }

    public static interface SetterByte<T> {
        public void set(T var1, byte var2);
    }

    public static interface SetterBoolean<T> {
        public void set(T var1, boolean var2);
    }

    public static interface Getter<T, V> {
        public V get(T var1);
    }

    public static interface GetterDouble<T> {
        public double get(T var1);
    }

    public static interface GetterFloat<T> {
        public float get(T var1);
    }

    public static interface GetterLong<T> {
        public long get(T var1);
    }

    public static interface GetterInt<T> {
        public int get(T var1);
    }

    public static interface GetterShort<T> {
        public short get(T var1);
    }

    public static interface GetterChar<T> {
        public char get(T var1);
    }

    public static interface GetterByte<T> {
        public byte get(T var1);
    }

    public static interface GetterBoolean<T> {
        public boolean get(T var1);
    }
}

