/*
 * Decompiled with CFR 0.152.
 */
package com.datatorrent.lib.util;

import java.io.IOException;
import java.io.Reader;

public class ReusableStringReader
extends Reader {
    private String str;
    private int length;
    private int next = 0;

    @Override
    public int read(char[] cbuf, int off, int len) throws IOException {
        this.ensureOpen();
        if (off < 0 || off > cbuf.length || len < 0 || off + len > cbuf.length || off + len < 0) {
            throw new IndexOutOfBoundsException();
        }
        if (len == 0) {
            return 0;
        }
        if (this.next >= this.length) {
            return -1;
        }
        int n = Math.min(this.length - this.next, len);
        this.str.getChars(this.next, this.next + n, cbuf, off);
        this.next += n;
        return n;
    }

    @Override
    public int read() throws IOException {
        this.ensureOpen();
        if (this.next >= this.length) {
            return -1;
        }
        return this.str.charAt(this.next++);
    }

    @Override
    public boolean ready() throws IOException {
        this.ensureOpen();
        return true;
    }

    @Override
    public void close() throws IOException {
        this.str = null;
    }

    private void ensureOpen() throws IOException {
        if (this.str == null) {
            throw new IOException("Stream closed");
        }
    }

    public void open(String str) throws IOException {
        this.str = str;
        this.length = this.str.length();
        this.next = 0;
    }

    public boolean isOpen() {
        return this.str != null;
    }
}

