/*
 * Decompiled with CFR 0.152.
 */
package com.datatorrent.lib.util;

import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.TimeZone;

public class TimeBucketKey {
    private static final int TIMESPEC_MINUTE = 1;
    private static final int TIMESPEC_HOUR = 2;
    private static final int TIMESPEC_DAY = 4;
    private static final int TIMESPEC_WEEK = 8;
    private static final int TIMESPEC_MONTH = 16;
    private static final int TIMESPEC_YEAR = 32;
    public static final int TIMESPEC_YEAR_SPEC = 32;
    public static final int TIMESPEC_MONTH_SPEC = 48;
    public static final int TIMESPEC_WEEK_SPEC = 40;
    public static final int TIMESPEC_DAY_SPEC = 52;
    public static final int TIMESPEC_HOUR_SPEC = 54;
    public static final int TIMESPEC_MINUTE_SPEC = 55;
    private static DateFormat yearDateFormat = new SimpleDateFormat("'Y|'yyyy");
    private static DateFormat monthDateFormat = new SimpleDateFormat("'M|'yyyyMM");
    private static DateFormat weekDateFormat = new SimpleDateFormat("'W|'yyyyww");
    private static DateFormat dayDateFormat = new SimpleDateFormat("'D|'yyyyMMdd");
    private static DateFormat hourDateFormat = new SimpleDateFormat("'h|'yyyyMMddHH");
    private static DateFormat minuteDateFormat = new SimpleDateFormat("'m|'yyyyMMddHHmm");
    private static final long MILLIS_IN_MIN = 60000L;
    private static final long MILLIS_IN_HOUR = 3600000L;
    private static final long MILLIS_IN_DAY = 86400000L;
    private static final long MILLIS_IN_WEEK = 604800000L;
    private Calendar time;
    private int timeSpec;

    public TimeBucketKey() {
    }

    public TimeBucketKey(Calendar time, int timeSpec) {
        this.time = time;
        this.timeSpec = timeSpec;
    }

    public Calendar getTime() {
        return this.time;
    }

    public void setTime(Calendar time) {
        this.time = time;
    }

    public int getTimeSpec() {
        return this.timeSpec;
    }

    public void setTimeSpec(int timeSpec) {
        this.timeSpec = timeSpec;
    }

    public int hashCode() {
        int hashcode = 0;
        if ((this.timeSpec & 0x20) != 0) {
            int year = this.time.get(1);
            hashcode += year - 2000 << 22;
        }
        if ((this.timeSpec & 0x10) != 0) {
            hashcode += this.time.get(2) << 16;
        }
        if ((this.timeSpec & 8) != 0) {
            hashcode += this.time.get(3) << 16;
        }
        if ((this.timeSpec & 4) != 0) {
            hashcode += this.time.get(5) << 11;
        }
        if ((this.timeSpec & 2) != 0) {
            hashcode += this.time.get(11) << 6;
        }
        if ((this.timeSpec & 1) != 0) {
            hashcode += this.time.get(12);
        }
        return hashcode;
    }

    public boolean equals(Object obj) {
        boolean equal = false;
        if (obj instanceof TimeBucketKey) {
            TimeBucketKey ckey = (TimeBucketKey)obj;
            if (this.timeSpec == 55) {
                equal = this.time.getTimeInMillis() / 60000L == ckey.getTime().getTimeInMillis() / 60000L;
            } else if (this.timeSpec == 54) {
                equal = this.time.getTimeInMillis() / 3600000L == ckey.getTime().getTimeInMillis() / 3600000L;
            } else if (this.timeSpec == 52) {
                equal = this.time.getTimeInMillis() / 86400000L == ckey.getTime().getTimeInMillis() / 86400000L;
            } else if (this.timeSpec == 40) {
                equal = this.time.getTimeInMillis() / 604800000L == ckey.getTime().getTimeInMillis() / 604800000L;
            } else {
                boolean chkEqual = true;
                if ((this.timeSpec & 0x20) != 0 && this.time.get(1) != ckey.getTime().get(1)) {
                    chkEqual = false;
                }
                if (chkEqual && (this.timeSpec & 0x10) != 0 && this.time.get(2) != ckey.getTime().get(2)) {
                    chkEqual = false;
                }
                equal = chkEqual;
            }
        }
        return equal;
    }

    public String toString() {
        Date date = this.time.getTime();
        if (this.timeSpec == 32) {
            return yearDateFormat.format(date);
        }
        if (this.timeSpec == 48) {
            return monthDateFormat.format(date);
        }
        if (this.timeSpec == 40) {
            return weekDateFormat.format(date);
        }
        if (this.timeSpec == 52) {
            return dayDateFormat.format(date);
        }
        if (this.timeSpec == 54) {
            return hourDateFormat.format(date);
        }
        if (this.timeSpec == 55) {
            return minuteDateFormat.format(date);
        }
        return null;
    }

    static {
        TimeZone tz = TimeZone.getTimeZone("GMT");
        yearDateFormat.setTimeZone(tz);
        monthDateFormat.setTimeZone(tz);
        weekDateFormat.setTimeZone(tz);
        dayDateFormat.setTimeZone(tz);
        hourDateFormat.setTimeZone(tz);
        minuteDateFormat.setTimeZone(tz);
    }
}

