/*
 * Decompiled with CFR 0.152.
 */
package com.datatorrent.lib.util;

import com.datatorrent.lib.util.ReversibleComparator;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.PriorityQueue;
import javax.validation.constraints.Min;

public class TopNSort<E> {
    @Min(value=1L)
    int qbound = Integer.MAX_VALUE;
    boolean ascending = true;
    PriorityQueue<E> q = null;

    @Min(value=1L)
    public int getQbound() {
        return this.qbound;
    }

    public void setQbound(int i) {
        this.qbound = i;
    }

    public TopNSort() {
    }

    public TopNSort(int initialCapacity, int bound, boolean flag) {
        this.ascending = flag;
        this.q = new PriorityQueue(initialCapacity, new ReversibleComparator(flag));
        this.qbound = bound;
    }

    public boolean add(E e) {
        return this.offer(e);
    }

    public int size() {
        return this.q.size();
    }

    public void clear() {
        this.q.clear();
    }

    public boolean isEmpty() {
        return this.q.isEmpty();
    }

    public List<E> getTopN(int n) {
        E v;
        ArrayList<E> list = new ArrayList<E>();
        for (int j = 0; (v = this.q.poll()) != null && j < n; ++j) {
            list.add(v);
        }
        if (list.isEmpty()) {
            return list;
        }
        Collections.reverse(list);
        return list;
    }

    public boolean offer(E e) {
        boolean insert;
        if (this.q.size() < this.qbound) {
            return this.q.offer(e);
        }
        boolean ret = false;
        Comparable head = (Comparable)this.q.peek();
        if (this.ascending) {
            insert = head.compareTo(e) <= 0;
        } else {
            boolean bl = insert = head.compareTo(e) >= 0;
        }
        if (insert && this.q.offer(e)) {
            ret = true;
            this.q.poll();
        }
        return ret;
    }
}

