/*
 * Decompiled with CFR 0.152.
 */
package com.datatorrent.lib.util;

import com.datatorrent.lib.util.ReversibleComparator;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.PriorityQueue;
import javax.validation.constraints.Min;
import org.apache.commons.lang.mutable.MutableInt;

public class TopNUniqueSort<E> {
    @Min(value=1L)
    int qbound = Integer.MAX_VALUE;
    boolean ascending = true;
    HashMap<E, MutableInt> hmap = null;
    PriorityQueue<E> q = null;

    @Min(value=1L)
    public int getQbound() {
        return this.qbound;
    }

    public void setQbound(int i) {
        this.qbound = i;
    }

    public TopNUniqueSort() {
    }

    public TopNUniqueSort(int initialCapacity, int bound, boolean flag) {
        this.ascending = flag;
        this.q = new PriorityQueue(initialCapacity, new ReversibleComparator(flag));
        this.qbound = bound;
        this.hmap = new HashMap();
    }

    public boolean add(E e) {
        return this.offer(e);
    }

    public int size() {
        return this.q.size();
    }

    public void clear() {
        this.q.clear();
    }

    public boolean isEmpty() {
        return this.q.isEmpty();
    }

    public ArrayList getTopN(int n) {
        E v;
        ArrayList<E> list = new ArrayList<E>();
        for (int j = 0; (v = this.q.poll()) != null && j < n; ++j) {
            list.add(v);
        }
        ArrayList ret = new ArrayList(list.size());
        int size = list.size();
        int depth = size;
        if (depth > n) {
            depth = n;
        }
        for (int i = 0; i < depth; ++i) {
            Object o = list.get(size - i - 1);
            HashMap val = new HashMap(1);
            MutableInt ival = this.hmap.get(o);
            val.put(o, ival.toInteger());
            ret.add(val);
        }
        return ret;
    }

    public boolean offer(E e) {
        boolean insert;
        MutableInt ival = this.hmap.get(e);
        if (ival != null) {
            ival.increment();
            return true;
        }
        if (this.q.size() < this.qbound) {
            if (ival == null) {
                this.hmap.put(e, new MutableInt(1));
            }
            return this.q.offer(e);
        }
        boolean ret = false;
        Comparable head = (Comparable)this.q.peek();
        if (this.ascending) {
            insert = head.compareTo(e) < 0;
        } else {
            boolean bl = insert = head.compareTo(e) > 0;
        }
        if (insert && this.q.offer(e)) {
            this.hmap.put(e, new MutableInt(1));
            ret = true;
            E drop = this.q.poll();
            this.hmap.remove(drop);
        }
        return ret;
    }
}

