/*
 * Decompiled with CFR 0.152.
 */
package com.datatorrent.lib.util.time;

import com.datatorrent.api.Context;
import com.google.common.base.Preconditions;
import java.math.BigDecimal;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WindowUtils {
    private static final Logger LOG = LoggerFactory.getLogger(WindowUtils.class);

    public static long getAppWindowDurationMs(Context.OperatorContext context) {
        return ((Integer)context.getValue(Context.DAGContext.STREAMING_WINDOW_SIZE_MILLIS)).longValue() * ((Integer)context.getValue(Context.OperatorContext.APPLICATION_WINDOW_COUNT)).longValue();
    }

    public static long msToAppWindowCount(Context.OperatorContext context, long millis) {
        Preconditions.checkArgument((millis > 0L ? 1 : 0) != 0);
        long appWindowDurationMS = WindowUtils.getAppWindowDurationMs(context);
        long appWindowCount = millis / appWindowDurationMS;
        if (millis % appWindowDurationMS != 0L) {
            ++appWindowCount;
        }
        return appWindowCount;
    }

    public static long tpsToTpw(Context.OperatorContext context, long tuplesPerSecond) {
        Preconditions.checkArgument((tuplesPerSecond > 0L ? 1 : 0) != 0);
        BigDecimal tuplesPerWindow = new BigDecimal(WindowUtils.getAppWindowDurationMs(context));
        tuplesPerWindow = tuplesPerWindow.divide(new BigDecimal(1000));
        tuplesPerWindow = tuplesPerWindow.multiply(new BigDecimal(tuplesPerSecond));
        Preconditions.checkArgument((tuplesPerWindow.compareTo(new BigDecimal(Long.MAX_VALUE)) <= 0 ? 1 : 0) != 0, (Object)"Overflow computing tuples per window.");
        tuplesPerWindow = tuplesPerWindow.stripTrailingZeros();
        long tuplesPerWindowLong = tuplesPerWindow.longValue();
        if (tuplesPerWindow.scale() > 0) {
            LOG.debug("{}", (Object)tuplesPerWindow);
            ++tuplesPerWindowLong;
        }
        return tuplesPerWindowLong;
    }
}

