/*
 * Decompiled with CFR 0.152.
 */
package com.datatorrent.lib.xml;

import com.datatorrent.api.Context;
import com.datatorrent.api.DefaultInputPort;
import com.datatorrent.common.util.BaseOperator;
import com.datatorrent.netlet.util.DTThrowable;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.hadoop.classification.InterfaceStability;
import org.w3c.dom.Document;
import org.xml.sax.InputSource;

@InterfaceStability.Evolving
public abstract class AbstractXmlDOMOperator<T>
extends BaseOperator {
    protected transient DocumentBuilderFactory docFactory;
    protected transient DocumentBuilder docBuilder;
    public transient DefaultInputPort<T> input = new DefaultInputPort<T>(){

        public void process(T tuple) {
            AbstractXmlDOMOperator.this.processTuple(tuple);
        }
    };

    public void setup(Context.OperatorContext context) {
        try {
            this.docFactory = DocumentBuilderFactory.newInstance();
            this.docBuilder = this.docFactory.newDocumentBuilder();
        }
        catch (ParserConfigurationException e) {
            throw new RuntimeException(e);
        }
    }

    protected void processTuple(T tuple) {
        try {
            InputSource source = this.getInputSource(tuple);
            Document document = this.docBuilder.parse(source);
            this.processDocument(document, tuple);
        }
        catch (Exception e) {
            DTThrowable.rethrow((Exception)e);
        }
    }

    protected abstract InputSource getInputSource(T var1);

    protected abstract void processDocument(Document var1, T var2);
}

