/*
 * Decompiled with CFR 0.152.
 */
package org.apache.apex.malhar.lib.dimensions;

import com.datatorrent.lib.appdata.schemas.CustomTimeBucket;
import com.google.common.base.Preconditions;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public class CustomTimeBucketRegistry
implements Serializable {
    private static final long serialVersionUID = 201509221536L;
    private int currentId;
    private Int2ObjectMap<CustomTimeBucket> idToTimeBucket = new Int2ObjectOpenHashMap();
    private Object2IntMap<CustomTimeBucket> timeBucketToId = new Object2IntOpenHashMap();
    private Map<String, CustomTimeBucket> textToTimeBucket = new HashMap<String, CustomTimeBucket>();

    public CustomTimeBucketRegistry() {
    }

    public CustomTimeBucketRegistry(int startingId) {
        this.currentId = startingId;
    }

    public CustomTimeBucketRegistry(Int2ObjectMap<CustomTimeBucket> idToTimeBucket) {
        this.initialize(idToTimeBucket);
    }

    public CustomTimeBucketRegistry(Int2ObjectMap<CustomTimeBucket> idToTimeBucket, int startingId) {
        int tempId = this.initialize(idToTimeBucket);
        Preconditions.checkArgument((tempId < startingId ? 1 : 0) != 0, (Object)("The statingId " + startingId + " must be larger than the largest ID " + tempId + " in the given idToTimeBucket mapping"));
        this.idToTimeBucket = (Int2ObjectMap)Preconditions.checkNotNull(idToTimeBucket);
        this.currentId = startingId;
    }

    private int initialize(Int2ObjectMap<CustomTimeBucket> idToTimeBucket) {
        Preconditions.checkNotNull(idToTimeBucket);
        int tempId = Integer.MIN_VALUE;
        Iterator i$ = idToTimeBucket.keySet().iterator();
        while (i$.hasNext()) {
            int timeBucketId = (Integer)i$.next();
            tempId = Math.max(tempId, timeBucketId);
            CustomTimeBucket customTimeBucket = (CustomTimeBucket)idToTimeBucket.get(timeBucketId);
            this.textToTimeBucket.put(customTimeBucket.getText(), customTimeBucket);
            Preconditions.checkNotNull((Object)customTimeBucket);
            this.timeBucketToId.put((Object)customTimeBucket, timeBucketId);
        }
        return tempId;
    }

    public CustomTimeBucket getTimeBucket(int timeBucketId) {
        return (CustomTimeBucket)this.idToTimeBucket.get(timeBucketId);
    }

    public Integer getTimeBucketId(CustomTimeBucket timeBucket) {
        if (!this.timeBucketToId.containsKey((Object)timeBucket)) {
            return null;
        }
        return (Integer)this.timeBucketToId.get((Object)timeBucket);
    }

    public CustomTimeBucket getTimeBucket(String text) {
        return this.textToTimeBucket.get(text);
    }

    public void register(CustomTimeBucket timeBucket) {
        this.register(timeBucket, this.currentId);
    }

    public void register(CustomTimeBucket timeBucket, int timeBucketId) {
        if (this.timeBucketToId.containsKey((Object)timeBucket)) {
            throw new IllegalArgumentException("The timeBucket " + timeBucket + " is already registered.");
        }
        if (this.timeBucketToId.containsValue(timeBucketId)) {
            throw new IllegalArgumentException("The timeBucketId " + timeBucketId + " is already registered.");
        }
        this.idToTimeBucket.put(timeBucketId, (Object)timeBucket);
        this.timeBucketToId.put((Object)timeBucket, timeBucketId);
        if (timeBucketId >= this.currentId) {
            this.currentId = timeBucketId + 1;
        }
        this.textToTimeBucket.put(timeBucket.getText(), timeBucket);
    }

    public String toString() {
        return "CustomTimeBucketRegistry{idToTimeBucket=" + this.idToTimeBucket + '}';
    }
}

