/*
 * Decompiled with CFR 0.152.
 */
package org.apache.apex.malhar.lib.dimensions;

import com.datatorrent.lib.appdata.schemas.CustomTimeBucket;
import com.datatorrent.lib.appdata.schemas.Fields;
import com.datatorrent.lib.appdata.schemas.FieldsDescriptor;
import com.datatorrent.lib.appdata.schemas.TimeBucket;
import com.datatorrent.lib.appdata.schemas.Type;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.io.Serializable;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DimensionsDescriptor
implements Serializable,
Comparable<DimensionsDescriptor> {
    private static final long serialVersionUID = 201506251237L;
    public static final String DIMENSION_TIME = "time";
    public static final Type DIMENSION_TIME_TYPE = Type.LONG;
    public static final String DIMENSION_TIME_BUCKET = "timeBucket";
    public static final Type DIMENSION_TIME_BUCKET_TYPE = Type.INTEGER;
    public static final Fields TIME_FIELDS = new Fields(Sets.newHashSet((Object[])new String[]{"time"}));
    public static final Set<String> RESERVED_DIMENSION_NAMES = ImmutableSet.of((Object)"time", (Object)"timeBucket");
    public static final String DELIMETER_EQUALS = "=";
    public static final String DELIMETER_SEPERATOR = ":";
    public static final Map<String, Type> DIMENSION_FIELD_TO_TYPE;
    private TimeBucket timeBucket;
    private CustomTimeBucket customTimeBucket;
    private Fields fields;
    private static final Logger LOG;

    private DimensionsDescriptor() {
    }

    @Deprecated
    public DimensionsDescriptor(TimeBucket timeBucket, Fields fields) {
        this.setTimeBucket(timeBucket);
        this.setFields(fields);
    }

    public DimensionsDescriptor(CustomTimeBucket timeBucket, Fields fields) {
        this.setCustomTimeBucket(timeBucket);
        this.setFields(fields);
    }

    public DimensionsDescriptor(Fields fields) {
        this.setFields(fields);
    }

    public DimensionsDescriptor(String aggregationString) {
        this.initialize(aggregationString);
    }

    private void initialize(String aggregationString) {
        String[] fieldArray = aggregationString.split(DELIMETER_SEPERATOR);
        HashSet fieldSet = Sets.newHashSet();
        for (String field : fieldArray) {
            String[] fieldAndValue = field.split(DELIMETER_EQUALS);
            String fieldName = fieldAndValue[0];
            if (fieldName.equals(DIMENSION_TIME_BUCKET)) {
                throw new IllegalArgumentException("timeBucket is an invalid time.");
            }
            if (!fieldName.equals(DIMENSION_TIME)) {
                fieldSet.add(fieldName);
            }
            if (!fieldName.equals(DIMENSION_TIME)) continue;
            if (this.timeBucket != null) {
                throw new IllegalArgumentException("Cannot specify time in a dimensions descriptor when a timebucket is also specified.");
            }
            if (fieldAndValue.length != 2) continue;
            this.timeBucket = TimeBucket.TIME_UNIT_TO_TIME_BUCKET.get((Object)TimeUnit.valueOf(fieldAndValue[1]));
        }
        this.fields = new Fields(fieldSet);
    }

    private void setTimeBucket(TimeBucket timeBucket) {
        Preconditions.checkNotNull((Object)((Object)timeBucket));
        this.timeBucket = timeBucket;
        this.customTimeBucket = new CustomTimeBucket(timeBucket);
    }

    private void setCustomTimeBucket(CustomTimeBucket customTimeBucket) {
        Preconditions.checkNotNull((Object)customTimeBucket);
        this.customTimeBucket = customTimeBucket;
        this.timeBucket = customTimeBucket.getTimeBucket();
    }

    @Deprecated
    public TimeBucket getTimeBucket() {
        return this.timeBucket;
    }

    public CustomTimeBucket getCustomTimeBucket() {
        return this.customTimeBucket;
    }

    private void setFields(Fields fields) {
        Preconditions.checkNotNull((Object)fields);
        this.fields = fields;
    }

    public Fields getFields() {
        return this.fields;
    }

    public FieldsDescriptor createFieldsDescriptor(FieldsDescriptor parentDescriptor) {
        HashMap fieldToType = Maps.newHashMap();
        Map<String, Type> parentFieldToType = parentDescriptor.getFieldToType();
        for (String field : this.fields.getFields()) {
            if (RESERVED_DIMENSION_NAMES.contains(field)) continue;
            fieldToType.put(field, parentFieldToType.get(field));
        }
        if (this.timeBucket != null && this.timeBucket != TimeBucket.ALL) {
            fieldToType.put(DIMENSION_TIME_BUCKET, DIMENSION_TIME_BUCKET_TYPE);
            fieldToType.put(DIMENSION_TIME, Type.LONG);
        }
        return new FieldsDescriptor(fieldToType);
    }

    public int hashCode() {
        int hash = 7;
        hash = 83 * hash + (this.customTimeBucket != null ? this.customTimeBucket.hashCode() : 0);
        hash = 83 * hash + (this.fields != null ? this.fields.hashCode() : 0);
        return hash;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        DimensionsDescriptor other = (DimensionsDescriptor)obj;
        if (!this.customTimeBucket.equals(other.customTimeBucket)) {
            return false;
        }
        return this.fields == other.fields || this.fields != null && this.fields.equals(other.fields);
    }

    public String toString() {
        return "DimensionsDescriptor{timeBucket=" + this.customTimeBucket + ", fields=" + this.fields + '}';
    }

    @Override
    public int compareTo(DimensionsDescriptor other) {
        List<String> otherFieldList;
        if (this == other) {
            return 0;
        }
        List<String> thisFieldList = this.getFields().getFieldsList();
        if (thisFieldList != (otherFieldList = other.getFields().getFieldsList())) {
            int compare = thisFieldList.size() - otherFieldList.size();
            if (compare != 0) {
                return compare;
            }
            Collections.sort(thisFieldList);
            Collections.sort(otherFieldList);
            for (int index = 0; index < thisFieldList.size(); ++index) {
                String otherField;
                String thisField = thisFieldList.get(index);
                int fieldCompare = thisField.compareTo(otherField = otherFieldList.get(index));
                if (fieldCompare == 0) continue;
                return fieldCompare;
            }
        }
        CustomTimeBucket thisBucket = this.getCustomTimeBucket();
        CustomTimeBucket otherBucket = other.getCustomTimeBucket();
        if (thisBucket == null && otherBucket == null) {
            return 0;
        }
        if (thisBucket != null && otherBucket == null) {
            return 1;
        }
        if (thisBucket == null && otherBucket != null) {
            return -1;
        }
        return thisBucket.compareTo(otherBucket);
    }

    static {
        HashMap dimensionFieldToType = Maps.newHashMap();
        dimensionFieldToType.put(DIMENSION_TIME, DIMENSION_TIME_TYPE);
        dimensionFieldToType.put(DIMENSION_TIME_BUCKET, DIMENSION_TIME_BUCKET_TYPE);
        DIMENSION_FIELD_TO_TYPE = Collections.unmodifiableMap(dimensionFieldToType);
        LOG = LoggerFactory.getLogger(DimensionsDescriptor.class);
    }
}

