/*
 * Decompiled with CFR 0.152.
 */
package org.apache.apex.malhar.lib.dimensions;

import com.datatorrent.lib.appdata.gpo.GPOMutable;
import com.datatorrent.lib.appdata.gpo.GPOUtils;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.apache.apex.malhar.lib.dimensions.aggregator.AggregateEvent;

public class DimensionsEvent
implements Serializable {
    private static final long serialVersionUID = 201503231204L;
    protected GPOMutable aggregates;
    protected EventKey eventKey;

    private DimensionsEvent() {
    }

    public DimensionsEvent(EventKey eventKey, GPOMutable aggregates) {
        this.setEventKey(eventKey);
        this.setAggregates(aggregates);
    }

    public DimensionsEvent(GPOMutable keys, GPOMutable aggregates, int bucketID, int schemaID, int dimensionDescriptorID, int aggregatorIndex) {
        this.eventKey = new EventKey(bucketID, schemaID, dimensionDescriptorID, aggregatorIndex, keys);
        this.setAggregates(aggregates);
    }

    public DimensionsEvent(GPOMutable keys, GPOMutable aggregates, int schemaID, int dimensionDescriptorID, int aggregatorIndex) {
        this.eventKey = new EventKey(schemaID, dimensionDescriptorID, aggregatorIndex, keys);
        this.setAggregates(aggregates);
    }

    protected final void setEventKey(EventKey eventKey) {
        this.eventKey = new EventKey(eventKey);
    }

    protected final void setAggregates(GPOMutable aggregates) {
        Preconditions.checkNotNull((Object)aggregates);
        this.aggregates = aggregates;
    }

    public GPOMutable getAggregates() {
        return this.aggregates;
    }

    public EventKey getEventKey() {
        return this.eventKey;
    }

    public GPOMutable getKeys() {
        return this.eventKey.getKey();
    }

    public int getSchemaID() {
        return this.eventKey.getSchemaID();
    }

    public int getDimensionDescriptorID() {
        return this.eventKey.getDimensionDescriptorID();
    }

    public int getAggregatorID() {
        return this.eventKey.getAggregatorID();
    }

    public int getBucketID() {
        return this.eventKey.getBucketID();
    }

    public static void copy(DimensionsEvent aeDest, DimensionsEvent aeSrc) {
        GPOMutable destAggs = aeDest.getAggregates();
        GPOMutable srcAggs = aeSrc.getAggregates();
        if (srcAggs.getFieldsBoolean() != null) {
            System.arraycopy(srcAggs.getFieldsBoolean(), 0, destAggs.getFieldsBoolean(), 0, srcAggs.getFieldsBoolean().length);
        }
        if (srcAggs.getFieldsCharacter() != null) {
            System.arraycopy(srcAggs.getFieldsCharacter(), 0, destAggs.getFieldsCharacter(), 0, srcAggs.getFieldsCharacter().length);
        }
        if (srcAggs.getFieldsString() != null) {
            System.arraycopy(srcAggs.getFieldsString(), 0, destAggs.getFieldsString(), 0, srcAggs.getFieldsString().length);
        }
        if (srcAggs.getFieldsShort() != null) {
            System.arraycopy(srcAggs.getFieldsShort(), 0, destAggs.getFieldsShort(), 0, srcAggs.getFieldsShort().length);
        }
        if (srcAggs.getFieldsInteger() != null) {
            System.arraycopy(srcAggs.getFieldsInteger(), 0, destAggs.getFieldsInteger(), 0, srcAggs.getFieldsInteger().length);
        }
        if (srcAggs.getFieldsLong() != null) {
            System.arraycopy(srcAggs.getFieldsLong(), 0, destAggs.getFieldsLong(), 0, srcAggs.getFieldsLong().length);
        }
        if (srcAggs.getFieldsFloat() != null) {
            System.arraycopy(srcAggs.getFieldsFloat(), 0, destAggs.getFieldsFloat(), 0, srcAggs.getFieldsFloat().length);
        }
        if (srcAggs.getFieldsDouble() != null) {
            System.arraycopy(srcAggs.getFieldsDouble(), 0, destAggs.getFieldsDouble(), 0, srcAggs.getFieldsDouble().length);
        }
    }

    public int hashCode() {
        int hash = 5;
        hash = 79 * hash + (this.aggregates != null ? this.aggregates.hashCode() : 0);
        hash = 79 * hash + (this.eventKey != null ? this.eventKey.hashCode() : 0);
        return hash;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        DimensionsEvent other = (DimensionsEvent)obj;
        if (!(this.aggregates == other.aggregates || this.aggregates != null && this.aggregates.equals(other.aggregates))) {
            return false;
        }
        return this.eventKey == other.eventKey || this.eventKey != null && this.eventKey.equals(other.eventKey);
    }

    public static class Aggregate
    extends DimensionsEvent
    implements AggregateEvent {
        private static final long serialVersionUID = 201506190110L;
        protected int aggregatorIndex;
        private GPOMutable metaData;

        public Aggregate() {
        }

        public Aggregate(EventKey eventKey, GPOMutable aggregates) {
            this.setEventKey(eventKey);
            this.setAggregates(aggregates);
        }

        public Aggregate(EventKey eventKey, GPOMutable aggregates, GPOMutable metaData) {
            super(eventKey, aggregates);
            this.metaData = metaData;
        }

        public Aggregate(GPOMutable keys, GPOMutable aggregates, int bucketID, int schemaID, int dimensionDescriptorID, int aggregatorIndex) {
            this.eventKey = new EventKey(bucketID, schemaID, dimensionDescriptorID, aggregatorIndex, keys);
            this.setAggregates(aggregates);
        }

        public Aggregate(GPOMutable keys, GPOMutable aggregates, GPOMutable metaData, int bucketID, int schemaID, int dimensionDescriptorID, int aggregatorIndex) {
            this(keys, aggregates, bucketID, schemaID, dimensionDescriptorID, aggregatorIndex);
            this.metaData = metaData;
        }

        public Aggregate(GPOMutable keys, GPOMutable aggregates, int schemaID, int dimensionDescriptorID, int aggregatorIndex) {
            this.eventKey = new EventKey(schemaID, dimensionDescriptorID, aggregatorIndex, keys);
            this.setAggregates(aggregates);
        }

        public Aggregate(GPOMutable keys, GPOMutable aggregates, GPOMutable metaData, int schemaID, int dimensionDescriptorID, int aggregatorIndex) {
            this(keys, aggregates, schemaID, dimensionDescriptorID, aggregatorIndex);
            this.metaData = metaData;
        }

        public void setMetaData(GPOMutable metaData) {
            this.metaData = metaData;
        }

        public GPOMutable getMetaData() {
            return this.metaData;
        }

        public void setAggregatorIndex(int aggregatorIndex) {
            this.aggregatorIndex = aggregatorIndex;
        }

        @Override
        public int getAggregatorIndex() {
            return this.aggregatorIndex;
        }

        @Override
        public int hashCode() {
            return GPOUtils.hashcode(this.getKeys());
        }

        @Override
        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            DimensionsEvent other = (DimensionsEvent)obj;
            return this.eventKey == other.eventKey || this.eventKey != null && this.eventKey.equals(other.eventKey);
        }
    }

    public static class InputEvent
    extends DimensionsEvent {
        private static final long serialVersionUID = 201506210406L;
        public boolean used = false;

        private InputEvent() {
        }

        public InputEvent(EventKey eventKey, GPOMutable aggregates) {
            this.setEventKey(eventKey);
            this.setAggregates(aggregates);
        }

        public InputEvent(GPOMutable keys, GPOMutable aggregates, int bucketID, int schemaID, int dimensionDescriptorID, int aggregatorIndex) {
            this.eventKey = new EventKey(bucketID, schemaID, dimensionDescriptorID, aggregatorIndex, keys);
            this.setAggregates(aggregates);
        }

        public InputEvent(GPOMutable keys, GPOMutable aggregates, int schemaID, int dimensionDescriptorID, int aggregatorIndex) {
            this.eventKey = new EventKey(schemaID, dimensionDescriptorID, aggregatorIndex, keys);
            this.setAggregates(aggregates);
        }

        @Override
        public int hashCode() {
            return GPOUtils.hashcode(this.getKeys());
        }

        @Override
        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            DimensionsEvent other = (DimensionsEvent)obj;
            return this.eventKey == other.eventKey || this.eventKey != null && this.eventKey.equals(other.eventKey);
        }
    }

    public static class EventKey
    implements Serializable {
        private static final long serialVersionUID = 201503231205L;
        private int bucketID;
        private int schemaID;
        private int dimensionDescriptorID;
        private int aggregatorID;
        private GPOMutable key;

        private EventKey() {
        }

        public EventKey(EventKey eventKey) {
            this.bucketID = eventKey.bucketID;
            this.schemaID = eventKey.schemaID;
            this.dimensionDescriptorID = eventKey.dimensionDescriptorID;
            this.aggregatorID = eventKey.aggregatorID;
            this.key = new GPOMutable(eventKey.getKey());
        }

        public EventKey(int bucketID, int schemaID, int dimensionDescriptorID, int aggregatorID, GPOMutable key) {
            this.setBucketID(bucketID);
            this.setSchemaID(schemaID);
            this.setDimensionDescriptorID(dimensionDescriptorID);
            this.setAggregatorID(aggregatorID);
            this.setKey(key);
        }

        public EventKey(int schemaID, int dimensionDescriptorID, int aggregatorID, GPOMutable key) {
            this.setSchemaID(schemaID);
            this.setDimensionDescriptorID(dimensionDescriptorID);
            this.setAggregatorID(aggregatorID);
            this.setKey(key);
        }

        private void setDimensionDescriptorID(int dimensionDescriptorID) {
            this.dimensionDescriptorID = dimensionDescriptorID;
        }

        public int getDimensionDescriptorID() {
            return this.dimensionDescriptorID;
        }

        public int getAggregatorID() {
            return this.aggregatorID;
        }

        private void setAggregatorID(int aggregatorID) {
            this.aggregatorID = aggregatorID;
        }

        public int getSchemaID() {
            return this.schemaID;
        }

        private void setSchemaID(int schemaID) {
            this.schemaID = schemaID;
        }

        public GPOMutable getKey() {
            return this.key;
        }

        private void setBucketID(int bucketID) {
            this.bucketID = bucketID;
        }

        public int getBucketID() {
            return this.bucketID;
        }

        private void setKey(GPOMutable key) {
            Preconditions.checkNotNull((Object)key);
            this.key = key;
        }

        public int hashCode() {
            int hash = 3;
            hash = 97 * hash + this.bucketID;
            hash = 97 * hash + this.schemaID;
            hash = 97 * hash + this.dimensionDescriptorID;
            hash = 97 * hash + this.aggregatorID;
            hash = 97 * hash + (this.key != null ? this.key.hashCode() : 0);
            return hash;
        }

        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            EventKey other = (EventKey)obj;
            if (this.bucketID != other.bucketID) {
                return false;
            }
            if (this.schemaID != other.schemaID) {
                return false;
            }
            if (this.dimensionDescriptorID != other.dimensionDescriptorID) {
                return false;
            }
            if (this.aggregatorID != other.aggregatorID) {
                return false;
            }
            return this.key == other.key || this.key != null && this.key.equals(other.key);
        }

        public String toString() {
            return "EventKey{schemaID=" + this.schemaID + ", dimensionDescriptorID=" + this.dimensionDescriptorID + ", aggregatorIndex=" + this.aggregatorID + ", key=" + this.key + '}';
        }

        public static List<EventKey> createEventKeys(int schemaId, int dimensionsDescriptorId, int aggregatorId, List<GPOMutable> keys) {
            ArrayList eventKeys = Lists.newArrayList();
            for (GPOMutable key : keys) {
                eventKeys.add(new EventKey(schemaId, dimensionsDescriptorId, aggregatorId, key));
            }
            return eventKeys;
        }
    }
}

