/*
 * Decompiled with CFR 0.152.
 */
package org.apache.apex.malhar.lib.dimensions.aggregator;

import java.util.Map;
import org.apache.apex.malhar.lib.dimensions.aggregator.CompositeAggregatorFactory;

public abstract class AbstractCompositeAggregatorFactory
implements CompositeAggregatorFactory {
    protected static final String NAME_TEMPLATE = "%s-%s-%s";
    protected static final String PROPERTY_SEPERATOR = "_";
    protected static final String PROPERTY_VALUE_SEPERATOR = "|";

    @Override
    public String getCompositeAggregatorName(String aggregatorType, String embededAggregatorName, Map<String, Object> properties) {
        return String.format(NAME_TEMPLATE, aggregatorType, embededAggregatorName, this.getNamePartialForProperties(properties));
    }

    protected String getNamePartialForProperties(Map<String, Object> properties) {
        if (properties.size() == 1) {
            return properties.values().iterator().next().toString();
        }
        StringBuilder sb = new StringBuilder();
        for (Map.Entry<String, Object> entry : properties.entrySet()) {
            sb.append(entry.getKey()).append(PROPERTY_VALUE_SEPERATOR).append(entry.getValue()).append(PROPERTY_SEPERATOR);
        }
        return sb.deleteCharAt(sb.length() - 1).toString();
    }
}

