/*
 * Decompiled with CFR 0.152.
 */
package org.apache.apex.malhar.lib.dimensions.aggregator;

import com.datatorrent.lib.appdata.gpo.GPOMutable;
import com.datatorrent.lib.appdata.gpo.GPOUtils;
import com.datatorrent.lib.appdata.schemas.CustomTimeBucket;
import com.google.common.base.Preconditions;
import org.apache.apex.malhar.lib.dimensions.DimensionsConversionContext;
import org.apache.apex.malhar.lib.dimensions.DimensionsEvent;
import org.apache.apex.malhar.lib.dimensions.aggregator.IncrementalAggregator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractIncrementalAggregator
implements IncrementalAggregator {
    private static final long serialVersionUID = 201506211153L;
    protected DimensionsConversionContext context;
    private static final Logger LOG = LoggerFactory.getLogger(AbstractIncrementalAggregator.class);

    @Override
    public void setDimensionsConversionContext(DimensionsConversionContext context) {
        this.context = (DimensionsConversionContext)Preconditions.checkNotNull((Object)context);
    }

    @Override
    public DimensionsEvent.Aggregate getGroup(DimensionsEvent.InputEvent src, int aggregatorIndex) {
        src.used = true;
        DimensionsEvent.Aggregate aggregate = AbstractIncrementalAggregator.createAggregate(src, this.context, aggregatorIndex);
        return aggregate;
    }

    public int hashCode(DimensionsEvent.InputEvent inputEvent) {
        boolean hasTime;
        long timestamp = -1L;
        boolean bl = hasTime = this.context.inputTimestampIndex != -1 && this.context.outputTimebucketIndex != -1;
        if (hasTime) {
            timestamp = inputEvent.getKeys().getFieldsLong()[this.context.inputTimestampIndex];
            inputEvent.getKeys().getFieldsLong()[this.context.inputTimestampIndex] = this.context.dd.getCustomTimeBucket().roundDown(timestamp);
        }
        int hashCode = GPOUtils.indirectHashcode(inputEvent.getKeys(), this.context.indexSubsetKeys);
        if (hasTime) {
            inputEvent.getKeys().getFieldsLong()[this.context.inputTimestampIndex] = timestamp;
        }
        return hashCode;
    }

    public boolean equals(DimensionsEvent.InputEvent inputEvent1, DimensionsEvent.InputEvent inputEvent2) {
        long timestamp1 = 0L;
        long timestamp2 = 0L;
        if (this.context.inputTimestampIndex != -1) {
            timestamp1 = inputEvent1.getKeys().getFieldsLong()[this.context.inputTimestampIndex];
            inputEvent1.getKeys().getFieldsLong()[this.context.inputTimestampIndex] = this.context.dd.getCustomTimeBucket().roundDown(timestamp1);
            timestamp2 = inputEvent2.getKeys().getFieldsLong()[this.context.inputTimestampIndex];
            inputEvent2.getKeys().getFieldsLong()[this.context.inputTimestampIndex] = this.context.dd.getCustomTimeBucket().roundDown(timestamp2);
        }
        boolean equals = GPOUtils.subsetEquals(inputEvent2.getKeys(), inputEvent1.getKeys(), this.context.indexSubsetKeys);
        if (this.context.inputTimestampIndex != -1) {
            inputEvent1.getKeys().getFieldsLong()[this.context.inputTimestampIndex] = timestamp1;
            inputEvent2.getKeys().getFieldsLong()[this.context.inputTimestampIndex] = timestamp2;
        }
        return equals;
    }

    public static DimensionsEvent.Aggregate createAggregate(DimensionsEvent.InputEvent inputEvent, DimensionsConversionContext context, int aggregatorIndex) {
        GPOMutable aggregates = new GPOMutable(context.aggregateDescriptor);
        DimensionsEvent.EventKey eventKey = AbstractIncrementalAggregator.createEventKey(inputEvent, context, aggregatorIndex);
        DimensionsEvent.Aggregate aggregate = new DimensionsEvent.Aggregate(eventKey, aggregates);
        aggregate.setAggregatorIndex(aggregatorIndex);
        return aggregate;
    }

    public static DimensionsEvent.EventKey createEventKey(DimensionsEvent.InputEvent inputEvent, DimensionsConversionContext context, int aggregatorIndex) {
        GPOMutable keys = new GPOMutable(context.keyDescriptor);
        GPOUtils.indirectCopy(keys, inputEvent.getKeys(), context.indexSubsetKeys);
        if (context.outputTimebucketIndex >= 0) {
            CustomTimeBucket timeBucket = context.dd.getCustomTimeBucket();
            keys.getFieldsInteger()[context.outputTimebucketIndex] = context.customTimeBucketRegistry.getTimeBucketId(timeBucket);
            keys.getFieldsLong()[context.outputTimestampIndex] = timeBucket.roundDown(inputEvent.getKeys().getFieldsLong()[context.inputTimestampIndex]);
        }
        DimensionsEvent.EventKey eventKey = new DimensionsEvent.EventKey(context.schemaID, context.dimensionsDescriptorID, context.aggregatorID, keys);
        return eventKey;
    }
}

