/*
 * Decompiled with CFR 0.152.
 */
package org.apache.apex.malhar.lib.dimensions.aggregator;

import com.datatorrent.lib.appdata.gpo.GPOMutable;
import com.datatorrent.lib.appdata.schemas.Type;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import org.apache.apex.malhar.lib.dimensions.DimensionsEvent;
import org.apache.apex.malhar.lib.dimensions.aggregator.AbstractCompositeAggregator;

public abstract class AbstractTopBottomAggregator
extends AbstractCompositeAggregator {
    public static final String PROP_COUNT = "count";
    protected int count;
    protected SortedSet<String> subCombinations = Sets.newTreeSet();
    protected transient List<String> tmpStoreFieldList = Lists.newArrayList();
    protected static final String KEY_VALUE_SEPERATOR = "-";

    public AbstractTopBottomAggregator withEmbedAggregatorName(String embedAggregatorName) {
        this.setEmbedAggregatorName(embedAggregatorName);
        return this;
    }

    public AbstractTopBottomAggregator withSubCombinations(String[] subCombinations) {
        this.setSubCombinations(subCombinations);
        return this;
    }

    public AbstractTopBottomAggregator withCount(int count) {
        this.setCount(count);
        return this;
    }

    public int getCount() {
        return this.count;
    }

    public void setCount(int count) {
        this.count = count;
    }

    public void setSubCombinations(Set<String> subCombinations) {
        this.subCombinations.clear();
        this.subCombinations.addAll(subCombinations);
    }

    public void setSubCombinations(String[] subCombinations) {
        this.setSubCombinations(Sets.newHashSet((Object[])subCombinations));
    }

    public Set<String> getSubCombinations() {
        return this.subCombinations;
    }

    @Override
    public Type getOutputType() {
        return Type.OBJECT;
    }

    @Override
    public int hashCode() {
        return (this.embedAggregatorName.hashCode() * 31 + this.count) * 31 + this.subCombinations.hashCode();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        AbstractTopBottomAggregator other = (AbstractTopBottomAggregator)obj;
        if (!(this.embedAggregatorName == other.embedAggregatorName || this.embedAggregatorName != null && this.embedAggregatorName.equals(other.embedAggregatorName))) {
            return false;
        }
        if (this.count != other.count) {
            return false;
        }
        return this.subCombinations == other.subCombinations || this.subCombinations != null && this.subCombinations.equals(other.subCombinations);
    }

    @Override
    public void aggregate(DimensionsEvent.Aggregate resultAggregate, Set<DimensionsEvent.EventKey> inputSubEventKeys, Map<DimensionsEvent.EventKey, DimensionsEvent.Aggregate> inputAggregatesRepo) {
        GPOMutable resultGpo = resultAggregate.getAggregates();
        List<String> compositeFieldList = resultAggregate.getEventKey().getKey().getFieldDescriptor().getFieldList();
        for (String valueField : resultGpo.getFieldDescriptor().getFieldList()) {
            this.updateAggregate(resultAggregate, valueField, inputSubEventKeys, inputAggregatesRepo);
            for (DimensionsEvent.EventKey eventKey : inputSubEventKeys) {
                this.aggregate(compositeFieldList, resultGpo, eventKey, inputAggregatesRepo.get(eventKey).getAggregates());
            }
        }
    }

    protected String getStoreMapKey(DimensionsEvent.EventKey subEventKey, List<String> compositeEventFieldList) {
        this.tmpStoreFieldList.clear();
        this.tmpStoreFieldList.addAll(subEventKey.getKey().getFieldDescriptor().getFieldList());
        this.tmpStoreFieldList.removeAll(compositeEventFieldList);
        Collections.sort(this.tmpStoreFieldList);
        StringBuilder key = new StringBuilder();
        for (String field : this.tmpStoreFieldList) {
            key.append(subEventKey.getKey().getField(field)).append(KEY_VALUE_SEPERATOR);
        }
        key.deleteCharAt(key.length() - 1);
        return key.toString();
    }

    protected void updateAggregate(DimensionsEvent.Aggregate resultAggregate, String valueField, Set<DimensionsEvent.EventKey> inputSubEventKeys, Map<DimensionsEvent.EventKey, DimensionsEvent.Aggregate> inputAggregatesRepo) {
        Map resultAggregateFieldToValue = (Map)resultAggregate.getAggregates().getFieldObject(valueField);
        if (resultAggregateFieldToValue == null) {
            return;
        }
        for (DimensionsEvent.EventKey inputSubEventKey : inputSubEventKeys) {
            DimensionsEvent.Aggregate inputSubAggregate = inputAggregatesRepo.get(inputSubEventKey);
            String mapKey = this.getStoreMapKey(inputSubAggregate.getEventKey(), resultAggregate.getEventKey().getKey().getFieldDescriptor().getFieldList());
            if (resultAggregateFieldToValue.get(mapKey) == null) continue;
            resultAggregateFieldToValue.put(mapKey, inputSubAggregate.getAggregates().getField(valueField));
        }
    }

    protected void aggregate(List<String> compositeFieldList, GPOMutable resultGpo, DimensionsEvent.EventKey subEventKey, GPOMutable inputGpo) {
        List<String> aggregateFields = resultGpo.getFieldDescriptor().getFieldList();
        Map<String, Type> fieldToType = resultGpo.getFieldDescriptor().getFieldToType();
        for (String aggregateField : aggregateFields) {
            Map<String, Object> fieldValue = (Map<String, Object>)resultGpo.getFieldObject(aggregateField);
            if (fieldValue == null) {
                fieldValue = this.createAggregateValueForField(aggregateField, fieldToType.get(aggregateField));
                resultGpo.setFieldObject(aggregateField, fieldValue);
            }
            this.aggregate(compositeFieldList, fieldValue, subEventKey, inputGpo.getField(aggregateField), fieldToType.get(aggregateField));
        }
    }

    protected Map<String, Object> createAggregateValueForField(String fieldName, Type fieldElementType) {
        return Maps.newHashMap();
    }

    protected void aggregate(List<String> compositeFieldList, Map<String, Object> resultMap, DimensionsEvent.EventKey subEventKey, Object inputFieldValue, Type type) {
        if (resultMap.size() < this.count) {
            resultMap.put(this.getStoreMapKey(subEventKey, compositeFieldList), inputFieldValue);
            return;
        }
        for (String key : resultMap.keySet()) {
            Object resultValue = resultMap.get(key);
            if (!this.shouldReplaceResultElement(resultValue, inputFieldValue, type)) continue;
            resultMap.put(key, inputFieldValue);
            break;
        }
    }

    protected boolean shouldReplaceResultElement(Object resultElement, Object inputElement, Type type) {
        if (inputElement == null) {
            return false;
        }
        if (resultElement == null) {
            return true;
        }
        if (resultElement instanceof Comparable) {
            int compareResult = ((Comparable)resultElement).compareTo(inputElement);
            return this.shouldReplaceResultElement(compareResult);
        }
        throw new RuntimeException("Should NOT come here.");
    }

    protected abstract boolean shouldReplaceResultElement(int var1);
}

