/*
 * Decompiled with CFR 0.152.
 */
package org.apache.apex.malhar.lib.dimensions.aggregator;

import com.datatorrent.api.annotation.Name;
import com.datatorrent.lib.appdata.gpo.GPOMutable;
import com.datatorrent.lib.appdata.schemas.Fields;
import com.datatorrent.lib.appdata.schemas.FieldsDescriptor;
import com.datatorrent.lib.appdata.schemas.Type;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.util.List;
import org.apache.apex.malhar.lib.dimensions.aggregator.AggregatorIncrementalType;
import org.apache.apex.malhar.lib.dimensions.aggregator.AggregatorUtils;
import org.apache.apex.malhar.lib.dimensions.aggregator.IncrementalAggregator;
import org.apache.apex.malhar.lib.dimensions.aggregator.OTFAggregator;

@Name(value="AVG")
public class AggregatorAverage
implements OTFAggregator {
    private static final long serialVersionUID = 20154301644L;
    public static int SUM_INDEX = 0;
    public static int COUNT_INDEX = 1;
    public static final AggregatorAverage INSTANCE = new AggregatorAverage();
    public static final transient List<Class<? extends IncrementalAggregator>> CHILD_AGGREGATORS = ImmutableList.of(AggregatorIncrementalType.SUM.getAggregator().getClass(), AggregatorIncrementalType.COUNT.getAggregator().getClass());

    protected AggregatorAverage() {
    }

    @Override
    public List<Class<? extends IncrementalAggregator>> getChildAggregators() {
        return CHILD_AGGREGATORS;
    }

    @Override
    public GPOMutable aggregate(GPOMutable ... aggregates) {
        Preconditions.checkArgument((aggregates.length == this.getChildAggregators().size() ? 1 : 0) != 0, (Object)("The number of arguments " + aggregates.length + " should be the same as the number of child aggregators " + this.getChildAggregators().size()));
        GPOMutable sumAggregation = aggregates[SUM_INDEX];
        GPOMutable countAggregation = aggregates[COUNT_INDEX];
        FieldsDescriptor fieldsDescriptor = sumAggregation.getFieldDescriptor();
        Fields fields = fieldsDescriptor.getFields();
        GPOMutable result = new GPOMutable(AggregatorUtils.getOutputFieldsDescriptor(fields, (OTFAggregator)this));
        long count = countAggregation.getFieldsLong()[0];
        block8: for (String field : fields.getFields()) {
            Type type = sumAggregation.getFieldDescriptor().getType(field);
            switch (type) {
                case BYTE: {
                    double val = (double)sumAggregation.getFieldByte(field) / (double)count;
                    result.setField(field, val);
                    continue block8;
                }
                case SHORT: {
                    double val = (double)sumAggregation.getFieldShort(field) / (double)count;
                    result.setField(field, val);
                    continue block8;
                }
                case INTEGER: {
                    double val = (double)sumAggregation.getFieldInt(field) / (double)count;
                    result.setField(field, val);
                    continue block8;
                }
                case LONG: {
                    double val = (double)sumAggregation.getFieldLong(field) / (double)count;
                    result.setField(field, val);
                    continue block8;
                }
                case FLOAT: {
                    double val = (double)sumAggregation.getFieldFloat(field) / (double)count;
                    result.setField(field, val);
                    continue block8;
                }
                case DOUBLE: {
                    double val = sumAggregation.getFieldDouble(field) / (double)count;
                    result.setField(field, val);
                    continue block8;
                }
            }
            throw new UnsupportedOperationException("The type " + type + " is not supported.");
        }
        return result;
    }

    @Override
    public Type getOutputType() {
        return Type.DOUBLE;
    }
}

