/*
 * Decompiled with CFR 0.152.
 */
package org.apache.apex.malhar.lib.dimensions.aggregator;

import com.datatorrent.api.annotation.Name;
import com.datatorrent.lib.appdata.gpo.GPOMutable;
import com.datatorrent.lib.appdata.gpo.GPOUtils;
import com.datatorrent.lib.appdata.schemas.FieldsDescriptor;
import com.datatorrent.lib.appdata.schemas.Type;
import com.google.common.collect.Maps;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.apex.malhar.lib.dimensions.DimensionsEvent;
import org.apache.apex.malhar.lib.dimensions.aggregator.AbstractIncrementalAggregator;

@Name(value="COUNT")
public class AggregatorCount
extends AbstractIncrementalAggregator {
    private static final long serialVersionUID = 20154301645L;
    public static final transient Map<Type, Type> TYPE_CONVERSION_MAP;

    @Override
    public DimensionsEvent.Aggregate getGroup(DimensionsEvent.InputEvent src, int aggregatorIndex) {
        src.used = true;
        GPOMutable aggregates = new GPOMutable(this.context.aggregateDescriptor);
        GPOMutable keys = new GPOMutable(this.context.keyDescriptor);
        GPOUtils.indirectCopy(keys, src.getKeys(), this.context.indexSubsetKeys);
        DimensionsEvent.EventKey eventKey = AggregatorCount.createEventKey(src, this.context, aggregatorIndex);
        long[] longFields = aggregates.getFieldsLong();
        for (int index = 0; index < longFields.length; ++index) {
            longFields[index] = 0L;
        }
        return new DimensionsEvent.Aggregate(eventKey, aggregates);
    }

    @Override
    public void aggregate(DimensionsEvent.Aggregate dest, DimensionsEvent.InputEvent src) {
        long[] fieldsLong = dest.getAggregates().getFieldsLong();
        int index = 0;
        while (index < fieldsLong.length) {
            int n = index++;
            fieldsLong[n] = fieldsLong[n] + 1L;
        }
    }

    @Override
    public void aggregate(DimensionsEvent.Aggregate destAgg, DimensionsEvent.Aggregate srcAgg) {
        long[] destLongs = destAgg.getAggregates().getFieldsLong();
        long[] srcLongs = srcAgg.getAggregates().getFieldsLong();
        for (int index = 0; index < destLongs.length; ++index) {
            int n = index;
            destLongs[n] = destLongs[n] + srcLongs[index];
        }
    }

    @Override
    public Type getOutputType(Type inputType) {
        return TYPE_CONVERSION_MAP.get(inputType);
    }

    @Override
    public FieldsDescriptor getMetaDataDescriptor() {
        return null;
    }

    static {
        HashMap typeConversionMap = Maps.newHashMap();
        for (Type type : Type.values()) {
            typeConversionMap.put(type, Type.LONG);
        }
        TYPE_CONVERSION_MAP = Collections.unmodifiableMap(typeConversionMap);
    }
}

