/*
 * Decompiled with CFR 0.152.
 */
package org.apache.apex.malhar.lib.dimensions.aggregator;

import com.datatorrent.api.annotation.Name;
import com.datatorrent.lib.appdata.gpo.GPOMutable;
import com.datatorrent.lib.appdata.gpo.GPOUtils;
import com.datatorrent.lib.appdata.gpo.SerdeFieldsDescriptor;
import com.datatorrent.lib.appdata.gpo.SerdeListGPOMutable;
import com.datatorrent.lib.appdata.gpo.SerdeObjectPayloadFix;
import com.datatorrent.lib.appdata.schemas.FieldsDescriptor;
import com.datatorrent.lib.appdata.schemas.Type;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.apache.apex.malhar.lib.dimensions.DimensionsEvent;
import org.apache.apex.malhar.lib.dimensions.aggregator.AggregatorSum;

@Name(value="CUM_SUM")
public class AggregatorCumSum
extends AggregatorSum {
    private static final long serialVersionUID = 201506280518L;
    public static final int KEY_FD_INDEX = 0;
    public static final int AGGREGATE_FD_INDEX = 1;
    public static final int KEYS_INDEX = 2;
    public static final int AGGREGATES_INDEX = 3;
    public static final FieldsDescriptor META_DATA_FIELDS_DESCRIPTOR;

    @Override
    public DimensionsEvent.Aggregate getGroup(DimensionsEvent.InputEvent src, int aggregatorIndex) {
        src.used = true;
        DimensionsEvent.Aggregate agg = AggregatorCumSum.createAggregate(src, this.context, aggregatorIndex);
        GPOUtils.indirectCopy(agg.getAggregates(), src.getAggregates(), this.context.indexSubsetAggregates);
        GPOMutable metaData = new GPOMutable(this.getMetaDataDescriptor());
        GPOMutable fullKey = new GPOMutable(src.getKeys());
        if (this.context.inputTimestampIndex >= 0) {
            fullKey.getFieldsLong()[this.context.inputTimestampIndex] = -1L;
        }
        ArrayList keys = Lists.newArrayList((Object[])new GPOMutable[]{fullKey});
        GPOMutable value = new GPOMutable(agg.getAggregates());
        ArrayList values = Lists.newArrayList((Object[])new GPOMutable[]{value});
        metaData.getFieldsObject()[0] = fullKey.getFieldDescriptor();
        metaData.getFieldsObject()[1] = value.getFieldDescriptor();
        metaData.getFieldsObject()[2] = keys;
        metaData.getFieldsObject()[3] = values;
        agg.setMetaData(metaData);
        return agg;
    }

    @Override
    public void aggregate(DimensionsEvent.Aggregate dest, DimensionsEvent.InputEvent src) {
        List destKeys = (List)dest.getMetaData().getFieldsObject()[2];
        List destAggregates = (List)dest.getMetaData().getFieldsObject()[3];
        long timestamp = 0L;
        if (this.context.inputTimestampIndex >= 0) {
            timestamp = src.getKeys().getFieldsLong()[this.context.inputTimestampIndex];
            src.getKeys().getFieldsLong()[this.context.inputTimestampIndex] = -1L;
        }
        if (!this.contains(destKeys, src.getKeys())) {
            destKeys.add(new GPOMutable(src.getKeys()));
            GPOMutable aggregates = new GPOMutable(this.context.aggregateDescriptor);
            GPOUtils.indirectCopy(aggregates, src.getAggregates(), this.context.indexSubsetAggregates);
            destAggregates.add(aggregates);
            this.aggregateAggs(dest.getAggregates(), aggregates);
        }
        if (this.context.inputTimestampIndex >= 0) {
            src.getKeys().getFieldsLong()[this.context.inputTimestampIndex] = timestamp;
        }
    }

    @Override
    public void aggregate(DimensionsEvent.Aggregate dest, DimensionsEvent.Aggregate src) {
        dest.getMetaData().applyObjectPayloadFix();
        src.getMetaData().applyObjectPayloadFix();
        List destKeys = (List)dest.getMetaData().getFieldsObject()[2];
        List srcKeys = (List)src.getMetaData().getFieldsObject()[2];
        List destAggregates = (List)dest.getMetaData().getFieldsObject()[3];
        List srcAggregates = (List)src.getMetaData().getFieldsObject()[3];
        ArrayList newKeys = Lists.newArrayList();
        ArrayList newAggs = Lists.newArrayList();
        for (int index = 0; index < srcKeys.size(); ++index) {
            GPOMutable currentSrcKey = (GPOMutable)srcKeys.get(index);
            GPOMutable currentSrcAgg = (GPOMutable)srcAggregates.get(index);
            if (this.contains(destKeys, currentSrcKey)) continue;
            newKeys.add(currentSrcKey);
            newAggs.add(currentSrcAgg);
            this.aggregateAggs(dest.getAggregates(), currentSrcAgg);
        }
        destKeys.addAll(newKeys);
        destAggregates.addAll(newAggs);
    }

    private boolean contains(List<GPOMutable> mutables, GPOMutable mutable) {
        for (int index = 0; index < mutables.size(); ++index) {
            GPOMutable mutableFromList = mutables.get(index);
            if (!GPOUtils.equals(mutableFromList, mutable)) continue;
            return true;
        }
        return false;
    }

    @Override
    public FieldsDescriptor getMetaDataDescriptor() {
        return META_DATA_FIELDS_DESCRIPTOR;
    }

    static {
        HashMap fieldToType = Maps.newHashMap();
        fieldToType.put("fdkeys", Type.OBJECT);
        fieldToType.put("fdvalues", Type.OBJECT);
        fieldToType.put("keys", Type.OBJECT);
        fieldToType.put("values", Type.OBJECT);
        HashMap fieldToSerde = Maps.newHashMap();
        fieldToSerde.put("fdkeys", SerdeFieldsDescriptor.INSTANCE);
        fieldToSerde.put("fdvalues", SerdeFieldsDescriptor.INSTANCE);
        fieldToSerde.put("keys", SerdeListGPOMutable.INSTANCE);
        fieldToSerde.put("values", SerdeListGPOMutable.INSTANCE);
        META_DATA_FIELDS_DESCRIPTOR = new FieldsDescriptor(fieldToType, fieldToSerde, new PayloadFix());
    }

    public static class PayloadFix
    implements SerdeObjectPayloadFix {
        @Override
        public void fix(Object[] objects) {
            FieldsDescriptor keyfd = (FieldsDescriptor)objects[0];
            FieldsDescriptor valuefd = (FieldsDescriptor)objects[1];
            List keyMutables = (List)objects[2];
            List aggregateMutables = (List)objects[3];
            this.fix(keyfd, keyMutables);
            this.fix(valuefd, aggregateMutables);
        }

        private void fix(FieldsDescriptor fd, List<GPOMutable> mutables) {
            for (int index = 0; index < mutables.size(); ++index) {
                mutables.get(index).setFieldDescriptor(fd);
            }
        }
    }
}

