/*
 * Decompiled with CFR 0.152.
 */
package org.apache.apex.malhar.lib.dimensions.aggregator;

import com.google.common.base.Preconditions;
import com.google.common.collect.Maps;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.apex.malhar.lib.dimensions.aggregator.AggregatorCount;
import org.apache.apex.malhar.lib.dimensions.aggregator.AggregatorCumSum;
import org.apache.apex.malhar.lib.dimensions.aggregator.AggregatorFirst;
import org.apache.apex.malhar.lib.dimensions.aggregator.AggregatorLast;
import org.apache.apex.malhar.lib.dimensions.aggregator.AggregatorMax;
import org.apache.apex.malhar.lib.dimensions.aggregator.AggregatorMin;
import org.apache.apex.malhar.lib.dimensions.aggregator.AggregatorSum;
import org.apache.apex.malhar.lib.dimensions.aggregator.IncrementalAggregator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public enum AggregatorIncrementalType {
    SUM(new AggregatorSum()),
    MIN(new AggregatorMin()),
    MAX(new AggregatorMax()),
    COUNT(new AggregatorCount()),
    LAST(new AggregatorLast()),
    FIRST(new AggregatorFirst()),
    CUM_SUM(new AggregatorCumSum());

    public static final Map<String, Integer> NAME_TO_ORDINAL;
    public static final Map<String, IncrementalAggregator> NAME_TO_AGGREGATOR;
    private IncrementalAggregator aggregator;
    private static final Logger LOG;

    private AggregatorIncrementalType(IncrementalAggregator aggregator) {
        this.setAggregator(aggregator);
    }

    private void setAggregator(IncrementalAggregator aggregator) {
        Preconditions.checkNotNull((Object)aggregator);
        this.aggregator = aggregator;
    }

    public IncrementalAggregator getAggregator() {
        return this.aggregator;
    }

    static {
        HashMap nameToOrdinal = Maps.newHashMap();
        HashMap nameToAggregator = Maps.newHashMap();
        for (AggregatorIncrementalType aggType : AggregatorIncrementalType.values()) {
            nameToOrdinal.put(aggType.name(), aggType.ordinal());
            nameToAggregator.put(aggType.name(), aggType.getAggregator());
        }
        NAME_TO_ORDINAL = Collections.unmodifiableMap(nameToOrdinal);
        NAME_TO_AGGREGATOR = Collections.unmodifiableMap(nameToAggregator);
        LOG = LoggerFactory.getLogger(AggregatorIncrementalType.class);
    }
}

