/*
 * Decompiled with CFR 0.152.
 */
package org.apache.apex.malhar.lib.dimensions.aggregator;

import com.google.common.base.Preconditions;
import com.google.common.collect.Maps;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.apex.malhar.lib.dimensions.aggregator.AggregatorAverage;
import org.apache.apex.malhar.lib.dimensions.aggregator.OTFAggregator;

public enum AggregatorOTFType {
    AVG(AggregatorAverage.INSTANCE);

    public static final Map<String, OTFAggregator> NAME_TO_AGGREGATOR;
    private OTFAggregator aggregator;

    private AggregatorOTFType(OTFAggregator aggregator) {
        this.setAggregator(aggregator);
    }

    private void setAggregator(OTFAggregator aggregator) {
        this.aggregator = (OTFAggregator)Preconditions.checkNotNull((Object)aggregator);
    }

    public OTFAggregator getAggregator() {
        return this.aggregator;
    }

    static {
        HashMap nameToAggregator = Maps.newHashMap();
        for (AggregatorOTFType aggType : AggregatorOTFType.values()) {
            nameToAggregator.put(aggType.name(), aggType.getAggregator());
        }
        NAME_TO_AGGREGATOR = Collections.unmodifiableMap(nameToAggregator);
    }
}

