/*
 * Decompiled with CFR 0.152.
 */
package org.apache.apex.malhar.lib.dimensions.aggregator;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.apex.malhar.lib.dimensions.aggregator.AbstractTopBottomAggregator;
import org.apache.apex.malhar.lib.dimensions.aggregator.AggregatorIncrementalType;
import org.apache.apex.malhar.lib.dimensions.aggregator.AggregatorOTFType;
import org.apache.apex.malhar.lib.dimensions.aggregator.AggregatorTopBottomType;
import org.apache.apex.malhar.lib.dimensions.aggregator.IncrementalAggregator;
import org.apache.apex.malhar.lib.dimensions.aggregator.OTFAggregator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AggregatorRegistry
implements Serializable {
    private static final long serialVersionUID = 20154301642L;
    private static final transient Map<String, IncrementalAggregator> DEFAULT_NAME_TO_INCREMENTAL_AGGREGATOR = Maps.newHashMap(AggregatorIncrementalType.NAME_TO_AGGREGATOR);
    private static final transient Map<String, OTFAggregator> DEFAULT_NAME_TO_OTF_AGGREGATOR = Maps.newHashMap(AggregatorOTFType.NAME_TO_AGGREGATOR);
    public static final AggregatorRegistry DEFAULT_AGGREGATOR_REGISTRY = new AggregatorRegistry(DEFAULT_NAME_TO_INCREMENTAL_AGGREGATOR, DEFAULT_NAME_TO_OTF_AGGREGATOR, AggregatorIncrementalType.NAME_TO_ORDINAL);
    private transient boolean setup = false;
    private transient Map<Class<? extends IncrementalAggregator>, String> classToIncrementalAggregatorName;
    private transient Map<String, List<String>> otfAggregatorToIncrementalAggregators;
    private transient Map<Integer, IncrementalAggregator> incrementalAggregatorIDToAggregator;
    protected transient Map<Integer, AbstractTopBottomAggregator> topBottomAggregatorIDToAggregator;
    private Map<String, IncrementalAggregator> nameToIncrementalAggregator;
    private Map<String, OTFAggregator> nameToOTFAggregator;
    private Map<String, AbstractTopBottomAggregator> nameToTopBottomAggregator = Maps.newHashMap();
    private Map<String, Integer> incrementalAggregatorNameToID;
    protected Map<String, Integer> topBottomAggregatorNameToID = Maps.newHashMap();
    protected static Set<String> topBottomAggregatorNames;
    private static final Logger lOG;

    public static final AggregatorRegistry newDefaultAggregatorRegistry() {
        AggregatorRegistry aggregatorRegistry = new AggregatorRegistry(DEFAULT_NAME_TO_INCREMENTAL_AGGREGATOR, DEFAULT_NAME_TO_OTF_AGGREGATOR, AggregatorIncrementalType.NAME_TO_ORDINAL);
        aggregatorRegistry.setup();
        return aggregatorRegistry;
    }

    private static Map<String, Integer> autoGenIds(Map<String, IncrementalAggregator> nameToAggregator) {
        HashMap staticAggregatorNameToID = Maps.newHashMap();
        for (Map.Entry<String, IncrementalAggregator> entry : nameToAggregator.entrySet()) {
            staticAggregatorNameToID.put(entry.getKey(), AggregatorRegistry.stringHash(entry.getValue().getClass().getName()));
        }
        return staticAggregatorNameToID;
    }

    private static int stringHash(String string) {
        int hash = 5381;
        for (int index = 0; index < string.length(); ++index) {
            char character = string.charAt(index);
            hash = hash * 33 + character;
        }
        return hash;
    }

    private AggregatorRegistry() {
    }

    public AggregatorRegistry(Map<String, IncrementalAggregator> nameToIncrementalAggregator, Map<String, OTFAggregator> nameToOTFAggregator) {
        this(nameToIncrementalAggregator, nameToOTFAggregator, AggregatorRegistry.autoGenIds(nameToIncrementalAggregator));
    }

    public AggregatorRegistry(Map<String, IncrementalAggregator> nameToIncrementalAggregator, Map<String, OTFAggregator> nameToOTFAggregator, Map<String, Integer> incrementalAggregatorNameToID) {
        this.setNameToIncrementalAggregator(nameToIncrementalAggregator);
        this.setNameToOTFAggregator(nameToOTFAggregator);
        this.setIncrementalAggregatorNameToID(incrementalAggregatorNameToID);
        this.validate();
    }

    private void validate() {
        for (Map.Entry<String, IncrementalAggregator> entry : this.nameToIncrementalAggregator.entrySet()) {
            Preconditions.checkNotNull((Object)entry.getKey());
            Preconditions.checkNotNull((Object)entry.getValue());
        }
        for (Map.Entry<String, Object> entry : this.nameToOTFAggregator.entrySet()) {
            Preconditions.checkNotNull((Object)entry.getKey());
            Preconditions.checkNotNull((Object)entry.getValue());
        }
        for (Map.Entry<String, Object> entry : this.incrementalAggregatorNameToID.entrySet()) {
            Preconditions.checkNotNull((Object)entry.getKey());
            Preconditions.checkNotNull((Object)entry.getValue());
        }
        for (Map.Entry<String, Object> entry : this.topBottomAggregatorNameToID.entrySet()) {
            Preconditions.checkNotNull((Object)entry.getKey());
            Preconditions.checkNotNull((Object)entry.getValue());
        }
        for (Map.Entry<String, Object> entry : this.nameToTopBottomAggregator.entrySet()) {
            Preconditions.checkNotNull((Object)entry.getKey());
            Preconditions.checkNotNull((Object)entry.getValue());
        }
    }

    public void setup() {
        if (this.setup) {
            return;
        }
        this.setup = true;
        this.classToIncrementalAggregatorName = Maps.newHashMap();
        for (Map.Entry<String, IncrementalAggregator> entry : this.nameToIncrementalAggregator.entrySet()) {
            this.classToIncrementalAggregatorName.put(entry.getValue().getClass(), entry.getKey());
        }
        this.incrementalAggregatorIDToAggregator = Maps.newHashMap();
        for (Map.Entry<String, Object> entry : this.incrementalAggregatorNameToID.entrySet()) {
            String aggregatorName = entry.getKey();
            int aggregatorID = (Integer)entry.getValue();
            this.incrementalAggregatorIDToAggregator.put(aggregatorID, this.nameToIncrementalAggregator.get(aggregatorName));
        }
        this.otfAggregatorToIncrementalAggregators = Maps.newHashMap();
        for (Map.Entry<String, Object> entry : this.nameToOTFAggregator.entrySet()) {
            String name = entry.getKey();
            ArrayList staticAggregators = Lists.newArrayList();
            OTFAggregator dotfAggregator = this.nameToOTFAggregator.get(name);
            for (Class<? extends IncrementalAggregator> clazz : dotfAggregator.getChildAggregators()) {
                staticAggregators.add(this.classToIncrementalAggregatorName.get(clazz));
            }
            this.otfAggregatorToIncrementalAggregators.put(name, staticAggregators);
        }
    }

    public void buildTopBottomAggregatorIDToAggregator() {
        this.topBottomAggregatorIDToAggregator = Maps.newHashMap();
        for (Map.Entry<String, Integer> entry : this.topBottomAggregatorNameToID.entrySet()) {
            String aggregatorName = entry.getKey();
            int aggregatorID = entry.getValue();
            this.topBottomAggregatorIDToAggregator.put(aggregatorID, this.nameToTopBottomAggregator.get(aggregatorName));
        }
    }

    private void setNameToIncrementalAggregator(Map<String, IncrementalAggregator> nameToIncrementalAggregator) {
        this.nameToIncrementalAggregator = Maps.newHashMap((Map)((Map)Preconditions.checkNotNull(nameToIncrementalAggregator)));
    }

    private void setNameToOTFAggregator(Map<String, OTFAggregator> nameToOTFAggregator) {
        this.nameToOTFAggregator = Maps.newHashMap((Map)((Map)Preconditions.checkNotNull(nameToOTFAggregator)));
    }

    public boolean isAggregator(String aggregatorName) {
        if (this.classToIncrementalAggregatorName.values().contains(aggregatorName) || this.nameToOTFAggregator.containsKey(aggregatorName)) {
            return true;
        }
        String aggregatorType = aggregatorName.split("-")[0];
        return AggregatorTopBottomType.valueOf(aggregatorType) != null;
    }

    public boolean isIncrementalAggregator(String aggregatorName) {
        return this.classToIncrementalAggregatorName.values().contains(aggregatorName);
    }

    public boolean isOTFAggregator(String aggregatorName) {
        return this.nameToOTFAggregator.containsKey(aggregatorName);
    }

    public boolean isTopBottomAggregatorType(String aggregatorType) {
        return AggregatorTopBottomType.valueOf(aggregatorType) != null;
    }

    public Map<Class<? extends IncrementalAggregator>, String> getClassToIncrementalAggregatorName() {
        return this.classToIncrementalAggregatorName;
    }

    public Map<Integer, IncrementalAggregator> getIncrementalAggregatorIDToAggregator() {
        return this.incrementalAggregatorIDToAggregator;
    }

    public Map<Integer, AbstractTopBottomAggregator> getTopBottomAggregatorIDToAggregator() {
        return this.topBottomAggregatorIDToAggregator;
    }

    private void setIncrementalAggregatorNameToID(Map<String, Integer> incrementalAggregatorNameToID) {
        Preconditions.checkNotNull(incrementalAggregatorNameToID);
        for (Map.Entry<String, Integer> entry : incrementalAggregatorNameToID.entrySet()) {
            Preconditions.checkNotNull((Object)entry.getKey());
            Preconditions.checkNotNull((Object)entry.getValue());
        }
        this.incrementalAggregatorNameToID = Maps.newHashMap(incrementalAggregatorNameToID);
    }

    public Map<String, Integer> getIncrementalAggregatorNameToID() {
        return this.incrementalAggregatorNameToID;
    }

    public Map<String, Integer> getTopBottomAggregatorNameToID() {
        return this.topBottomAggregatorNameToID;
    }

    public Map<String, OTFAggregator> getNameToOTFAggregators() {
        return this.nameToOTFAggregator;
    }

    public Map<String, AbstractTopBottomAggregator> getNameToTopBottomAggregator() {
        return this.nameToTopBottomAggregator;
    }

    public Map<String, List<String>> getOTFAggregatorToIncrementalAggregators() {
        return this.otfAggregatorToIncrementalAggregators;
    }

    public Map<String, IncrementalAggregator> getNameToIncrementalAggregator() {
        return this.nameToIncrementalAggregator;
    }

    static {
        lOG = LoggerFactory.getLogger(AggregatorRegistry.class);
    }
}

