/*
 * Decompiled with CFR 0.152.
 */
package org.apache.apex.malhar.lib.dimensions.aggregator;

import com.datatorrent.api.annotation.Name;
import com.datatorrent.lib.appdata.gpo.GPOMutable;
import com.datatorrent.lib.appdata.gpo.GPOUtils;
import com.datatorrent.lib.appdata.schemas.FieldsDescriptor;
import com.datatorrent.lib.appdata.schemas.Type;
import org.apache.apex.malhar.lib.dimensions.DimensionsEvent;
import org.apache.apex.malhar.lib.dimensions.aggregator.AbstractIncrementalAggregator;
import org.apache.apex.malhar.lib.dimensions.aggregator.AggregatorUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Name(value="SUM")
public class AggregatorSum
extends AbstractIncrementalAggregator {
    private static final long serialVersionUID = 20154301649L;
    private static final Logger LOG = LoggerFactory.getLogger(AggregatorSum.class);

    @Override
    public DimensionsEvent.Aggregate getGroup(DimensionsEvent.InputEvent src, int aggregatorIndex) {
        src.used = true;
        DimensionsEvent.Aggregate aggregate = AggregatorSum.createAggregate(src, this.context, aggregatorIndex);
        GPOMutable value = aggregate.getAggregates();
        GPOUtils.zeroFillNumeric(value);
        return aggregate;
    }

    @Override
    public void aggregate(DimensionsEvent.Aggregate dest, DimensionsEvent.Aggregate src) {
        GPOMutable destAggs = dest.getAggregates();
        GPOMutable srcAggs = src.getAggregates();
        this.aggregateAggs(destAggs, srcAggs);
    }

    public void aggregateAggs(GPOMutable destAggs, GPOMutable srcAggs) {
        double[] destDouble;
        float[] destFloat;
        long[] destLong;
        int[] destInteger;
        short[] destShort;
        int index;
        byte[] destByte = destAggs.getFieldsByte();
        if (destByte != null) {
            byte[] srcByte = srcAggs.getFieldsByte();
            for (index = 0; index < destByte.length; ++index) {
                int n = index;
                destByte[n] = (byte)(destByte[n] + srcByte[index]);
            }
        }
        if ((destShort = destAggs.getFieldsShort()) != null) {
            short[] srcShort = srcAggs.getFieldsShort();
            for (index = 0; index < destShort.length; ++index) {
                int n = index;
                destShort[n] = (short)(destShort[n] + srcShort[index]);
            }
        }
        if ((destInteger = destAggs.getFieldsInteger()) != null) {
            int[] srcInteger = srcAggs.getFieldsInteger();
            for (index = 0; index < destInteger.length; ++index) {
                int n = index;
                destInteger[n] = destInteger[n] + srcInteger[index];
            }
        }
        if ((destLong = destAggs.getFieldsLong()) != null) {
            long[] srcLong = srcAggs.getFieldsLong();
            for (index = 0; index < destLong.length; ++index) {
                int n = index;
                destLong[n] = destLong[n] + srcLong[index];
            }
        }
        if ((destFloat = destAggs.getFieldsFloat()) != null) {
            float[] srcFloat = srcAggs.getFieldsFloat();
            for (index = 0; index < destFloat.length; ++index) {
                int n = index;
                destFloat[n] = destFloat[n] + srcFloat[index];
            }
        }
        if ((destDouble = destAggs.getFieldsDouble()) != null) {
            double[] srcDouble = srcAggs.getFieldsDouble();
            for (index = 0; index < destDouble.length; ++index) {
                int n = index;
                destDouble[n] = destDouble[n] + srcDouble[index];
            }
        }
    }

    @Override
    public void aggregate(DimensionsEvent.Aggregate dest, DimensionsEvent.InputEvent src) {
        GPOMutable destAggs = dest.getAggregates();
        GPOMutable srcAggs = src.getAggregates();
        this.aggregateInput(destAggs, srcAggs);
    }

    public void aggregateInput(GPOMutable destAggs, GPOMutable srcAggs) {
        double[] destDouble;
        float[] destFloat;
        long[] destLong;
        int[] destInteger;
        short[] destShort;
        int index;
        int[] srcIndices;
        byte[] destByte = destAggs.getFieldsByte();
        if (destByte != null) {
            byte[] srcByte = srcAggs.getFieldsByte();
            srcIndices = this.context.indexSubsetAggregates.fieldsByteIndexSubset;
            for (index = 0; index < destByte.length; ++index) {
                int n = index;
                destByte[n] = (byte)(destByte[n] + srcByte[srcIndices[index]]);
            }
        }
        if ((destShort = destAggs.getFieldsShort()) != null) {
            short[] srcShort = srcAggs.getFieldsShort();
            srcIndices = this.context.indexSubsetAggregates.fieldsShortIndexSubset;
            for (index = 0; index < destShort.length; ++index) {
                int n = index;
                destShort[n] = (short)(destShort[n] + srcShort[srcIndices[index]]);
            }
        }
        if ((destInteger = destAggs.getFieldsInteger()) != null) {
            int[] srcInteger = srcAggs.getFieldsInteger();
            srcIndices = this.context.indexSubsetAggregates.fieldsIntegerIndexSubset;
            for (index = 0; index < destInteger.length; ++index) {
                int n = index;
                destInteger[n] = destInteger[n] + srcInteger[srcIndices[index]];
            }
        }
        if ((destLong = destAggs.getFieldsLong()) != null) {
            long[] srcLong = srcAggs.getFieldsLong();
            srcIndices = this.context.indexSubsetAggregates.fieldsLongIndexSubset;
            for (index = 0; index < destLong.length; ++index) {
                int n = index;
                destLong[n] = destLong[n] + srcLong[srcIndices[index]];
            }
        }
        if ((destFloat = destAggs.getFieldsFloat()) != null) {
            float[] srcFloat = srcAggs.getFieldsFloat();
            srcIndices = this.context.indexSubsetAggregates.fieldsFloatIndexSubset;
            for (index = 0; index < destFloat.length; ++index) {
                int n = index;
                destFloat[n] = destFloat[n] + srcFloat[srcIndices[index]];
            }
        }
        if ((destDouble = destAggs.getFieldsDouble()) != null) {
            double[] srcDouble = srcAggs.getFieldsDouble();
            srcIndices = this.context.indexSubsetAggregates.fieldsDoubleIndexSubset;
            for (index = 0; index < destDouble.length; ++index) {
                int n = index;
                destDouble[n] = destDouble[n] + srcDouble[srcIndices[index]];
            }
        }
    }

    @Override
    public Type getOutputType(Type inputType) {
        return AggregatorUtils.IDENTITY_NUMBER_TYPE_MAP.get(inputType);
    }

    @Override
    public FieldsDescriptor getMetaDataDescriptor() {
        return null;
    }
}

