/*
 * Decompiled with CFR 0.152.
 */
package org.apache.apex.malhar.lib.dimensions.aggregator;

import com.datatorrent.lib.appdata.gpo.SerdeMapPrimitive;
import com.datatorrent.lib.appdata.schemas.Fields;
import com.datatorrent.lib.appdata.schemas.FieldsDescriptor;
import com.datatorrent.lib.appdata.schemas.Type;
import com.google.common.collect.Maps;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.apex.malhar.lib.dimensions.aggregator.CompositeAggregator;
import org.apache.apex.malhar.lib.dimensions.aggregator.IncrementalAggregator;
import org.apache.apex.malhar.lib.dimensions.aggregator.OTFAggregator;

public final class AggregatorUtils {
    public static final transient Map<Type, Type> IDENTITY_TYPE_MAP;
    public static final transient Map<Type, Type> IDENTITY_NUMBER_TYPE_MAP;

    private AggregatorUtils() {
    }

    public static FieldsDescriptor getOutputFieldsDescriptor(FieldsDescriptor inputFieldsDescriptor, IncrementalAggregator incrementalAggregator) {
        HashMap fieldToType = Maps.newHashMap();
        for (Map.Entry<String, Type> entry : inputFieldsDescriptor.getFieldToType().entrySet()) {
            String fieldName = entry.getKey();
            Type fieldType = entry.getValue();
            Type outputType = incrementalAggregator.getOutputType(fieldType);
            fieldToType.put(fieldName, outputType);
        }
        return new FieldsDescriptor(fieldToType);
    }

    public static FieldsDescriptor getOutputFieldsDescriptor(FieldsDescriptor inputFieldsDescriptor, OTFAggregator otfAggregator) {
        HashMap fieldToType = Maps.newHashMap();
        for (Map.Entry<String, Type> entry : inputFieldsDescriptor.getFieldToType().entrySet()) {
            String fieldName = entry.getKey();
            Type outputType = otfAggregator.getOutputType();
            fieldToType.put(fieldName, outputType);
        }
        return new FieldsDescriptor(fieldToType);
    }

    public static FieldsDescriptor getOutputFieldsDescriptor(Fields fields, OTFAggregator otfAggregator) {
        HashMap fieldToType = Maps.newHashMap();
        for (String field : fields.getFields()) {
            fieldToType.put(field, otfAggregator.getOutputType());
        }
        return new FieldsDescriptor(fieldToType);
    }

    public static FieldsDescriptor getOutputFieldsDescriptor(FieldsDescriptor inputFieldsDescriptor, CompositeAggregator compositeAggregator) {
        HashMap fieldToType = Maps.newHashMap();
        HashMap fieldToSerde = Maps.newHashMap();
        for (Map.Entry<String, Type> entry : inputFieldsDescriptor.getFieldToType().entrySet()) {
            String fieldName = entry.getKey();
            Type outputType = compositeAggregator.getOutputType();
            fieldToType.put(fieldName, outputType);
            fieldToSerde.put(fieldName, SerdeMapPrimitive.INSTANCE);
        }
        return new FieldsDescriptor((Map<String, Type>)fieldToType, fieldToSerde);
    }

    static {
        HashMap identityTypeMap = Maps.newHashMap();
        for (Type type : Type.values()) {
            identityTypeMap.put(type, type);
        }
        IDENTITY_TYPE_MAP = Collections.unmodifiableMap(identityTypeMap);
        HashMap identityNumberTypeMap = Maps.newHashMap();
        for (Type type : Type.NUMERIC_TYPES) {
            identityNumberTypeMap.put(type, type);
        }
        IDENTITY_NUMBER_TYPE_MAP = Collections.unmodifiableMap(identityNumberTypeMap);
    }
}

