/*
 * Decompiled with CFR 0.152.
 */
package org.apache.apex.malhar.lib.dimensions.aggregator;

import com.google.common.collect.Sets;
import java.util.Map;
import java.util.TreeSet;
import org.apache.apex.malhar.lib.dimensions.aggregator.AbstractCompositeAggregatorFactory;
import org.apache.apex.malhar.lib.dimensions.aggregator.AbstractTopBottomAggregator;
import org.apache.apex.malhar.lib.dimensions.aggregator.AggregatorBottom;
import org.apache.apex.malhar.lib.dimensions.aggregator.AggregatorTop;
import org.apache.apex.malhar.lib.dimensions.aggregator.AggregatorTopBottomType;

public class TopBottomAggregatorFactory
extends AbstractCompositeAggregatorFactory {
    public static final String PROPERTY_NAME_EMBEDED_AGGREGATOR = "embededAggregator";
    public static final String PROPERTY_NAME_COUNT = "count";
    public static final String PROPERTY_NAME_SUB_COMBINATIONS = "subCombinations";
    public static final TopBottomAggregatorFactory defaultInstance = new TopBottomAggregatorFactory();

    @Override
    public <T> AbstractTopBottomAggregator createCompositeAggregator(String aggregatorType, String embedAggregatorName, Map<String, Object> properties) {
        return this.createTopBottomAggregator(aggregatorType, embedAggregatorName, this.getCount(properties), this.getSubCombinations(properties));
    }

    public <T> AbstractTopBottomAggregator createTopBottomAggregator(String aggregatorType, String embedAggregatorName, int count, String[] subCombinations) {
        AbstractTopBottomAggregator aggregator = null;
        if (AggregatorTopBottomType.TOPN == AggregatorTopBottomType.valueOf(aggregatorType)) {
            aggregator = new AggregatorTop();
        }
        if (AggregatorTopBottomType.BOTTOMN == AggregatorTopBottomType.valueOf(aggregatorType)) {
            aggregator = new AggregatorBottom();
        }
        if (aggregator == null) {
            throw new IllegalArgumentException("Invalid composite type: " + aggregatorType);
        }
        aggregator.setEmbedAggregatorName(embedAggregatorName);
        aggregator.setCount(count);
        aggregator.setSubCombinations(subCombinations);
        return aggregator;
    }

    protected int getCount(Map<String, Object> properties) {
        return Integer.valueOf((String)properties.get(PROPERTY_NAME_COUNT));
    }

    protected String[] getSubCombinations(Map<String, Object> properties) {
        return (String[])properties.get(PROPERTY_NAME_SUB_COMBINATIONS);
    }

    @Override
    protected String getNamePartialForProperties(Map<String, Object> properties) {
        StringBuilder sb = new StringBuilder();
        String count = (String)properties.get(PROPERTY_NAME_COUNT);
        sb.append(count).append("_");
        String[] subCombinations = (String[])properties.get(PROPERTY_NAME_SUB_COMBINATIONS);
        TreeSet sortedSubCombinations = Sets.newTreeSet();
        for (String subCombination : subCombinations) {
            sortedSubCombinations.add(subCombination);
        }
        for (String subCombination : sortedSubCombinations) {
            sb.append(subCombination).append("_");
        }
        return sb.deleteCharAt(sb.length() - 1).toString();
    }
}

