/*
 * Decompiled with CFR 0.152.
 */
package org.apache.apex.malhar.lib.fs;

import com.datatorrent.api.AutoMetric;
import com.datatorrent.api.DefaultInputPort;
import com.datatorrent.api.StreamCodec;
import com.datatorrent.lib.io.fs.AbstractSingleFileOutputOperator;
import com.datatorrent.netlet.util.DTThrowable;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.concurrent.ExecutionException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BytesFileOutputOperator
extends AbstractSingleFileOutputOperator<byte[]> {
    private transient boolean isNewDataInCurrentWindow;
    private String tupleSeparator;
    private transient byte[] tupleSeparatorBytes;
    @AutoMetric
    private long byteCount;
    private long currentPartTupleCount;
    private long maxTupleCount = Long.MAX_VALUE;
    private long currentPartIdleWindows;
    private long maxIdleWindows = Long.MAX_VALUE;
    protected StreamCodec<String> stringStreamCodec;
    private static final long DEFAULT_STREAM_EXPIRY_ACCESS_MILL = 3600000L;
    private static final int DEFAULT_ROTATION_WINDOWS = 1200;
    public final transient DefaultInputPort<String> stringInput = new DefaultInputPort<String>(){

        public void process(String tuple) {
            BytesFileOutputOperator.this.processTuple(tuple.getBytes());
        }

        public StreamCodec<String> getStreamCodec() {
            if (BytesFileOutputOperator.this.stringStreamCodec == null) {
                return super.getStreamCodec();
            }
            return BytesFileOutputOperator.this.stringStreamCodec;
        }
    };
    private static final Logger LOG = LoggerFactory.getLogger(BytesFileOutputOperator.class);

    public BytesFileOutputOperator() {
        this.setTupleSeparator(System.getProperty("line.separator"));
        this.setExpireStreamAfterAccessMillis(3600000L);
        this.setRotationWindows(1200);
    }

    @Override
    protected byte[] getBytesForTuple(byte[] tuple) {
        ByteArrayOutputStream bytesOutStream = new ByteArrayOutputStream();
        try {
            bytesOutStream.write(tuple);
            bytesOutStream.write(this.tupleSeparatorBytes);
            this.byteCount += (long)bytesOutStream.size();
            byte[] byArray = bytesOutStream.toByteArray();
            return byArray;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        finally {
            try {
                bytesOutStream.close();
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }

    @Override
    public void beginWindow(long windowId) {
        super.beginWindow(windowId);
        this.byteCount = 0L;
        this.isNewDataInCurrentWindow = false;
    }

    @Override
    protected void processTuple(byte[] tuple) {
        super.processTuple(tuple);
        this.isNewDataInCurrentWindow = true;
        if (++this.currentPartTupleCount == this.maxTupleCount) {
            this.rotateCall(this.getPartitionedFileName());
        }
    }

    @Override
    public void endWindow() {
        super.endWindow();
        this.currentPartIdleWindows = !this.isNewDataInCurrentWindow ? ++this.currentPartIdleWindows : 0L;
        if (this.checkEndWindowFinalization()) {
            this.rotateCall(this.getPartitionedFileName());
        }
    }

    private boolean checkEndWindowFinalization() {
        return this.currentPartIdleWindows == this.maxIdleWindows;
    }

    protected void rotateCall(String lastFile) {
        try {
            this.rotate(lastFile);
            this.currentPartIdleWindows = 0L;
            this.currentPartTupleCount = 0L;
        }
        catch (IOException ex) {
            LOG.error("Exception in file rotation", (Throwable)ex);
            DTThrowable.rethrow((Exception)ex);
        }
        catch (ExecutionException ex) {
            LOG.error("Exception in file rotation", (Throwable)ex);
            DTThrowable.rethrow((Exception)ex);
        }
    }

    public String getTupleSeparator() {
        return this.tupleSeparator;
    }

    public void setTupleSeparator(String separator) {
        this.tupleSeparator = separator;
        this.tupleSeparatorBytes = separator.getBytes();
    }

    public long getMaxTupleCount() {
        return this.maxTupleCount;
    }

    public void setMaxTupleCount(long maxTupleCount) {
        this.maxTupleCount = maxTupleCount;
    }

    public long getMaxIdleWindows() {
        return this.maxIdleWindows;
    }

    public void setMaxIdleWindows(long maxIdleWindows) {
        this.maxIdleWindows = maxIdleWindows;
    }
}

