/*
 * Decompiled with CFR 0.152.
 */
package org.apache.apex.malhar.lib.state.managed;

import com.datatorrent.lib.fileaccess.FileAccess;
import com.datatorrent.netlet.util.Slice;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.io.IOException;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import java.util.TreeSet;
import java.util.concurrent.ConcurrentSkipListMap;
import java.util.concurrent.atomic.AtomicLong;
import javax.validation.constraints.NotNull;
import org.apache.apex.malhar.lib.state.managed.BucketsFileSystem;
import org.apache.apex.malhar.lib.state.managed.ManagedStateComponent;
import org.apache.apex.malhar.lib.state.managed.ManagedStateContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public interface Bucket
extends ManagedStateComponent {
    public long getBucketId();

    public long getSizeInBytes();

    public Slice get(Slice var1, long var2, ReadSource var4);

    public void put(Slice var1, long var2, Slice var4);

    public Map<Slice, BucketedValue> checkpoint(long var1);

    public void committed(long var1);

    public long freeMemory(long var1) throws IOException;

    public void recoveredData(long var1, Map<Slice, BucketedValue> var3);

    public static class DefaultBucket
    implements Bucket {
        private final long bucketId;
        private transient Map<Slice, BucketedValue> flash = Maps.newConcurrentMap();
        private final transient ConcurrentSkipListMap<Long, Map<Slice, BucketedValue>> checkpointedData = new ConcurrentSkipListMap();
        private final transient ConcurrentSkipListMap<Long, Map<Slice, BucketedValue>> committedData = new ConcurrentSkipListMap();
        private final transient Map<Slice, BucketedValue> fileCache = Maps.newConcurrentMap();
        private final transient Map<Long, FileAccess.FileReader> readers = Maps.newTreeMap();
        protected transient ManagedStateContext managedStateContext;
        private AtomicLong sizeInBytes = new AtomicLong(0L);
        private final transient Slice dummyGetKey = new Slice(null, 0, 0);
        private transient TreeSet<BucketsFileSystem.TimeBucketMeta> cachedBucketMetas;
        private static final Logger LOG = LoggerFactory.getLogger(DefaultBucket.class);

        private DefaultBucket() {
            this.bucketId = -1L;
        }

        protected DefaultBucket(long bucketId) {
            this.bucketId = bucketId;
        }

        @Override
        public void setup(@NotNull ManagedStateContext managedStateContext) {
            this.managedStateContext = (ManagedStateContext)Preconditions.checkNotNull((Object)managedStateContext, (Object)"managed state context");
        }

        @Override
        public long getBucketId() {
            return this.bucketId;
        }

        @Override
        public long getSizeInBytes() {
            return this.sizeInBytes.longValue();
        }

        private Slice getFromMemory(Slice key) {
            BucketedValue bucketedValue = this.flash.get(key);
            if (bucketedValue != null) {
                return bucketedValue.getValue();
            }
            for (Long window : this.checkpointedData.descendingKeySet()) {
                bucketedValue = this.checkpointedData.get(window).get(key);
                if (bucketedValue == null) continue;
                return bucketedValue.getValue();
            }
            for (Long window : this.committedData.descendingKeySet()) {
                bucketedValue = this.committedData.get(window).get(key);
                if (bucketedValue == null) continue;
                return bucketedValue.getValue();
            }
            bucketedValue = this.fileCache.get(key);
            if (bucketedValue != null) {
                return bucketedValue.getValue();
            }
            return null;
        }

        private Slice getFromReaders(Slice key, long timeBucket) {
            try {
                if (this.cachedBucketMetas == null) {
                    this.cachedBucketMetas = this.managedStateContext.getBucketsFileSystem().getAllTimeBuckets(this.bucketId);
                }
                if (timeBucket != -1L) {
                    Slice valSlice = this.getValueFromTimeBucketReader(key, timeBucket);
                    if (valSlice != null && timeBucket == this.cachedBucketMetas.first().getTimeBucketId()) {
                        BucketedValue bucketedValue = new BucketedValue(timeBucket, valSlice);
                        this.fileCache.put(key, bucketedValue);
                    }
                    return valSlice;
                }
                for (BucketsFileSystem.TimeBucketMeta immutableTimeBucketMeta : this.cachedBucketMetas) {
                    Slice valSlice;
                    if (this.managedStateContext.getKeyComparator().compare(key, immutableTimeBucketMeta.getFirstKey()) < 0 || (valSlice = this.getValueFromTimeBucketReader(key, immutableTimeBucketMeta.getTimeBucketId())) == null) continue;
                    BucketedValue bucketedValue = new BucketedValue(immutableTimeBucketMeta.getTimeBucketId(), valSlice);
                    this.fileCache.put(key, bucketedValue);
                    return valSlice;
                }
                return null;
            }
            catch (IOException e) {
                throw new RuntimeException("get time-buckets " + this.bucketId, e);
            }
        }

        @Override
        public Slice get(Slice key, long timeBucket, ReadSource readSource) {
            switch (readSource) {
                case MEMORY: {
                    return this.getFromMemory(key);
                }
                case READERS: {
                    return this.getFromReaders(key, timeBucket);
                }
            }
            Slice value = this.getFromMemory(key);
            if (value != null) {
                return value;
            }
            return this.getFromReaders(key, timeBucket);
        }

        private Slice getValueFromTimeBucketReader(Slice key, long timeBucket) {
            FileAccess.FileReader fileReader = this.readers.get(timeBucket);
            if (fileReader != null) {
                return this.readValue(fileReader, key, timeBucket);
            }
            try {
                if (this.loadFileReader(timeBucket)) {
                    return this.readValue(this.readers.get(timeBucket), key, timeBucket);
                }
                return null;
            }
            catch (IOException e) {
                throw new RuntimeException("while loading " + this.bucketId + ", " + timeBucket, e);
            }
        }

        private Slice readValue(FileAccess.FileReader fileReader, Slice key, long timeBucket) {
            Slice valSlice = new Slice(null, 0, 0);
            try {
                if (fileReader.seek(key)) {
                    fileReader.next(this.dummyGetKey, valSlice);
                    return valSlice;
                }
                return null;
            }
            catch (IOException e) {
                throw new RuntimeException("reading " + this.bucketId + ", " + timeBucket, e);
            }
        }

        private boolean loadFileReader(long timeBucketId) throws IOException {
            BucketsFileSystem.TimeBucketMeta tbm = this.managedStateContext.getBucketsFileSystem().getTimeBucketMeta(this.bucketId, timeBucketId);
            if (tbm != null) {
                FileAccess.FileReader reader = this.managedStateContext.getBucketsFileSystem().getReader(this.bucketId, BucketsFileSystem.getFileName(timeBucketId));
                this.readers.put(timeBucketId, reader);
                this.sizeInBytes.getAndAdd(tbm.getSizeInBytes());
                return true;
            }
            return false;
        }

        @Override
        public void put(Slice key, long timeBucket, Slice value) {
            BucketedValue bucketedValue = this.flash.get(key);
            if (bucketedValue == null) {
                bucketedValue = new BucketedValue();
                this.flash.put(key, bucketedValue);
                this.sizeInBytes.getAndAdd(key.length);
                this.sizeInBytes.getAndAdd(64L);
            }
            if (timeBucket > bucketedValue.getTimeBucket()) {
                int inc = null == bucketedValue.getValue() ? value.length : value.length - bucketedValue.getValue().length;
                this.sizeInBytes.getAndAdd(inc);
                bucketedValue.setTimeBucket(timeBucket);
                bucketedValue.setValue(value);
            }
        }

        @Override
        public long freeMemory(long windowId) throws IOException {
            Long clearWindowId;
            long memoryFreed = 0L;
            while ((clearWindowId = this.committedData.floorKey(windowId)) != null) {
                Map<Slice, BucketedValue> windowData = this.committedData.remove(clearWindowId);
                for (Map.Entry<Slice, BucketedValue> entry : windowData.entrySet()) {
                    memoryFreed += (long)(entry.getKey().length + entry.getValue().getValue().length);
                }
            }
            this.fileCache.clear();
            if (this.cachedBucketMetas != null) {
                for (BucketsFileSystem.TimeBucketMeta tbm : this.cachedBucketMetas) {
                    FileAccess.FileReader reader = this.readers.remove(tbm.getTimeBucketId());
                    if (reader == null) continue;
                    memoryFreed += tbm.getSizeInBytes();
                    reader.close();
                }
            }
            this.sizeInBytes.getAndAdd(-memoryFreed);
            LOG.debug("space freed {} {}", (Object)this.bucketId, (Object)memoryFreed);
            return memoryFreed;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Map<Slice, BucketedValue> checkpoint(long windowId) {
            try {
                Map<Slice, BucketedValue> map = this.flash;
                return map;
            }
            finally {
                this.checkpointedData.put(windowId, this.flash);
                this.flash = Maps.newHashMap();
            }
        }

        @Override
        public void committed(long committedWindowId) {
            Map.Entry<Long, Map<Slice, BucketedValue>> entry;
            long savedWindow;
            Iterator<Map.Entry<Long, Map<Slice, BucketedValue>>> stateIterator = this.checkpointedData.entrySet().iterator();
            while (stateIterator.hasNext() && (savedWindow = (entry = stateIterator.next()).getKey().longValue()) <= committedWindowId) {
                Map<Slice, BucketedValue> bucketData = entry.getValue();
                for (Slice key : bucketData.keySet()) {
                    this.fileCache.remove(key);
                }
                for (BucketedValue bucketedValue : bucketData.values()) {
                    FileAccess.FileReader reader = this.readers.get(bucketedValue.getTimeBucket());
                    if (reader != null) {
                        try {
                            LOG.debug("closing reader {} {}", (Object)this.bucketId, (Object)bucketedValue.getTimeBucket());
                            reader.close();
                        }
                        catch (IOException e) {
                            throw new RuntimeException("closing reader " + this.bucketId + ", " + bucketedValue.getTimeBucket(), e);
                        }
                        this.readers.remove(bucketedValue.getTimeBucket());
                    }
                    if (!this.readers.isEmpty()) continue;
                    break;
                }
                this.committedData.put(savedWindow, bucketData);
                stateIterator.remove();
            }
            this.cachedBucketMetas = null;
        }

        @Override
        public void recoveredData(long recoveredWindow, Map<Slice, BucketedValue> data) {
            this.checkpointedData.put(recoveredWindow, data);
        }

        @Override
        public void teardown() {
            HashSet failureBuckets = Sets.newHashSet();
            for (Map.Entry<Long, FileAccess.FileReader> entry : this.readers.entrySet()) {
                try {
                    LOG.debug("closing reader {} {}", (Object)this.bucketId, (Object)entry.getKey());
                    entry.getValue().close();
                }
                catch (IOException e) {
                    failureBuckets.add(entry.getKey());
                }
            }
            if (!failureBuckets.isEmpty()) {
                StringBuilder builder = new StringBuilder("teardown of ");
                builder.append(this.bucketId).append(" < ");
                for (Long timeBucket : failureBuckets) {
                    builder.append(timeBucket);
                }
                builder.append(">");
                throw new RuntimeException(builder.toString());
            }
        }

        @VisibleForTesting
        Map<Long, FileAccess.FileReader> getReaders() {
            return this.readers;
        }

        @VisibleForTesting
        ConcurrentSkipListMap<Long, Map<Slice, BucketedValue>> getCommittedData() {
            return this.committedData;
        }

        @VisibleForTesting
        ConcurrentSkipListMap<Long, Map<Slice, BucketedValue>> getCheckpointedData() {
            return this.checkpointedData;
        }
    }

    public static class BucketedValue {
        private long timeBucket;
        private Slice value;

        protected BucketedValue() {
        }

        protected BucketedValue(long timeBucket, Slice value) {
            this.timeBucket = timeBucket;
            this.value = value;
        }

        protected long getTimeBucket() {
            return this.timeBucket;
        }

        protected void setTimeBucket(long timeBucket) {
            this.timeBucket = timeBucket;
        }

        public Slice getValue() {
            return this.value;
        }

        public void setValue(Slice value) {
            this.value = value;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof BucketedValue)) {
                return false;
            }
            BucketedValue that = (BucketedValue)o;
            return this.timeBucket == that.timeBucket && this.value.equals((Object)that.value);
        }

        public int hashCode() {
            return Objects.hash(this.timeBucket, this.value);
        }
    }

    public static enum ReadSource {
        MEMORY,
        READERS,
        ALL;

    }
}

