/*
 * Decompiled with CFR 0.152.
 */
package org.apache.apex.malhar.lib.state.managed;

import com.datatorrent.lib.fileaccess.FileAccess;
import com.datatorrent.netlet.util.Slice;
import com.google.common.base.Preconditions;
import com.google.common.collect.Ordering;
import com.google.common.collect.Sets;
import com.google.common.collect.TreeBasedTable;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.concurrent.ConcurrentSkipListSet;
import javax.annotation.Nullable;
import javax.validation.constraints.NotNull;
import org.apache.apex.malhar.lib.state.managed.Bucket;
import org.apache.apex.malhar.lib.state.managed.ManagedStateComponent;
import org.apache.apex.malhar.lib.state.managed.ManagedStateContext;
import org.apache.hadoop.fs.LocatedFileStatus;
import org.apache.hadoop.fs.RemoteIterator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BucketsFileSystem
implements ManagedStateComponent {
    static final String META_FILE_NAME = "_META";
    private static final int META_FILE_VERSION = 1;
    private final transient TreeBasedTable<Long, Long, MutableTimeBucketMeta> timeBucketsMeta = TreeBasedTable.create();
    protected final Set<Long> bucketNamesOnFS = new ConcurrentSkipListSet<Long>();
    protected transient ManagedStateContext managedStateContext;
    private static final Logger LOG = LoggerFactory.getLogger(BucketsFileSystem.class);

    @Override
    public void setup(@NotNull ManagedStateContext managedStateContext) {
        this.managedStateContext = (ManagedStateContext)Preconditions.checkNotNull((Object)managedStateContext, (Object)"managed state context");
    }

    protected FileAccess.FileWriter getWriter(long bucketId, String fileName) throws IOException {
        return this.managedStateContext.getFileAccess().getWriter(bucketId, fileName);
    }

    protected FileAccess.FileReader getReader(long bucketId, String fileName) throws IOException {
        return this.managedStateContext.getFileAccess().getReader(bucketId, fileName);
    }

    protected void rename(long bucketId, String fromName, String toName) throws IOException {
        this.managedStateContext.getFileAccess().rename(bucketId, fromName, toName);
    }

    protected DataOutputStream getOutputStream(long bucketId, String fileName) throws IOException {
        return this.managedStateContext.getFileAccess().getOutputStream(bucketId, fileName);
    }

    protected DataInputStream getInputStream(long bucketId, String fileName) throws IOException {
        return this.managedStateContext.getFileAccess().getInputStream(bucketId, fileName);
    }

    protected boolean exists(long bucketId, String fileName) throws IOException {
        return this.managedStateContext.getFileAccess().exists(bucketId, fileName);
    }

    protected RemoteIterator<LocatedFileStatus> listFiles(long bucketId) throws IOException {
        return this.managedStateContext.getFileAccess().listFiles(bucketId);
    }

    protected void delete(long bucketId, String fileName) throws IOException {
        this.managedStateContext.getFileAccess().delete(bucketId, fileName);
    }

    protected void deleteBucket(long bucketId) throws IOException {
        this.managedStateContext.getFileAccess().deleteBucket(bucketId);
    }

    protected void writeBucketData(long windowId, long bucketId, Map<Slice, Bucket.BucketedValue> data) throws IOException {
        TreeBasedTable timeBucketedKeys = TreeBasedTable.create((Comparator)Ordering.natural(), this.managedStateContext.getKeyComparator());
        for (Map.Entry<Slice, Bucket.BucketedValue> entry : data.entrySet()) {
            long timeBucketId = entry.getValue().getTimeBucket();
            timeBucketedKeys.put((Object)timeBucketId, (Object)entry.getKey(), (Object)entry.getValue());
        }
        Iterator<Map.Entry<Object, Bucket.BucketedValue>> i$ = timeBucketedKeys.rowKeySet().iterator();
        while (i$.hasNext()) {
            FileAccess.FileWriter fileWriter;
            long timeBucket = (Long)((Object)i$.next());
            MutableTimeBucketMeta tbm = this.getMutableTimeBucketMeta(bucketId, timeBucket);
            if (tbm == null) {
                tbm = new MutableTimeBucketMeta(bucketId, timeBucket);
            }
            this.addBucketName(bucketId);
            long dataSize = 0L;
            Slice firstKey = null;
            String tmpFileName = BucketsFileSystem.getTmpFileName();
            if (tbm.getLastTransferredWindowId() == -1L) {
                fileWriter = this.getWriter(bucketId, tmpFileName);
                for (Map.Entry entry : timeBucketedKeys.row((Object)timeBucket).entrySet()) {
                    Slice key = (Slice)entry.getKey();
                    Slice slice = ((Bucket.BucketedValue)entry.getValue()).getValue();
                    dataSize += (long)key.length;
                    dataSize += (long)slice.length;
                    fileWriter.append(key.toByteArray(), slice.toByteArray());
                    if (firstKey != null) continue;
                    firstKey = key;
                }
            } else {
                TreeMap<Slice, Slice> fileData = new TreeMap<Slice, Slice>(this.managedStateContext.getKeyComparator());
                FileAccess.FileReader fileReader = this.getReader(bucketId, BucketsFileSystem.getFileName(timeBucket));
                fileReader.readFully(fileData);
                fileReader.close();
                for (Map.Entry entry : timeBucketedKeys.row((Object)timeBucket).entrySet()) {
                    fileData.put((Slice)entry.getKey(), ((Bucket.BucketedValue)entry.getValue()).getValue());
                }
                fileWriter = this.getWriter(bucketId, tmpFileName);
                for (Map.Entry<Object, Object> entry : fileData.entrySet()) {
                    Slice key = (Slice)entry.getKey();
                    Slice value = (Slice)entry.getValue();
                    dataSize += (long)key.length;
                    dataSize += (long)value.length;
                    fileWriter.append(key.toByteArray(), value.toByteArray());
                    if (firstKey != null) continue;
                    firstKey = key;
                }
            }
            fileWriter.close();
            this.rename(bucketId, tmpFileName, BucketsFileSystem.getFileName(timeBucket));
            tbm.updateTimeBucketMeta(windowId, dataSize, firstKey);
            this.updateTimeBuckets(tbm);
        }
        this.updateBucketMetaFile(bucketId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    private MutableTimeBucketMeta getMutableTimeBucketMeta(long bucketId, long timeBucketId) throws IOException {
        TreeBasedTable<Long, Long, MutableTimeBucketMeta> treeBasedTable = this.timeBucketsMeta;
        synchronized (treeBasedTable) {
            return this.timeBucketMetaHelper(bucketId, timeBucketId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void updateTimeBuckets(@NotNull MutableTimeBucketMeta mutableTimeBucketMeta) {
        Preconditions.checkNotNull((Object)mutableTimeBucketMeta, (Object)"mutable time bucket meta");
        TreeBasedTable<Long, Long, MutableTimeBucketMeta> treeBasedTable = this.timeBucketsMeta;
        synchronized (treeBasedTable) {
            this.timeBucketsMeta.put((Object)mutableTimeBucketMeta.getBucketId(), (Object)mutableTimeBucketMeta.getTimeBucketId(), (Object)mutableTimeBucketMeta);
        }
    }

    protected void addBucketName(long bucketId) {
        this.bucketNamesOnFS.add(bucketId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public TimeBucketMeta getTimeBucketMeta(long bucketId, long timeBucketId) throws IOException {
        TreeBasedTable<Long, Long, MutableTimeBucketMeta> treeBasedTable = this.timeBucketsMeta;
        synchronized (treeBasedTable) {
            MutableTimeBucketMeta tbm = this.timeBucketMetaHelper(bucketId, timeBucketId);
            if (tbm != null) {
                return tbm.getImmutableTimeBucketMeta();
            }
            return null;
        }
    }

    private MutableTimeBucketMeta timeBucketMetaHelper(long bucketId, long timeBucketId) throws IOException {
        MutableTimeBucketMeta tbm = (MutableTimeBucketMeta)this.timeBucketsMeta.get((Object)bucketId, (Object)timeBucketId);
        if (tbm != null) {
            return tbm;
        }
        if (this.exists(bucketId, META_FILE_NAME)) {
            try (DataInputStream dis = this.getInputStream(bucketId, META_FILE_NAME);){
                this.loadBucketMetaFile(bucketId, dis);
            }
        } else {
            return null;
        }
        return (MutableTimeBucketMeta)this.timeBucketsMeta.get((Object)bucketId, (Object)timeBucketId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public TreeSet<TimeBucketMeta> getAllTimeBuckets(long bucketId) throws IOException {
        TreeBasedTable<Long, Long, MutableTimeBucketMeta> treeBasedTable = this.timeBucketsMeta;
        synchronized (treeBasedTable) {
            TreeSet immutableTimeBucketMetas = Sets.newTreeSet(Collections.reverseOrder());
            if (this.timeBucketsMeta.containsRow((Object)bucketId)) {
                Iterator i$ = this.timeBucketsMeta.row((Object)bucketId).entrySet().iterator();
                while (true) {
                    if (!i$.hasNext()) {
                        return immutableTimeBucketMetas;
                    }
                    Map.Entry entry = i$.next();
                    immutableTimeBucketMetas.add(((MutableTimeBucketMeta)entry.getValue()).getImmutableTimeBucketMeta());
                }
            }
            if (!this.exists(bucketId, META_FILE_NAME)) {
                return immutableTimeBucketMetas;
            }
            try (DataInputStream dis = this.getInputStream(bucketId, META_FILE_NAME);){
                this.loadBucketMetaFile(bucketId, dis);
                for (Map.Entry entry : this.timeBucketsMeta.row((Object)bucketId).entrySet()) {
                    immutableTimeBucketMetas.add(((MutableTimeBucketMeta)entry.getValue()).getImmutableTimeBucketMeta());
                }
                TreeSet treeSet = immutableTimeBucketMetas;
                return treeSet;
            }
        }
    }

    private void loadBucketMetaFile(long bucketId, DataInputStream dis) throws IOException {
        LOG.debug("Loading bucket meta-file {}", (Object)bucketId);
        int metaDataVersion = dis.readInt();
        if (metaDataVersion == 1) {
            int numberOfEntries = dis.readInt();
            for (int i = 0; i < numberOfEntries; ++i) {
                long timeBucketId = dis.readLong();
                long dataSize = dis.readLong();
                long lastTransferredWindow = dis.readLong();
                MutableTimeBucketMeta tbm = new MutableTimeBucketMeta(bucketId, timeBucketId);
                int sizeOfFirstKey = dis.readInt();
                byte[] firstKeyBytes = new byte[sizeOfFirstKey];
                dis.readFully(firstKeyBytes, 0, firstKeyBytes.length);
                tbm.updateTimeBucketMeta(lastTransferredWindow, dataSize, new Slice(firstKeyBytes));
                this.timeBucketsMeta.put((Object)bucketId, (Object)timeBucketId, (Object)tbm);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void updateBucketMetaFile(long bucketId) throws IOException {
        TreeBasedTable<Long, Long, MutableTimeBucketMeta> treeBasedTable = this.timeBucketsMeta;
        synchronized (treeBasedTable) {
            SortedMap timeBuckets = this.timeBucketsMeta.row((Object)bucketId);
            Preconditions.checkNotNull((Object)timeBuckets, (Object)"timeBuckets");
            String tmpFileName = BucketsFileSystem.getTmpFileName();
            try (DataOutputStream dos = this.getOutputStream(bucketId, tmpFileName);){
                dos.writeInt(1);
                dos.writeInt(timeBuckets.size());
                for (Map.Entry entry : timeBuckets.entrySet()) {
                    MutableTimeBucketMeta tbm = (MutableTimeBucketMeta)entry.getValue();
                    dos.writeLong(tbm.getTimeBucketId());
                    dos.writeLong(tbm.getSizeInBytes());
                    dos.writeLong(tbm.getLastTransferredWindowId());
                    dos.writeInt(tbm.getFirstKey().length);
                    dos.write(tbm.getFirstKey().toByteArray());
                }
            }
            this.rename(bucketId, tmpFileName, META_FILE_NAME);
        }
    }

    protected void deleteTimeBucketsLessThanEqualTo(long latestExpiredTimeBucket) throws IOException {
        LOG.debug("delete files before {}", (Object)latestExpiredTimeBucket);
        for (long bucketName : this.bucketNamesOnFS) {
            RemoteIterator<LocatedFileStatus> timeBucketsIterator = this.listFiles(bucketName);
            boolean emptyBucket = true;
            while (timeBucketsIterator.hasNext()) {
                LocatedFileStatus timeBucketStatus = (LocatedFileStatus)timeBucketsIterator.next();
                String timeBucketStr = timeBucketStatus.getPath().getName();
                if (timeBucketStr.equals(META_FILE_NAME) || timeBucketStr.endsWith(".tmp")) continue;
                long timeBucket = Long.parseLong(timeBucketStr);
                if (timeBucket <= latestExpiredTimeBucket) {
                    LOG.debug("deleting bucket {} time-bucket {}", (Object)timeBucket);
                    this.invalidateTimeBucket(bucketName, timeBucket);
                    this.delete(bucketName, timeBucketStatus.getPath().getName());
                    continue;
                }
                emptyBucket = false;
            }
            if (!emptyBucket) continue;
            LOG.debug("deleting bucket {}", (Object)bucketName);
            this.deleteBucket(bucketName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void invalidateTimeBucket(long bucketId, long timeBucketId) throws IOException {
        TreeBasedTable<Long, Long, MutableTimeBucketMeta> treeBasedTable = this.timeBucketsMeta;
        synchronized (treeBasedTable) {
            this.timeBucketsMeta.remove((Object)bucketId, (Object)timeBucketId);
        }
        this.updateBucketMetaFile(bucketId);
    }

    @Override
    public void teardown() {
    }

    protected static String getFileName(long timeBucketId) {
        return Long.toString(timeBucketId);
    }

    protected static String getTmpFileName() {
        return System.currentTimeMillis() + ".tmp";
    }

    static class MutableTimeBucketMeta
    extends TimeBucketMeta {
        private transient TimeBucketMeta immutableTimeBucketMeta;
        private volatile boolean changed;

        public MutableTimeBucketMeta(long bucketId, long timeBucketId) {
            super(bucketId, timeBucketId);
        }

        synchronized void updateTimeBucketMeta(long lastTransferredWindow, long bytes, @NotNull Slice firstKey) {
            this.changed = true;
            ((TimeBucketMeta)this).lastTransferredWindowId = lastTransferredWindow;
            ((TimeBucketMeta)this).sizeInBytes = bytes;
            ((TimeBucketMeta)this).firstKey = (Slice)Preconditions.checkNotNull((Object)firstKey, (Object)"first key");
        }

        synchronized TimeBucketMeta getImmutableTimeBucketMeta() {
            if (this.immutableTimeBucketMeta == null || this.changed) {
                this.immutableTimeBucketMeta = new TimeBucketMeta(this.getBucketId(), this.getTimeBucketId());
                this.immutableTimeBucketMeta.lastTransferredWindowId = this.getLastTransferredWindowId();
                this.immutableTimeBucketMeta.sizeInBytes = this.getSizeInBytes();
                this.immutableTimeBucketMeta.firstKey = this.getFirstKey();
                this.changed = false;
            }
            return this.immutableTimeBucketMeta;
        }
    }

    public static class TimeBucketMeta
    implements Comparable<TimeBucketMeta> {
        private final long bucketId;
        private final long timeBucketId;
        private long lastTransferredWindowId = -1L;
        private long sizeInBytes;
        private Slice firstKey;

        private TimeBucketMeta() {
            this.bucketId = -1L;
            this.timeBucketId = -1L;
        }

        private TimeBucketMeta(long bucketId, long timeBucketId) {
            this.bucketId = bucketId;
            this.timeBucketId = timeBucketId;
        }

        public long getLastTransferredWindowId() {
            return this.lastTransferredWindowId;
        }

        public long getSizeInBytes() {
            return this.sizeInBytes;
        }

        public long getBucketId() {
            return this.bucketId;
        }

        public long getTimeBucketId() {
            return this.timeBucketId;
        }

        public Slice getFirstKey() {
            return this.firstKey;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof TimeBucketMeta)) {
                return false;
            }
            TimeBucketMeta that = (TimeBucketMeta)o;
            return this.bucketId == that.bucketId && this.timeBucketId == that.timeBucketId;
        }

        public int hashCode() {
            return Objects.hash(this.bucketId, this.timeBucketId);
        }

        @Override
        public int compareTo(@NotNull TimeBucketMeta o) {
            if (this.bucketId < o.bucketId) {
                return -1;
            }
            if (this.bucketId > o.bucketId) {
                return 1;
            }
            if (this.timeBucketId < o.timeBucketId) {
                return -1;
            }
            if (this.timeBucketId > o.timeBucketId) {
                return 1;
            }
            return 0;
        }
    }
}

