/*
 * Decompiled with CFR 0.152.
 */
package org.apache.apex.malhar.lib.state.managed;

import com.datatorrent.api.Context;
import com.datatorrent.netlet.util.Slice;
import java.util.concurrent.Future;
import javax.validation.constraints.Min;
import javax.validation.constraints.NotNull;
import org.apache.apex.malhar.lib.state.BucketedState;
import org.apache.apex.malhar.lib.state.managed.AbstractManagedStateImpl;

public class ManagedStateImpl
extends AbstractManagedStateImpl
implements BucketedState {
    private long time = System.currentTimeMillis();
    private transient long timeIncrement;

    public ManagedStateImpl() {
        this.numBuckets = 1;
    }

    @Override
    public void setup(Context.OperatorContext context) {
        super.setup(context);
        this.timeIncrement = (Integer)context.getValue(Context.OperatorContext.APPLICATION_WINDOW_COUNT) * (Integer)context.getValue(Context.DAGContext.STREAMING_WINDOW_SIZE_MILLIS);
    }

    @Override
    public void put(long bucketId, @NotNull Slice key, @NotNull Slice value) {
        long timeBucket = this.timeBucketAssigner.getTimeBucketFor(this.time);
        this.putInBucket(bucketId, timeBucket, key, value);
    }

    @Override
    public Slice getSync(long bucketId, @NotNull Slice key) {
        return this.getValueFromBucketSync(bucketId, -1L, key);
    }

    @Override
    public Future<Slice> getAsync(long bucketId, @NotNull Slice key) {
        return this.getValueFromBucketAsync(bucketId, -1L, key);
    }

    @Override
    public void endWindow() {
        super.endWindow();
        this.time += this.timeIncrement;
    }

    @Override
    @Min(value=1L)
    public int getNumBuckets() {
        return this.numBuckets;
    }

    public void setNumBuckets(int numBuckets) {
        this.numBuckets = numBuckets;
    }
}

