/*
 * Decompiled with CFR 0.152.
 */
package org.apache.apex.malhar.lib.state.managed;

import com.datatorrent.api.annotation.OperatorAnnotation;
import com.datatorrent.netlet.util.Slice;
import com.google.common.util.concurrent.Futures;
import java.util.concurrent.Future;
import javax.validation.constraints.Min;
import javax.validation.constraints.NotNull;
import org.apache.apex.malhar.lib.state.BucketedState;
import org.apache.apex.malhar.lib.state.TimeSlicedBucketedState;
import org.apache.apex.malhar.lib.state.managed.AbstractManagedStateImpl;

@OperatorAnnotation(checkpointableWithinAppWindow=false)
public class ManagedTimeStateImpl
extends AbstractManagedStateImpl
implements TimeSlicedBucketedState {
    public ManagedTimeStateImpl() {
        this.numBuckets = 1;
    }

    @Override
    public void put(long bucketId, long time, @NotNull Slice key, @NotNull Slice value) {
        long timeBucket = this.timeBucketAssigner.getTimeBucketFor(time);
        this.putInBucket(bucketId, timeBucket, key, value);
    }

    @Override
    public Slice getSync(long bucketId, @NotNull Slice key) {
        return this.getValueFromBucketSync(bucketId, -1L, key);
    }

    @Override
    public Slice getSync(long bucketId, long time, @NotNull Slice key) {
        long timeBucket = this.timeBucketAssigner.getTimeBucketFor(time);
        if (timeBucket == -1L) {
            return BucketedState.EXPIRED;
        }
        return this.getValueFromBucketSync(bucketId, timeBucket, key);
    }

    @Override
    public Future<Slice> getAsync(long bucketId, Slice key) {
        return this.getValueFromBucketAsync(bucketId, -1L, key);
    }

    @Override
    public Future<Slice> getAsync(long bucketId, long time, Slice key) {
        long timeBucket = this.timeBucketAssigner.getTimeBucketFor(time);
        if (timeBucket == -1L) {
            return Futures.immediateFuture((Object)BucketedState.EXPIRED);
        }
        return this.getValueFromBucketAsync(bucketId, timeBucket, key);
    }

    @Override
    @Min(value=1L)
    public int getNumBuckets() {
        return this.numBuckets;
    }

    public void setNumBuckets(int numBuckets) {
        this.numBuckets = numBuckets;
    }
}

