/*
 * Decompiled with CFR 0.152.
 */
package org.apache.apex.malhar.lib.state.managed;

import com.google.common.base.Preconditions;
import java.io.IOException;
import java.util.Comparator;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentSkipListSet;
import javax.validation.constraints.NotNull;
import org.apache.apex.malhar.lib.state.managed.AbstractManagedStateImpl;
import org.apache.apex.malhar.lib.state.managed.Bucket;
import org.joda.time.Duration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class StateTracker
extends TimerTask {
    private final transient ConcurrentHashMap<Long, BucketIdTimeWrapper> bucketAccessTimes = new ConcurrentHashMap();
    private transient ConcurrentSkipListSet<BucketIdTimeWrapper> bucketHeap;
    private final transient Timer memoryFreeService = new Timer();
    protected transient AbstractManagedStateImpl managedStateImpl;
    private static final Logger LOG = LoggerFactory.getLogger(StateTracker.class);

    StateTracker() {
    }

    void setup(@NotNull AbstractManagedStateImpl managedStateImpl) {
        this.managedStateImpl = (AbstractManagedStateImpl)Preconditions.checkNotNull((Object)managedStateImpl, (Object)"managed state impl");
        this.bucketHeap = new ConcurrentSkipListSet<BucketIdTimeWrapper>(new Comparator<BucketIdTimeWrapper>(){

            @Override
            public int compare(BucketIdTimeWrapper o1, BucketIdTimeWrapper o2) {
                if (o1.getLastAccessedTime() < o2.getLastAccessedTime()) {
                    return -1;
                }
                if (o1.getLastAccessedTime() > o2.getLastAccessedTime()) {
                    return 1;
                }
                return Long.compare(o1.bucketId, o2.bucketId);
            }
        });
        long intervalMillis = managedStateImpl.getCheckStateSizeInterval().getMillis();
        this.memoryFreeService.scheduleAtFixedRate((TimerTask)this, intervalMillis, intervalMillis);
    }

    void bucketAccessed(long bucketId) {
        BucketIdTimeWrapper idTimeWrapper = this.bucketAccessTimes.get(bucketId);
        if (idTimeWrapper != null) {
            this.bucketHeap.remove(idTimeWrapper);
        } else {
            idTimeWrapper = new BucketIdTimeWrapper(bucketId);
        }
        idTimeWrapper.setLastAccessedTime(System.currentTimeMillis());
        this.bucketHeap.add(idTimeWrapper);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        Object object = this.managedStateImpl.commitLock;
        synchronized (object) {
            long bytesSum = 0L;
            for (Bucket bucket : this.managedStateImpl.buckets) {
                if (bucket == null) continue;
                bytesSum += bucket.getSizeInBytes();
            }
            if (bytesSum > this.managedStateImpl.getMaxMemorySize()) {
                BucketIdTimeWrapper idTimeWrapper;
                Duration duration = this.managedStateImpl.getDurationPreventingFreeingSpace();
                long durationMillis = 0L;
                if (duration != null) {
                    durationMillis = duration.getMillis();
                }
                while (bytesSum > this.managedStateImpl.getMaxMemorySize() && this.bucketHeap.size() > 0 && null != (idTimeWrapper = this.bucketHeap.first()) && System.currentTimeMillis() - idTimeWrapper.getLastAccessedTime() >= durationMillis) {
                    long bucketId = idTimeWrapper.bucketId;
                    Bucket bucket = this.managedStateImpl.getBucket(bucketId);
                    if (bucket == null) continue;
                    Bucket bucket2 = bucket;
                    synchronized (bucket2) {
                        long sizeFreed;
                        try {
                            sizeFreed = bucket.freeMemory(this.managedStateImpl.checkpointManager.getLastTransferredWindow());
                            LOG.debug("bucket freed {} {}", (Object)bucketId, (Object)sizeFreed);
                        }
                        catch (IOException e) {
                            this.managedStateImpl.throwable.set(e);
                            throw new RuntimeException("freeing " + bucketId, e);
                        }
                        bytesSum -= sizeFreed;
                    }
                    this.bucketHeap.remove(idTimeWrapper);
                    this.bucketAccessTimes.remove(bucketId);
                }
            }
        }
    }

    void teardown() {
        this.memoryFreeService.cancel();
    }

    private static class BucketIdTimeWrapper {
        private final long bucketId;
        private long lastAccessedTime;

        BucketIdTimeWrapper(long bucketId) {
            this.bucketId = bucketId;
        }

        private synchronized long getLastAccessedTime() {
            return this.lastAccessedTime;
        }

        private synchronized void setLastAccessedTime(long lastAccessedTime) {
            this.lastAccessedTime = lastAccessedTime;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof BucketIdTimeWrapper)) {
                return false;
            }
            BucketIdTimeWrapper that = (BucketIdTimeWrapper)o;
            return this.bucketId == that.bucketId;
        }

        public int hashCode() {
            return (int)(this.bucketId ^ this.bucketId >>> 32);
        }
    }
}

