/*
 * Decompiled with CFR 0.152.
 */
package org.apache.apex.malhar.lib.state.managed;

import com.datatorrent.api.Context;
import com.datatorrent.lib.appdata.query.WindowBoundedService;
import com.esotericsoftware.kryo.serializers.FieldSerializer;
import com.esotericsoftware.kryo.serializers.JavaSerializer;
import com.google.common.base.Preconditions;
import javax.validation.constraints.NotNull;
import org.apache.apex.malhar.lib.state.managed.ManagedStateComponent;
import org.apache.apex.malhar.lib.state.managed.ManagedStateContext;
import org.joda.time.Duration;
import org.joda.time.Instant;

public class TimeBucketAssigner
implements ManagedStateComponent {
    @NotNull
    private Instant referenceInstant = new Instant();
    @NotNull
    @FieldSerializer.Bind(value=JavaSerializer.class)
    private Duration expireBefore = Duration.standardDays((long)2L);
    @FieldSerializer.Bind(value=JavaSerializer.class)
    private Duration bucketSpan;
    private long bucketSpanMillis;
    private long start;
    private long end;
    private int numBuckets;
    private transient long fixedStart;
    private transient long lowestTimeBucket;
    private boolean initialized;
    private transient WindowBoundedService windowBoundedService;
    private transient PurgeListener purgeListener = null;
    private final transient Runnable expiryTask = new Runnable(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            Object object = TimeBucketAssigner.this.lock;
            synchronized (object) {
                TimeBucketAssigner.this.start += TimeBucketAssigner.this.bucketSpanMillis;
                TimeBucketAssigner.this.end += TimeBucketAssigner.this.bucketSpanMillis;
                if (TimeBucketAssigner.this.purgeListener != null) {
                    TimeBucketAssigner.this.purgeListener.purgeTimeBucketsLessThanEqualTo(TimeBucketAssigner.this.lowestTimeBucket++);
                }
            }
        }
    };
    private final transient Object lock = new Object();

    @Override
    public void setup(@NotNull ManagedStateContext managedStateContext) {
        Context.OperatorContext context = managedStateContext.getOperatorContext();
        this.fixedStart = this.referenceInstant.getMillis() - this.expireBefore.getMillis();
        if (!this.initialized) {
            if (this.bucketSpan == null) {
                this.bucketSpan = Duration.millis((long)((Integer)context.getValue(Context.OperatorContext.APPLICATION_WINDOW_COUNT) * (Integer)context.getValue(Context.DAGContext.STREAMING_WINDOW_SIZE_MILLIS)));
            }
            this.start = this.fixedStart;
            this.bucketSpanMillis = this.bucketSpan.getMillis();
            this.numBuckets = (int)((this.expireBefore.getMillis() + this.bucketSpanMillis - 1L) / this.bucketSpanMillis);
            this.end = this.start + (long)this.numBuckets * this.bucketSpanMillis;
            this.initialized = true;
        }
        this.lowestTimeBucket = (this.start - this.fixedStart) / this.bucketSpanMillis;
        this.windowBoundedService = new WindowBoundedService(this.bucketSpanMillis, this.expiryTask);
        this.windowBoundedService.setup(context);
    }

    public void beginWindow(long windowId) {
        this.windowBoundedService.beginWindow(windowId);
    }

    public void endWindow() {
        this.windowBoundedService.endWindow();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getTimeBucketFor(long value) {
        Object object = this.lock;
        synchronized (object) {
            if (value < this.start) {
                return -1L;
            }
            long diffFromStart = value - this.fixedStart;
            long key = diffFromStart / this.bucketSpanMillis;
            if (value > this.end) {
                long move = ((value - this.end) / this.bucketSpanMillis + 1L) * this.bucketSpanMillis;
                this.start += move;
                this.end += move;
            }
            return key;
        }
    }

    public void setPurgeListener(@NotNull PurgeListener purgeListener) {
        this.purgeListener = (PurgeListener)Preconditions.checkNotNull((Object)purgeListener, (Object)"purge listener");
    }

    @Override
    public void teardown() {
        this.windowBoundedService.teardown();
    }

    public int getNumBuckets() {
        return this.numBuckets;
    }

    public Instant getReferenceInstant() {
        return this.referenceInstant;
    }

    public void setReferenceInstant(Instant referenceInstant) {
        this.referenceInstant = referenceInstant;
    }

    public Duration getExpireBefore() {
        return this.expireBefore;
    }

    public void setExpireBefore(Duration expireBefore) {
        this.expireBefore = expireBefore;
    }

    public Duration getBucketSpan() {
        return this.bucketSpan;
    }

    public void setBucketSpan(Duration bucketSpan) {
        this.bucketSpan = bucketSpan;
    }

    public static interface PurgeListener {
        public void purgeTimeBucketsLessThanEqualTo(long var1);
    }
}

