/*
 * Decompiled with CFR 0.152.
 */
package org.apache.apex.malhar.lib.utils;

import com.google.common.base.Preconditions;
import java.net.URI;
import javax.annotation.Nullable;
import javax.validation.constraints.NotNull;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileContext;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.UnsupportedFileSystemException;

public class FileContextUtils {
    public static FileContext getFileContext(@NotNull Path path) throws UnsupportedFileSystemException {
        return FileContextUtils.getFileContext(path, null);
    }

    public static FileContext getFileContext(@NotNull String path) throws UnsupportedFileSystemException {
        Preconditions.checkNotNull((Object)path, (Object)"path");
        return FileContextUtils.getFileContext(new Path(path), null);
    }

    public static FileContext getFileContext(@NotNull String path, @Nullable Configuration conf) throws UnsupportedFileSystemException {
        Preconditions.checkNotNull((Object)path, (Object)"path");
        return FileContextUtils.getFileContext(new Path(path), conf);
    }

    public static FileContext getFileContext(@NotNull Path path, @Nullable Configuration conf) throws UnsupportedFileSystemException {
        Preconditions.checkNotNull((Object)path, (Object)"path");
        URI pathUri = path.toUri();
        if (pathUri.getScheme() != null) {
            return FileContext.getFileContext((URI)pathUri, (Configuration)(conf == null ? new Configuration() : conf));
        }
        return FileContext.getFileContext((Configuration)(conf == null ? new Configuration() : conf));
    }
}

