/*
 * Decompiled with CFR 0.152.
 */
package org.apache.apex.malhar.lib.utils;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IOUtils {
    private static final int COPY_BUFFER_SIZE = 1024;
    private static final Logger LOGGER = LoggerFactory.getLogger(IOUtils.class);

    public static void copyPartial(InputStream inputStream, long length, OutputStream outputStream) throws IOException {
        IOUtils.copyPartial(inputStream, 0L, length, outputStream);
    }

    public static void copyPartial(InputStream inputStream, long fromOffset, long length, OutputStream outputStream) throws IOException {
        long skippedBytes;
        if (fromOffset > 0L && (skippedBytes = inputStream.skip(fromOffset)) < fromOffset) {
            LOGGER.debug("unable to skip bytes {} {}", (Object)skippedBytes, (Object)fromOffset);
        }
        byte[] buffer = length < 1024L ? new byte[(int)length] : new byte[1024];
        int bytesRead = 0;
        while ((long)bytesRead < length) {
            long remainingBytes = length - (long)bytesRead;
            int bytesToWrite = remainingBytes < 1024L ? (int)remainingBytes : 1024;
            bytesRead += inputStream.read(buffer);
            outputStream.write(buffer, 0, bytesToWrite);
        }
    }
}

