/*
 * Decompiled with CFR 0.152.
 */
package org.apache.apex.malhar.lib.wal;

import com.datatorrent.api.Context;
import com.datatorrent.api.DAG;
import com.datatorrent.common.util.FSStorageAgent;
import com.google.common.base.Preconditions;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.common.collect.TreeMultimap;
import java.io.IOException;
import java.net.URI;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import javax.validation.constraints.NotNull;
import org.apache.apex.malhar.lib.wal.WindowDataManager;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;

public class FSWindowDataManager
implements WindowDataManager {
    private static final String DEF_RECOVERY_PATH = "idempotentState";
    protected transient FSStorageAgent storageAgent;
    @NotNull
    private String recoveryPath = "idempotentState";
    private boolean isRecoveryPathRelativeToAppPath = true;
    protected transient long largestRecoveryWindow = -1L;
    protected Set<Integer> deletedOperators;
    protected final transient TreeMultimap<Long, Integer> replayState = TreeMultimap.create();
    protected transient FileSystem fs;
    protected transient Path appPath;

    public void setup(Context.OperatorContext context) {
        Configuration configuration = new Configuration();
        this.appPath = this.isRecoveryPathRelativeToAppPath ? new Path((String)context.getValue(DAG.APPLICATION_PATH) + "/" + this.recoveryPath) : new Path(this.recoveryPath);
        try {
            this.storageAgent = new FSStorageAgent(this.appPath.toString(), configuration);
            this.fs = FileSystem.newInstance((URI)this.appPath.toUri(), (Configuration)configuration);
            if (this.fs.exists(this.appPath)) {
                FileStatus[] fileStatuses;
                for (FileStatus operatorDirStatus : fileStatuses = this.fs.listStatus(this.appPath)) {
                    int operatorId = Integer.parseInt(operatorDirStatus.getPath().getName());
                    for (FileStatus status : this.fs.listStatus(operatorDirStatus.getPath())) {
                        String fileName = status.getPath().getName();
                        if (fileName.endsWith("_tmp")) continue;
                        long windowId = Long.parseLong(fileName, 16);
                        this.replayState.put((Object)windowId, (Object)operatorId);
                        if (windowId <= this.largestRecoveryWindow) continue;
                        this.largestRecoveryWindow = windowId;
                    }
                }
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public void save(Object object, int operatorId, long windowId) throws IOException {
        this.storageAgent.save(object, operatorId, windowId);
    }

    public Object load(int operatorId, long windowId) throws IOException {
        SortedSet operators = this.replayState.get((Object)windowId);
        if (operators == null || !operators.contains(operatorId)) {
            return null;
        }
        return this.storageAgent.load(operatorId, windowId);
    }

    public void delete(int operatorId, long windowId) throws IOException {
        this.storageAgent.delete(operatorId, windowId);
    }

    @Override
    public Map<Integer, Object> load(long windowId) throws IOException {
        SortedSet operators = this.replayState.get((Object)windowId);
        if (operators == null) {
            return null;
        }
        HashMap data = Maps.newHashMap();
        Iterator i$ = operators.iterator();
        while (i$.hasNext()) {
            int operatorId = (Integer)i$.next();
            data.put(operatorId, this.load(operatorId, windowId));
        }
        return data;
    }

    public long[] getWindowIds(int operatorId) throws IOException {
        Path operatorPath = new Path(this.appPath, String.valueOf(operatorId));
        if (!this.fs.exists(operatorPath) || this.fs.listStatus(operatorPath).length == 0) {
            return null;
        }
        return this.storageAgent.getWindowIds(operatorId);
    }

    @Override
    public long[] getWindowIds() throws IOException {
        SortedSet windowIds = this.replayState.keySet();
        long[] windowIdsArray = new long[windowIds.size()];
        int index = 0;
        for (Long windowId : windowIds) {
            windowIdsArray[index] = windowId;
            ++index;
        }
        return windowIdsArray;
    }

    @Override
    public void deleteUpTo(int operatorId, long windowId) throws IOException {
        if (windowId <= this.largestRecoveryWindow && this.deletedOperators != null && !this.deletedOperators.isEmpty()) {
            Map.Entry windowEntry;
            long lwindow;
            Iterator iterator = this.replayState.asMap().entrySet().iterator();
            while (iterator.hasNext() && (lwindow = ((Long)(windowEntry = iterator.next()).getKey()).longValue()) <= windowId) {
                for (Integer loperator : (Collection)windowEntry.getValue()) {
                    if (this.deletedOperators.contains(loperator)) {
                        this.storageAgent.delete(loperator.intValue(), lwindow);
                        Path loperatorPath = new Path(this.appPath, Integer.toString(loperator));
                        if (this.fs.listStatus(loperatorPath).length != 0) continue;
                        this.deletedOperators.remove(loperator);
                        this.fs.delete(loperatorPath, true);
                        continue;
                    }
                    if (loperator != operatorId) continue;
                    this.storageAgent.delete(loperator.intValue(), lwindow);
                }
                iterator.remove();
            }
        }
        if (this.fs.listStatus(new Path(this.appPath, Integer.toString(operatorId))).length > 0) {
            long[] windowsAfterReplay = this.storageAgent.getWindowIds(operatorId);
            Arrays.sort(windowsAfterReplay);
            for (long lwindow : windowsAfterReplay) {
                if (lwindow > windowId) continue;
                this.storageAgent.delete(operatorId, lwindow);
            }
        }
    }

    @Override
    public long getLargestRecoveryWindow() {
        return this.largestRecoveryWindow;
    }

    @Override
    public void partitioned(Collection<WindowDataManager> newManagers, Set<Integer> removedOperatorIds) {
        Preconditions.checkArgument((newManagers != null && !newManagers.isEmpty() ? 1 : 0) != 0, (Object)"there has to be one idempotent storage manager");
        FSWindowDataManager deletedOperatorsManager = null;
        if (removedOperatorIds != null && !removedOperatorIds.isEmpty()) {
            if (this.deletedOperators == null) {
                this.deletedOperators = Sets.newHashSet();
            }
            this.deletedOperators.addAll(removedOperatorIds);
        }
        for (WindowDataManager storageManager : newManagers) {
            FSWindowDataManager lmanager = (FSWindowDataManager)storageManager;
            lmanager.recoveryPath = this.recoveryPath;
            lmanager.storageAgent = this.storageAgent;
            if (lmanager.deletedOperators != null) {
                deletedOperatorsManager = lmanager;
            }
            if (lmanager == deletedOperatorsManager) continue;
            lmanager.deletedOperators = null;
        }
        if (removedOperatorIds == null || removedOperatorIds.isEmpty()) {
            return;
        }
        if (this.deletedOperators != null) {
            if (deletedOperatorsManager == null) {
                deletedOperatorsManager = (FSWindowDataManager)newManagers.iterator().next();
                deletedOperatorsManager.deletedOperators = Sets.newHashSet();
            }
            deletedOperatorsManager.deletedOperators.addAll(removedOperatorIds);
        }
    }

    public void teardown() {
        try {
            this.fs.close();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public String getRecoveryPath() {
        return this.recoveryPath;
    }

    public void setRecoveryPath(String recoveryPath) {
        this.recoveryPath = recoveryPath;
    }

    public boolean isRecoveryPathRelativeToAppPath() {
        return this.isRecoveryPathRelativeToAppPath;
    }

    public void setRecoveryPathRelativeToAppPath(boolean recoveryPathRelativeToAppPath) {
        this.isRecoveryPathRelativeToAppPath = recoveryPathRelativeToAppPath;
    }
}

