/*
 * Decompiled with CFR 0.152.
 */
package org.apache.apex.malhar.lib.wal;

import com.datatorrent.api.Component;
import com.datatorrent.api.Context;
import com.datatorrent.api.StorageAgent;
import java.io.IOException;
import java.util.Collection;
import java.util.Map;
import java.util.Set;

public interface WindowDataManager
extends StorageAgent,
Component<Context.OperatorContext> {
    public long getLargestRecoveryWindow();

    public Map<Integer, Object> load(long var1) throws IOException;

    public void deleteUpTo(int var1, long var2) throws IOException;

    public void partitioned(Collection<WindowDataManager> var1, Set<Integer> var2);

    public long[] getWindowIds() throws IOException;

    public static class NoopWindowDataManager
    implements WindowDataManager {
        @Override
        public long getLargestRecoveryWindow() {
            return -1L;
        }

        @Override
        public Map<Integer, Object> load(long windowId) throws IOException {
            return null;
        }

        @Override
        public void partitioned(Collection<WindowDataManager> newManagers, Set<Integer> removedOperatorIds) {
        }

        public void setup(Context.OperatorContext context) {
        }

        public void teardown() {
        }

        public void save(Object object, int operatorId, long windowId) throws IOException {
        }

        public Object load(int operatorId, long windowId) throws IOException {
            return null;
        }

        public void delete(int operatorId, long windowId) throws IOException {
        }

        @Override
        public void deleteUpTo(int operatorId, long windowId) throws IOException {
        }

        public long[] getWindowIds(int operatorId) throws IOException {
            return new long[0];
        }

        @Override
        public long[] getWindowIds() throws IOException {
            return new long[0];
        }
    }
}

