/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.io.file.tfile;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.Weigher;
import java.lang.management.ManagementFactory;
import java.util.Collection;
import org.apache.hadoop.io.file.tfile.DTBCFile;

public class CacheManager {
    public static final int STRING_OVERHEAD = 64;
    public static final int BLOCK_READER_OVERHEAD = 368;
    public static final float DEFAULT_HEAP_MEMORY_PERCENTAGE = 0.25f;
    private static Cache<String, DTBCFile.Reader.BlockReader> singleCache;
    private static boolean enableStats;

    public static final Cache<String, DTBCFile.Reader.BlockReader> buildCache(CacheBuilder builder) {
        if (singleCache != null) {
            singleCache.cleanUp();
        }
        if (enableStats) {
            // empty if block
        }
        singleCache = builder.build();
        return singleCache;
    }

    public static final Cache<String, DTBCFile.Reader.BlockReader> createCache(int concurrencyLevel, int initialCapacity, int maximunSize) {
        CacheBuilder builder = CacheBuilder.newBuilder().concurrencyLevel(concurrencyLevel).initialCapacity(initialCapacity).maximumSize((long)maximunSize);
        return CacheManager.buildCache(builder);
    }

    public static final Cache<String, DTBCFile.Reader.BlockReader> createCache(int concurrencyLevel, int initialCapacity, long maximumMemory) {
        CacheBuilder builder = CacheBuilder.newBuilder().concurrencyLevel(concurrencyLevel).initialCapacity(initialCapacity).maximumWeight(maximumMemory).weigher((Weigher)new KVWeigher());
        return CacheManager.buildCache(builder);
    }

    public static final Cache<String, DTBCFile.Reader.BlockReader> createCache(int concurrencyLevel, int initialCapacity, float heapMemPercentage) {
        CacheBuilder builder = CacheBuilder.newBuilder().concurrencyLevel(concurrencyLevel).initialCapacity(initialCapacity).maximumWeight((long)((float)ManagementFactory.getMemoryMXBean().getHeapMemoryUsage().getMax() * heapMemPercentage)).weigher((Weigher)new KVWeigher());
        return CacheManager.buildCache(builder);
    }

    public static final void createDefaultCache() {
        long availableMemory = (long)((float)ManagementFactory.getMemoryMXBean().getHeapMemoryUsage().getMax() * 0.25f);
        CacheBuilder builder = CacheBuilder.newBuilder().maximumWeight(availableMemory).weigher((Weigher)new KVWeigher());
        singleCache = CacheManager.buildCache(builder);
    }

    public static final void put(String key, DTBCFile.Reader.BlockReader blk) {
        if (singleCache == null) {
            CacheManager.createDefaultCache();
        }
        singleCache.put((Object)key, (Object)blk);
    }

    public static final DTBCFile.Reader.BlockReader get(String key) {
        if (singleCache == null) {
            return null;
        }
        return (DTBCFile.Reader.BlockReader)singleCache.getIfPresent((Object)key);
    }

    public static final void invalidateKeys(Collection<String> keys) {
        if (singleCache != null) {
            singleCache.invalidateAll(keys);
        }
    }

    public static final long getCacheSize() {
        if (singleCache != null) {
            return singleCache.size();
        }
        return 0L;
    }

    @VisibleForTesting
    protected static Cache<String, DTBCFile.Reader.BlockReader> getCache() {
        return singleCache;
    }

    public static final void setEnableStats(boolean enable) {
        enableStats = enable;
    }

    public static void main(String[] args) {
    }

    static {
        enableStats = false;
    }

    public static final class KVWeigher
    implements Weigher<String, DTBCFile.Reader.BlockReader> {
        public int weigh(String key, DTBCFile.Reader.BlockReader value) {
            return 432 + key.getBytes().length + value.getBlockDataInputStream().getBuf().length;
        }
    }
}

