/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.io.file.tfile;

import java.io.ByteArrayInputStream;

public class ReusableByteArrayInputStream
extends ByteArrayInputStream {
    private final int initialOffset;
    private final int initialLength;

    public ReusableByteArrayInputStream(byte[] buf, int offset, int length) {
        super(buf, offset, length);
        this.initialLength = Math.min(offset + length, buf.length);
        this.initialOffset = offset;
    }

    public ReusableByteArrayInputStream(byte[] buf) {
        super(buf);
        this.initialLength = buf.length;
        this.initialOffset = 0;
    }

    public void renew() {
        this.pos = this.initialOffset;
        this.count = this.initialLength;
        this.mark = 0;
    }

    public int getPos() {
        return this.pos;
    }

    public byte[] getBuf() {
        return this.buf;
    }
}

