/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.archiva.scheduled;

import java.text.ParseException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.maven.archiva.common.ArchivaException;
import org.apache.maven.archiva.configuration.ArchivaConfiguration;
import org.apache.maven.archiva.configuration.ConfigurationEvent;
import org.apache.maven.archiva.configuration.ConfigurationListener;
import org.apache.maven.archiva.configuration.ManagedRepositoryConfiguration;
import org.apache.maven.archiva.database.ArchivaDAO;
import org.apache.maven.archiva.database.SimpleConstraint;
import org.apache.maven.archiva.database.constraints.MostRecentRepositoryScanStatistics;
import org.apache.maven.archiva.scheduled.ArchivaTaskScheduler;
import org.apache.maven.archiva.scheduled.DatabaseTaskJob;
import org.apache.maven.archiva.scheduled.RepositoryTaskJob;
import org.apache.maven.archiva.scheduled.tasks.ArtifactIndexingTask;
import org.apache.maven.archiva.scheduled.tasks.DatabaseTask;
import org.apache.maven.archiva.scheduled.tasks.RepositoryTask;
import org.apache.maven.archiva.scheduled.tasks.TaskCreator;
import org.codehaus.plexus.personality.plexus.lifecycle.phase.Startable;
import org.codehaus.plexus.personality.plexus.lifecycle.phase.StartingException;
import org.codehaus.plexus.personality.plexus.lifecycle.phase.StoppingException;
import org.codehaus.plexus.scheduler.CronExpressionValidator;
import org.codehaus.plexus.scheduler.Scheduler;
import org.codehaus.plexus.taskqueue.Task;
import org.codehaus.plexus.taskqueue.TaskQueue;
import org.codehaus.plexus.taskqueue.TaskQueueException;
import org.codehaus.plexus.taskqueue.execution.TaskExecutionException;
import org.quartz.CronTrigger;
import org.quartz.JobDataMap;
import org.quartz.JobDetail;
import org.quartz.SchedulerException;
import org.quartz.Trigger;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultArchivaTaskScheduler
implements ArchivaTaskScheduler,
Startable,
ConfigurationListener {
    private Logger log = LoggerFactory.getLogger(DefaultArchivaTaskScheduler.class);
    private Scheduler scheduler;
    private TaskQueue databaseUpdateQueue;
    private TaskQueue repositoryScanningQueue;
    private TaskQueue indexingQueue;
    private ArchivaConfiguration archivaConfiguration;
    private ArchivaDAO dao;
    private static final String DATABASE_SCAN_GROUP = "dbg";
    private static final String DATABASE_JOB = "dbj";
    private static final String DATABASE_JOB_TRIGGER = "dbt";
    private static final String REPOSITORY_SCAN_GROUP = "rg";
    private static final String REPOSITORY_JOB = "rj";
    private static final String REPOSITORY_JOB_TRIGGER = "rjt";
    static final String TASK_QUEUE = "TASK_QUEUE";
    static final String TASK_REPOSITORY = "TASK_REPOSITORY";
    public static final String CRON_HOURLY = "0 0 * * * ?";
    private Set<String> jobs = new HashSet<String>();
    private List<String> queuedRepos = new ArrayList<String>();

    public void startup() throws ArchivaException {
        this.archivaConfiguration.addListener((ConfigurationListener)this);
        try {
            this.start();
        }
        catch (StartingException e) {
            throw new ArchivaException(e.getMessage(), (Throwable)e);
        }
    }

    public void start() throws StartingException {
        try {
            List repositories = this.archivaConfiguration.getConfiguration().getManagedRepositories();
            for (ManagedRepositoryConfiguration repoConfig : repositories) {
                if (!repoConfig.isScanned()) continue;
                this.scheduleRepositoryJobs(repoConfig);
                if (this.isPreviouslyScanned(repoConfig)) continue;
                this.queueInitialRepoScan(repoConfig);
            }
            this.scheduleDatabaseJobs();
        }
        catch (SchedulerException e) {
            throw new StartingException("Unable to start scheduler: " + e.getMessage(), (Throwable)e);
        }
    }

    public void stop() throws StoppingException {
        try {
            this.scheduler.unscheduleJob(DATABASE_JOB, DATABASE_SCAN_GROUP);
            for (String job : this.jobs) {
                this.scheduler.unscheduleJob(job, REPOSITORY_SCAN_GROUP);
            }
            this.jobs.clear();
            this.queuedRepos.clear();
        }
        catch (SchedulerException e) {
            throw new StoppingException("Unable to unschedule tasks", (Throwable)e);
        }
    }

    public void scheduleDatabaseTasks() throws TaskExecutionException {
        try {
            this.scheduleDatabaseJobs();
        }
        catch (SchedulerException e) {
            throw new TaskExecutionException("Unable to schedule repository jobs: " + e.getMessage(), (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isProcessingRepositoryTask(String repositoryId) {
        TaskQueue taskQueue = this.repositoryScanningQueue;
        synchronized (taskQueue) {
            List queue = null;
            try {
                queue = this.repositoryScanningQueue.getQueueSnapshot();
            }
            catch (TaskQueueException e) {
                // empty catch block
            }
            for (RepositoryTask queuedTask : queue) {
                if (!queuedTask.getRepositoryId().equals(repositoryId)) continue;
                return true;
            }
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isProcessingRepositoryTask(RepositoryTask task) {
        TaskQueue taskQueue = this.repositoryScanningQueue;
        synchronized (taskQueue) {
            List queue = null;
            try {
                queue = this.repositoryScanningQueue.getQueueSnapshot();
            }
            catch (TaskQueueException e) {
                // empty catch block
            }
            for (RepositoryTask queuedTask : queue) {
                if (!task.equals(queuedTask)) continue;
                return true;
            }
            return false;
        }
    }

    public boolean isProcessingDatabaseTask() {
        List queue = null;
        try {
            queue = this.databaseUpdateQueue.getQueueSnapshot();
        }
        catch (TaskQueueException taskQueueException) {
            // empty catch block
        }
        return !queue.isEmpty();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void queueRepositoryTask(RepositoryTask task) throws TaskQueueException {
        TaskQueue taskQueue = this.repositoryScanningQueue;
        synchronized (taskQueue) {
            if (this.isProcessingRepositoryTask(task)) {
                this.log.debug("Repository task '" + task + "' is already queued. Skipping task.");
            } else {
                this.repositoryScanningQueue.put((Task)task);
            }
        }
    }

    public void queueDatabaseTask(DatabaseTask task) throws TaskQueueException {
        this.databaseUpdateQueue.put((Task)task);
    }

    public void queueIndexingTask(ArtifactIndexingTask task) throws TaskQueueException {
        this.indexingQueue.put((Task)task);
    }

    public void configurationEvent(ConfigurationEvent event) {
        if (event.getType() == 1) {
            try {
                this.scheduler.unscheduleJob(DATABASE_JOB, DATABASE_SCAN_GROUP);
                this.scheduleDatabaseJobs();
            }
            catch (SchedulerException e) {
                this.log.error("Error restarting the database scanning job after property change.");
            }
            for (String job : this.jobs) {
                try {
                    this.scheduler.unscheduleJob(job, REPOSITORY_SCAN_GROUP);
                }
                catch (SchedulerException e) {
                    this.log.error("Error restarting the repository scanning job after property change.");
                }
            }
            this.jobs.clear();
            List repositories = this.archivaConfiguration.getConfiguration().getManagedRepositories();
            for (ManagedRepositoryConfiguration repoConfig : repositories) {
                if (repoConfig.getRefreshCronExpression() == null) continue;
                try {
                    this.scheduleRepositoryJobs(repoConfig);
                }
                catch (SchedulerException e) {
                    this.log.error("error restarting job: rj:" + repoConfig.getId());
                }
            }
        }
    }

    private boolean isPreviouslyScanned(ManagedRepositoryConfiguration repoConfig) {
        List results = this.dao.query((SimpleConstraint)new MostRecentRepositoryScanStatistics(repoConfig.getId()));
        return results != null && !results.isEmpty();
    }

    private synchronized void queueInitialRepoScan(ManagedRepositoryConfiguration repoConfig) {
        String repoId = repoConfig.getId();
        RepositoryTask task = TaskCreator.createRepositoryTask(repoId);
        if (!this.queuedRepos.contains(repoId)) {
            this.log.info("Repository [" + repoId + "] is queued to be scanned as it hasn't been previously.");
            try {
                this.queuedRepos.add(repoConfig.getId());
                this.queueRepositoryTask(task);
            }
            catch (TaskQueueException e) {
                this.log.error("Error occurred while queueing repository [" + repoId + "] task : " + e.getMessage());
            }
        }
    }

    private synchronized void scheduleRepositoryJobs(ManagedRepositoryConfiguration repoConfig) throws SchedulerException {
        if (repoConfig.getRefreshCronExpression() == null) {
            this.log.warn("Skipping job, no cron expression for " + repoConfig.getId());
            return;
        }
        if (!repoConfig.isScanned()) {
            this.log.warn("Skipping job, repository scannable has been disabled for " + repoConfig.getId());
            return;
        }
        CronExpressionValidator cronValidator = new CronExpressionValidator();
        String cronString = repoConfig.getRefreshCronExpression();
        if (!cronValidator.validate(cronString)) {
            this.log.warn("Cron expression [" + cronString + "] for repository [" + repoConfig.getId() + "] is invalid.  Defaulting to hourly.");
            cronString = CRON_HOURLY;
        }
        JobDetail repositoryJob = new JobDetail("rj:" + repoConfig.getId(), REPOSITORY_SCAN_GROUP, RepositoryTaskJob.class);
        JobDataMap dataMap = new JobDataMap();
        dataMap.put((Object)TASK_QUEUE, (Object)this.repositoryScanningQueue);
        dataMap.put(TASK_REPOSITORY, repoConfig.getId());
        repositoryJob.setJobDataMap(dataMap);
        try {
            CronTrigger trigger = new CronTrigger("rjt:" + repoConfig.getId(), REPOSITORY_SCAN_GROUP, cronString);
            this.jobs.add("rj:" + repoConfig.getId());
            this.scheduler.scheduleJob(repositoryJob, (Trigger)trigger);
        }
        catch (ParseException e) {
            this.log.error("ParseException in repository scanning cron expression, disabling repository scanning for '" + repoConfig.getId() + "': " + e.getMessage());
        }
    }

    private synchronized void scheduleDatabaseJobs() throws SchedulerException {
        String cronString = this.archivaConfiguration.getConfiguration().getDatabaseScanning().getCronExpression();
        JobDetail databaseJob = new JobDetail(DATABASE_JOB, DATABASE_SCAN_GROUP, DatabaseTaskJob.class);
        JobDataMap dataMap = new JobDataMap();
        dataMap.put((Object)TASK_QUEUE, (Object)this.databaseUpdateQueue);
        databaseJob.setJobDataMap(dataMap);
        CronExpressionValidator cronValidator = new CronExpressionValidator();
        if (!cronValidator.validate(cronString)) {
            this.log.warn("Cron expression [" + cronString + "] for database update is invalid.  Defaulting to hourly.");
            cronString = CRON_HOURLY;
        }
        try {
            CronTrigger trigger = new CronTrigger(DATABASE_JOB_TRIGGER, DATABASE_SCAN_GROUP, cronString);
            this.scheduler.scheduleJob(databaseJob, (Trigger)trigger);
        }
        catch (ParseException e) {
            this.log.error("ParseException in database scanning cron expression, disabling database scanning: " + e.getMessage());
        }
    }
}

