/*
 * Decompiled with CFR 0.152.
 */
package org.apache.archiva.metadata.model.facets;

import java.util.HashMap;
import java.util.Map;
import org.apache.archiva.metadata.model.MetadataFacet;

public class RepositoryProblemFacet
implements MetadataFacet {
    public static final String FACET_ID = "org.apache.archiva.reports";
    private String repositoryId;
    private String namespace;
    private String project;
    private String version;
    private String id;
    private String message;
    private String problem;

    @Override
    public String getFacetId() {
        return FACET_ID;
    }

    @Override
    public String getName() {
        return RepositoryProblemFacet.createName(this.namespace, this.project, this.version, this.id);
    }

    @Override
    public Map<String, String> toProperties() {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("repositoryId", this.repositoryId);
        map.put("namespace", this.namespace);
        map.put("project", this.project);
        map.put("version", this.version);
        if (this.id != null) {
            map.put("id", this.id);
        }
        map.put("message", this.message);
        map.put("problem", this.problem);
        return map;
    }

    @Override
    public void fromProperties(Map<String, String> properties) {
        this.repositoryId = properties.get("repositoryId");
        this.namespace = properties.get("namespace");
        this.project = properties.get("project");
        this.version = properties.get("version");
        this.id = properties.get("id");
        this.message = properties.get("message");
        this.problem = properties.get("problem");
    }

    public void setRepositoryId(String repositoryId) {
        this.repositoryId = repositoryId;
    }

    public void setNamespace(String namespace) {
        this.namespace = namespace;
    }

    public String getRepositoryId() {
        return this.repositoryId;
    }

    public String getNamespace() {
        return this.namespace;
    }

    public void setProject(String project) {
        this.project = project;
    }

    public String getProject() {
        return this.project;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public String getVersion() {
        return this.version;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getId() {
        return this.id;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public String getMessage() {
        return this.message;
    }

    public void setProblem(String problem) {
        this.problem = problem;
    }

    public String getProblem() {
        return this.problem;
    }

    public static String createName(String namespace, String project, String projectVersion, String id) {
        String name = namespace + "/" + project + "/" + projectVersion;
        if (id != null) {
            name = name + "/" + id;
        }
        return name;
    }
}

