/*
 * Decompiled with CFR 0.152.
 */
package org.apache.archiva.metadata.repository;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Named;
import org.apache.archiva.metadata.model.ArtifactMetadata;
import org.apache.archiva.metadata.model.ProjectMetadata;
import org.apache.archiva.metadata.model.ProjectVersionMetadata;
import org.apache.archiva.metadata.model.ProjectVersionReference;
import org.apache.archiva.metadata.repository.MetadataRepository;
import org.apache.archiva.metadata.repository.MetadataRepositoryException;
import org.apache.archiva.metadata.repository.MetadataResolutionException;
import org.apache.archiva.metadata.repository.MetadataResolver;
import org.apache.archiva.metadata.repository.RepositorySession;
import org.apache.archiva.metadata.repository.filter.ExcludesFilter;
import org.apache.archiva.metadata.repository.storage.ReadMetadataRequest;
import org.apache.archiva.metadata.repository.storage.RepositoryStorage;
import org.apache.archiva.metadata.repository.storage.RepositoryStorageMetadataInvalidException;
import org.apache.archiva.metadata.repository.storage.RepositoryStorageMetadataNotFoundException;
import org.apache.archiva.metadata.repository.storage.RepositoryStorageRuntimeException;
import org.apache.archiva.redback.components.cache.Cache;
import org.apache.archiva.repository.events.RepositoryListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="metadataResolver#default")
public class DefaultMetadataResolver
implements MetadataResolver {
    private Logger log = LoggerFactory.getLogger(DefaultMetadataResolver.class);
    @Inject
    @Named(value="repositoryStorage#maven2")
    private RepositoryStorage repositoryStorage;
    @Inject
    @Autowired(required=false)
    private List<RepositoryListener> listeners = new ArrayList<RepositoryListener>();
    @Inject
    @Named(value="cache#namespaces")
    private Cache<String, Collection<String>> namespacesCache;

    @Override
    public ProjectVersionMetadata resolveProjectVersion(RepositorySession session, String repoId, String namespace, String projectId, String projectVersion) throws MetadataResolutionException {
        MetadataRepository metadataRepository = session.getRepository();
        ProjectVersionMetadata metadata = metadataRepository.getProjectVersion(repoId, namespace, projectId, projectVersion);
        if (metadata == null || metadata.isIncomplete()) {
            try {
                ReadMetadataRequest readMetadataRequest = new ReadMetadataRequest().repositoryId(repoId).namespace(namespace).projectId(projectId).projectVersion(projectVersion).browsingRequest(true);
                metadata = this.repositoryStorage.readProjectVersionMetadata(readMetadataRequest);
                this.log.debug("Resolved project version metadata from storage: {}", (Object)metadata);
                if (!metadata.getDependencies().isEmpty()) {
                    ProjectVersionReference ref = new ProjectVersionReference();
                    ref.setNamespace(namespace);
                    ref.setProjectId(projectId);
                    ref.setProjectVersion(projectVersion);
                    ref.setReferenceType(ProjectVersionReference.ReferenceType.DEPENDENCY);
                }
                try {
                    for (RepositoryListener listener : this.listeners) {
                        listener.addArtifact(session, repoId, namespace, projectId, metadata);
                    }
                    metadataRepository.updateProjectVersion(repoId, namespace, projectId, metadata);
                }
                catch (MetadataRepositoryException e) {
                    this.log.warn("Unable to persist resolved information: {}", (Object)e.getMessage(), (Object)e);
                }
                session.markDirty();
            }
            catch (RepositoryStorageMetadataInvalidException e) {
                for (RepositoryListener listener : this.listeners) {
                    listener.addArtifactProblem(session, repoId, namespace, projectId, projectVersion, e);
                }
                throw new MetadataResolutionException(e.getMessage(), e);
            }
            catch (RepositoryStorageMetadataNotFoundException e) {
                for (RepositoryListener listener : this.listeners) {
                    listener.addArtifactProblem(session, repoId, namespace, projectId, projectVersion, e);
                }
            }
            catch (RepositoryStorageRuntimeException e) {
                for (RepositoryListener listener : this.listeners) {
                    listener.addArtifactProblem(session, repoId, namespace, projectId, projectVersion, e);
                }
                throw new MetadataResolutionException(e.getMessage(), e);
            }
        }
        return metadata;
    }

    @Override
    public Collection<ProjectVersionReference> resolveProjectReferences(RepositorySession session, String repoId, String namespace, String projectId, String projectVersion) throws MetadataResolutionException {
        MetadataRepository metadataRepository = session.getRepository();
        return metadataRepository.getProjectReferences(repoId, namespace, projectId, projectVersion);
    }

    @Override
    public Collection<String> resolveRootNamespaces(RepositorySession session, String repoId) throws MetadataResolutionException {
        try {
            Collection<String> namespaces = (Collection<String>)this.namespacesCache.get((Object)repoId);
            if (namespaces != null) {
                return namespaces;
            }
            MetadataRepository metadataRepository = session.getRepository();
            namespaces = metadataRepository.getRootNamespaces(repoId);
            Collection<String> storageNamespaces = this.repositoryStorage.listRootNamespaces(repoId, new ExcludesFilter<String>(namespaces));
            if (storageNamespaces != null && !storageNamespaces.isEmpty()) {
                this.log.debug("Resolved root namespaces from storage: {}", storageNamespaces);
                for (String n : storageNamespaces) {
                    try {
                        metadataRepository.updateNamespace(repoId, n);
                        String cacheKey = repoId + "-" + n;
                        this.namespacesCache.remove((Object)cacheKey);
                    }
                    catch (MetadataRepositoryException e) {
                        this.log.warn("Unable to persist resolved information: {}", (Object)e.getMessage(), (Object)e);
                    }
                }
                session.markDirty();
                namespaces = new ArrayList<String>(namespaces);
                namespaces.addAll(storageNamespaces);
            }
            this.namespacesCache.put((Object)repoId, namespaces);
            return namespaces;
        }
        catch (RepositoryStorageRuntimeException e) {
            throw new MetadataResolutionException(e.getMessage(), e);
        }
    }

    @Override
    public Collection<String> resolveNamespaces(RepositorySession session, String repoId, String namespace) throws MetadataResolutionException {
        try {
            MetadataRepository metadataRepository = session.getRepository();
            String cacheKey = repoId + "-" + namespace;
            Collection<String> namespaces = (Collection<String>)this.namespacesCache.get((Object)cacheKey);
            if (namespaces == null) {
                namespaces = metadataRepository.getNamespaces(repoId, namespace);
                this.namespacesCache.put((Object)cacheKey, namespaces);
            }
            ArrayList<String> exclusions = new ArrayList<String>(namespaces);
            exclusions.addAll(metadataRepository.getProjects(repoId, namespace));
            Collection<String> storageNamespaces = this.repositoryStorage.listNamespaces(repoId, namespace, new ExcludesFilter<String>(exclusions));
            if (storageNamespaces != null && !storageNamespaces.isEmpty()) {
                this.log.debug("Resolved namespaces from storage: {}", storageNamespaces);
                for (String n : storageNamespaces) {
                    try {
                        metadataRepository.updateNamespace(repoId, namespace + "." + n);
                        cacheKey = repoId + "-" + namespace + "." + n;
                        this.namespacesCache.remove((Object)cacheKey);
                    }
                    catch (MetadataRepositoryException e) {
                        this.log.warn("Unable to persist resolved information: {}", (Object)e.getMessage(), (Object)e);
                    }
                }
                session.markDirty();
                namespaces = new ArrayList<String>(namespaces);
                namespaces.addAll(storageNamespaces);
            }
            return namespaces;
        }
        catch (RepositoryStorageRuntimeException e) {
            throw new MetadataResolutionException(e.getMessage(), e);
        }
    }

    @Override
    public Collection<String> resolveProjects(RepositorySession session, String repoId, String namespace) throws MetadataResolutionException {
        try {
            MetadataRepository metadataRepository = session.getRepository();
            Collection<String> projects = metadataRepository.getProjects(repoId, namespace);
            ArrayList<String> exclusions = new ArrayList<String>(projects);
            String cacheKey = repoId + "-" + namespace;
            Collection<String> namespaces = (Collection<String>)this.namespacesCache.get((Object)cacheKey);
            if (namespaces == null) {
                namespaces = metadataRepository.getNamespaces(repoId, namespace);
                this.namespacesCache.put((Object)cacheKey, namespaces);
            }
            exclusions.addAll(namespaces);
            Collection<String> storageProjects = this.repositoryStorage.listProjects(repoId, namespace, new ExcludesFilter<String>(exclusions));
            if (storageProjects != null && !storageProjects.isEmpty()) {
                this.log.debug("Resolved projects from storage: {}", storageProjects);
                for (String projectId : storageProjects) {
                    ProjectMetadata projectMetadata = this.repositoryStorage.readProjectMetadata(repoId, namespace, projectId);
                    if (projectMetadata == null) continue;
                    try {
                        metadataRepository.updateProject(repoId, projectMetadata);
                    }
                    catch (MetadataRepositoryException e) {
                        this.log.warn("Unable to persist resolved information: {}", (Object)e.getMessage(), (Object)e);
                    }
                }
                session.markDirty();
                projects = new ArrayList<String>(projects);
                projects.addAll(storageProjects);
            }
            return projects;
        }
        catch (RepositoryStorageRuntimeException e) {
            throw new MetadataResolutionException(e.getMessage(), e);
        }
    }

    @Override
    public Collection<String> resolveProjectVersions(RepositorySession session, String repoId, String namespace, String projectId) throws MetadataResolutionException {
        try {
            MetadataRepository metadataRepository = session.getRepository();
            Collection<String> projectVersions = metadataRepository.getProjectVersions(repoId, namespace, projectId);
            Collection<String> storageProjectVersions = this.repositoryStorage.listProjectVersions(repoId, namespace, projectId, new ExcludesFilter<String>(projectVersions));
            if (storageProjectVersions != null && !storageProjectVersions.isEmpty()) {
                this.log.debug("Resolved project versions from storage: {}", storageProjectVersions);
                for (String projectVersion : storageProjectVersions) {
                    try {
                        ReadMetadataRequest readMetadataRequest = new ReadMetadataRequest().repositoryId(repoId).namespace(namespace).projectId(projectId).projectVersion(projectVersion);
                        ProjectVersionMetadata versionMetadata = this.repositoryStorage.readProjectVersionMetadata(readMetadataRequest);
                        for (RepositoryListener listener : this.listeners) {
                            listener.addArtifact(session, repoId, namespace, projectId, versionMetadata);
                        }
                        metadataRepository.updateProjectVersion(repoId, namespace, projectId, versionMetadata);
                    }
                    catch (MetadataRepositoryException e) {
                        this.log.warn("Unable to persist resolved information: {}", (Object)e.getMessage(), (Object)e);
                    }
                    catch (RepositoryStorageMetadataInvalidException e) {
                        this.log.warn("Not update project in metadata repository due to an error resolving it from storage: {}", (Object)e.getMessage());
                        for (RepositoryListener listener : this.listeners) {
                            listener.addArtifactProblem(session, repoId, namespace, projectId, projectVersion, e);
                        }
                    }
                    catch (RepositoryStorageMetadataNotFoundException e) {
                        for (RepositoryListener listener : this.listeners) {
                            listener.addArtifactProblem(session, repoId, namespace, projectId, projectVersion, e);
                        }
                    }
                }
                session.markDirty();
                projectVersions = new ArrayList<String>(projectVersions);
                projectVersions.addAll(storageProjectVersions);
            }
            return projectVersions;
        }
        catch (RepositoryStorageRuntimeException e) {
            throw new MetadataResolutionException(e.getMessage(), e);
        }
    }

    @Override
    public Collection<ArtifactMetadata> resolveArtifacts(RepositorySession session, String repoId, String namespace, String projectId, String projectVersion) throws MetadataResolutionException {
        try {
            MetadataRepository metadataRepository = session.getRepository();
            Collection<ArtifactMetadata> artifacts = metadataRepository.getArtifacts(repoId, namespace, projectId, projectVersion);
            ExcludesFilter<String> filter = new ExcludesFilter<String>(this.createArtifactIdList(artifacts));
            ReadMetadataRequest readMetadataRequest = new ReadMetadataRequest().repositoryId(repoId).namespace(namespace).projectId(projectId).projectVersion(projectVersion).filter(filter);
            Collection<ArtifactMetadata> storageArtifacts = this.repositoryStorage.readArtifactsMetadata(readMetadataRequest);
            if (storageArtifacts != null && !storageArtifacts.isEmpty()) {
                this.log.debug("Resolved artifacts from storage: {}", storageArtifacts);
                for (ArtifactMetadata artifact : storageArtifacts) {
                    try {
                        metadataRepository.updateArtifact(repoId, namespace, projectId, projectVersion, artifact);
                    }
                    catch (MetadataRepositoryException e) {
                        this.log.warn("Unable to persist resolved information: {}", (Object)e.getMessage(), (Object)e);
                    }
                }
                session.markDirty();
                artifacts = new ArrayList<ArtifactMetadata>(artifacts);
                artifacts.addAll(storageArtifacts);
            }
            return artifacts;
        }
        catch (RepositoryStorageRuntimeException e) {
            for (RepositoryListener listener : this.listeners) {
                listener.addArtifactProblem(session, repoId, namespace, projectId, projectVersion, e);
            }
            throw new MetadataResolutionException(e.getMessage(), e);
        }
    }

    private Collection<String> createArtifactIdList(Collection<ArtifactMetadata> artifacts) {
        ArrayList<String> artifactIds = new ArrayList<String>();
        for (ArtifactMetadata artifact : artifacts) {
            artifactIds.add(artifact.getId());
        }
        return artifactIds;
    }
}

