/*
 * Decompiled with CFR 0.152.
 */
package org.apache.arrow.adbc.driver.flightsql;

import com.github.benmanes.caffeine.cache.LoadingCache;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.function.Supplier;
import org.apache.arrow.adbc.core.AdbcException;
import org.apache.arrow.adbc.core.AdbcStatusCode;
import org.apache.arrow.adbc.driver.flightsql.FlightSqlClientWithCallOptions;
import org.apache.arrow.adbc.driver.flightsql.FlightSqlDriverUtil;
import org.apache.arrow.flight.FlightEndpoint;
import org.apache.arrow.flight.FlightRuntimeException;
import org.apache.arrow.flight.FlightStream;
import org.apache.arrow.flight.Location;
import org.apache.arrow.memory.BufferAllocator;
import org.apache.arrow.util.AutoCloseables;
import org.apache.arrow.vector.VectorSchemaRoot;
import org.apache.arrow.vector.VectorUnloader;
import org.apache.arrow.vector.ipc.ArrowReader;
import org.apache.arrow.vector.ipc.message.ArrowRecordBatch;
import org.apache.arrow.vector.types.pojo.Schema;
import org.checkerframework.checker.nullness.qual.Nullable;

public abstract class BaseFlightReader
extends ArrowReader {
    private final List<FlightEndpoint> flightEndpoints;
    private final Supplier<List<FlightEndpoint>> rpcCall;
    private int nextEndpointIndex = 0;
    private @Nullable FlightStream currentStream = null;
    private @Nullable Schema schema = null;
    private long bytesRead = 0L;
    protected final FlightSqlClientWithCallOptions client;
    protected final LoadingCache<Location, FlightSqlClientWithCallOptions> clientCache;

    protected BaseFlightReader(BufferAllocator allocator, FlightSqlClientWithCallOptions client, LoadingCache<Location, FlightSqlClientWithCallOptions> clientCache, Supplier<List<FlightEndpoint>> rpcCall) {
        super(allocator);
        this.client = client;
        this.clientCache = clientCache;
        this.flightEndpoints = new ArrayList<FlightEndpoint>();
        this.rpcCall = rpcCall;
    }

    public boolean loadNextBatch() throws IOException {
        if (this.currentStream == null || this.schema == null) {
            throw new IllegalStateException();
        }
        if (!this.currentStream.next()) {
            if (this.nextEndpointIndex >= this.flightEndpoints.size()) {
                return false;
            }
            try {
                this.currentStream.close();
                FlightEndpoint endpoint = this.flightEndpoints.get(this.nextEndpointIndex++);
                this.currentStream = FlightSqlDriverUtil.tryLoadNextStream(endpoint, this.client, this.clientCache);
                if (this.currentStream == null) {
                    throw new IllegalStateException();
                }
                if (!this.schema.equals((Object)this.currentStream.getSchema())) {
                    throw new IOException("Stream has inconsistent schema. Expected: " + this.schema + "\nFound: " + this.currentStream.getSchema());
                }
            }
            catch (IOException e) {
                throw e;
            }
            catch (Exception e) {
                throw new IOException(e);
            }
        }
        this.processRootFromStream(this.currentStream.getRoot());
        return true;
    }

    protected Schema readSchema() throws IOException {
        if (this.schema == null) {
            throw new IllegalStateException();
        }
        return this.schema;
    }

    public long bytesRead() {
        return this.bytesRead;
    }

    protected void closeReadSource() throws IOException {
        try {
            AutoCloseables.close((AutoCloseable[])new AutoCloseable[]{this.currentStream});
        }
        catch (Exception e) {
            throw new IOException(e);
        }
    }

    protected abstract void processRootFromStream(VectorSchemaRoot var1);

    protected void addBytesRead(long bytes) {
        this.bytesRead += bytes;
    }

    protected void populateEndpointData() throws AdbcException {
        try {
            this.flightEndpoints.addAll((Collection<FlightEndpoint>)this.rpcCall.get());
            this.currentStream = FlightSqlDriverUtil.tryLoadNextStream(this.flightEndpoints.get(this.nextEndpointIndex++), this.client, this.clientCache);
            this.schema = this.currentStream.getSchema();
        }
        catch (FlightRuntimeException e) {
            throw FlightSqlDriverUtil.fromFlightException(e);
        }
        catch (IOException e) {
            throw new AdbcException(e.getMessage(), (Throwable)e, AdbcStatusCode.IO, null, 0);
        }
    }

    protected void loadRoot(VectorSchemaRoot root) {
        VectorUnloader unloader = new VectorUnloader(root);
        ArrowRecordBatch recordBatch = unloader.getRecordBatch();
        this.addBytesRead(recordBatch.computeBodyLength());
        this.loadRecordBatch(recordBatch);
    }
}

