/*
 * Decompiled with CFR 0.152.
 */
package org.apache.arrow.adbc.driver.flightsql;

import java.util.List;
import org.apache.arrow.flight.CallOption;
import org.apache.arrow.flight.CancelFlightInfoRequest;
import org.apache.arrow.flight.CancelFlightInfoResult;
import org.apache.arrow.flight.FlightDescriptor;
import org.apache.arrow.flight.FlightEndpoint;
import org.apache.arrow.flight.FlightInfo;
import org.apache.arrow.flight.FlightStream;
import org.apache.arrow.flight.RenewFlightEndpointRequest;
import org.apache.arrow.flight.SchemaResult;
import org.apache.arrow.flight.Ticket;
import org.apache.arrow.flight.sql.CancelResult;
import org.apache.arrow.flight.sql.FlightSqlClient;
import org.apache.arrow.flight.sql.impl.FlightSql;
import org.apache.arrow.flight.sql.util.TableRef;
import org.apache.arrow.util.AutoCloseables;
import org.checkerframework.checker.nullness.qual.Nullable;

public class FlightSqlClientWithCallOptions
implements AutoCloseable {
    private final FlightSqlClient client;
    private final CallOption[] connectionOptions;

    public FlightSqlClientWithCallOptions(FlightSqlClient client, CallOption ... options) {
        this.client = client;
        this.connectionOptions = options;
    }

    public FlightInfo execute(String query, CallOption ... options) {
        return this.client.execute(query, this.combine(options));
    }

    public FlightInfo execute(String query, FlightSqlClient.Transaction transaction, CallOption ... options) {
        return this.client.execute(query, transaction, this.combine(options));
    }

    public FlightInfo executeSubstrait(FlightSqlClient.SubstraitPlan plan, CallOption ... options) {
        return this.client.executeSubstrait(plan, this.combine(options));
    }

    public FlightInfo executeSubstrait(FlightSqlClient.SubstraitPlan plan, FlightSqlClient.Transaction transaction, CallOption ... options) {
        return this.client.executeSubstrait(plan, transaction, this.combine(options));
    }

    public SchemaResult getExecuteSchema(String query, FlightSqlClient.Transaction transaction, CallOption ... options) {
        return this.client.getExecuteSchema(query, transaction, this.combine(options));
    }

    public SchemaResult getExecuteSchema(String query, CallOption ... options) {
        return this.client.getExecuteSchema(query, this.combine(options));
    }

    public SchemaResult getExecuteSubstraitSchema(FlightSqlClient.SubstraitPlan plan, FlightSqlClient.Transaction transaction, CallOption ... options) {
        return this.client.getExecuteSubstraitSchema(plan, transaction, this.combine(options));
    }

    public SchemaResult getExecuteSubstraitSchema(FlightSqlClient.SubstraitPlan substraitPlan, CallOption ... options) {
        return this.client.getExecuteSubstraitSchema(substraitPlan, this.combine(options));
    }

    public long executeUpdate(String query, CallOption ... options) {
        return this.client.executeUpdate(query, this.combine(options));
    }

    public long executeUpdate(String query, FlightSqlClient.Transaction transaction, CallOption ... options) {
        return this.client.executeUpdate(query, transaction, this.combine(options));
    }

    public long executeSubstraitUpdate(FlightSqlClient.SubstraitPlan plan, CallOption ... options) {
        return this.client.executeSubstraitUpdate(plan, this.combine(options));
    }

    public long executeSubstraitUpdate(FlightSqlClient.SubstraitPlan plan, FlightSqlClient.Transaction transaction, CallOption ... options) {
        return this.client.executeSubstraitUpdate(plan, transaction, this.combine(options));
    }

    public FlightInfo getCatalogs(CallOption ... options) {
        return this.client.getCatalogs(this.combine(options));
    }

    public SchemaResult getCatalogsSchema(CallOption ... options) {
        return this.client.getCatalogsSchema(this.combine(options));
    }

    public FlightInfo getSchemas(String catalog, String dbSchemaFilterPattern, CallOption ... options) {
        return this.client.getSchemas(catalog, dbSchemaFilterPattern, this.combine(options));
    }

    public SchemaResult getSchemasSchema(CallOption ... options) {
        return this.client.getSchemasSchema(this.combine(options));
    }

    public SchemaResult getSchema(FlightDescriptor descriptor, CallOption ... options) {
        return this.client.getSchema(descriptor, this.combine(options));
    }

    public FlightStream getStream(Ticket ticket, CallOption ... options) {
        return this.client.getStream(ticket, this.combine(options));
    }

    public FlightInfo getSqlInfo(FlightSql.SqlInfo ... info) {
        return this.client.getSqlInfo(info, this.combine(new CallOption[0]));
    }

    public FlightInfo getSqlInfo(FlightSql.SqlInfo[] info, CallOption ... options) {
        return this.client.getSqlInfo(info, this.combine(options));
    }

    public FlightInfo getSqlInfo(int[] info, CallOption ... options) {
        return this.client.getSqlInfo(info, this.combine(options));
    }

    public FlightInfo getSqlInfo(Iterable<Integer> info, CallOption ... options) {
        return this.client.getSqlInfo(info, this.combine(options));
    }

    public SchemaResult getSqlInfoSchema(CallOption ... options) {
        return this.client.getSqlInfoSchema(this.combine(options));
    }

    public FlightInfo getXdbcTypeInfo(int dataType, CallOption ... options) {
        return this.client.getXdbcTypeInfo(dataType, this.combine(options));
    }

    public FlightInfo getXdbcTypeInfo(CallOption ... options) {
        return this.client.getXdbcTypeInfo(this.combine(options));
    }

    public SchemaResult getXdbcTypeInfoSchema(CallOption ... options) {
        return this.client.getXdbcTypeInfoSchema(this.combine(options));
    }

    public FlightInfo getTables(String catalog, String dbSchemaFilterPattern, String tableFilterPattern, @Nullable List<String> tableTypes, boolean includeSchema, CallOption ... options) {
        return this.client.getTables(catalog, dbSchemaFilterPattern, tableFilterPattern, tableTypes, includeSchema, this.combine(options));
    }

    public SchemaResult getTablesSchema(boolean includeSchema, CallOption ... options) {
        return this.client.getTablesSchema(includeSchema, this.combine(options));
    }

    public FlightInfo getPrimaryKeys(TableRef tableRef, CallOption ... options) {
        return this.client.getPrimaryKeys(tableRef, this.combine(options));
    }

    public SchemaResult getPrimaryKeysSchema(CallOption ... options) {
        return this.client.getPrimaryKeysSchema(this.combine(options));
    }

    public FlightInfo getExportedKeys(TableRef tableRef, CallOption ... options) {
        return this.client.getExportedKeys(tableRef, this.combine(options));
    }

    public SchemaResult getExportedKeysSchema(CallOption ... options) {
        return this.client.getExportedKeysSchema(this.combine(options));
    }

    public FlightInfo getImportedKeys(TableRef tableRef, CallOption ... options) {
        return this.client.getImportedKeys(tableRef, this.combine(options));
    }

    public SchemaResult getImportedKeysSchema(CallOption ... options) {
        return this.client.getImportedKeysSchema(this.combine(options));
    }

    public FlightInfo getCrossReference(TableRef pkTableRef, TableRef fkTableRef, CallOption ... options) {
        return this.client.getCrossReference(pkTableRef, fkTableRef, this.combine(options));
    }

    public SchemaResult getCrossReferenceSchema(CallOption ... options) {
        return this.client.getCrossReferenceSchema(this.combine(options));
    }

    public FlightInfo getTableTypes(CallOption ... options) {
        return this.client.getTableTypes(this.combine(options));
    }

    public SchemaResult getTableTypesSchema(CallOption ... options) {
        return this.client.getTableTypesSchema(this.combine(options));
    }

    public FlightSqlClient.PreparedStatement prepare(String query, CallOption ... options) {
        return this.client.prepare(query, this.combine(options));
    }

    public FlightSqlClient.PreparedStatement prepare(String query, FlightSqlClient.Transaction transaction, CallOption ... options) {
        return this.client.prepare(query, transaction, this.combine(options));
    }

    public FlightSqlClient.PreparedStatement prepare(FlightSqlClient.SubstraitPlan plan, CallOption ... options) {
        return this.client.prepare(plan, this.combine(options));
    }

    public FlightSqlClient.PreparedStatement prepare(FlightSqlClient.SubstraitPlan plan, FlightSqlClient.Transaction transaction, CallOption ... options) {
        return this.client.prepare(plan, transaction, this.combine(options));
    }

    public FlightSqlClient.Transaction beginTransaction(CallOption ... options) {
        return this.client.beginTransaction(this.combine(options));
    }

    public FlightSqlClient.Savepoint beginSavepoint(FlightSqlClient.Transaction transaction, String name, CallOption ... options) {
        return this.client.beginSavepoint(transaction, name, this.combine(options));
    }

    public void commit(FlightSqlClient.Transaction transaction, CallOption ... options) {
        this.client.commit(transaction, this.combine(options));
    }

    public void release(FlightSqlClient.Savepoint savepoint, CallOption ... options) {
        this.client.release(savepoint, this.combine(options));
    }

    public void rollback(FlightSqlClient.Transaction transaction, CallOption ... options) {
        this.client.rollback(transaction, this.combine(options));
    }

    public void rollback(FlightSqlClient.Savepoint savepoint, CallOption ... options) {
        this.client.rollback(savepoint, this.combine(options));
    }

    public CancelFlightInfoResult cancelFlightInfo(CancelFlightInfoRequest request, CallOption ... options) {
        return this.client.cancelFlightInfo(request, this.combine(options));
    }

    public CancelResult cancelQuery(FlightInfo info, CallOption ... options) {
        return this.client.cancelQuery(info, this.combine(options));
    }

    public FlightEndpoint renewFlightEndpoint(RenewFlightEndpointRequest request, CallOption ... options) {
        return this.client.renewFlightEndpoint(request, this.combine(options));
    }

    @Override
    public void close() throws Exception {
        AutoCloseables.close((AutoCloseable[])new AutoCloseable[]{this.client});
    }

    private CallOption[] combine(CallOption ... options) {
        CallOption[] result = new CallOption[this.connectionOptions.length + options.length];
        System.arraycopy(this.connectionOptions, 0, result, 0, this.connectionOptions.length);
        System.arraycopy(options, 0, result, this.connectionOptions.length, options.length);
        return result;
    }
}

