/*
 * Decompiled with CFR 0.152.
 */
package org.apache.arrow.adbc.driver.flightsql;

import com.github.benmanes.caffeine.cache.Caffeine;
import com.github.benmanes.caffeine.cache.LoadingCache;
import com.google.protobuf.InvalidProtocolBufferException;
import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URISyntaxException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Consumer;
import org.apache.arrow.adbc.core.AdbcConnection;
import org.apache.arrow.adbc.core.AdbcDriver;
import org.apache.arrow.adbc.core.AdbcException;
import org.apache.arrow.adbc.core.AdbcStatement;
import org.apache.arrow.adbc.core.AdbcStatusCode;
import org.apache.arrow.adbc.core.BulkIngestMode;
import org.apache.arrow.adbc.driver.flightsql.FlightInfoReader;
import org.apache.arrow.adbc.driver.flightsql.FlightSqlClientWithCallOptions;
import org.apache.arrow.adbc.driver.flightsql.FlightSqlConnectionProperties;
import org.apache.arrow.adbc.driver.flightsql.FlightSqlStatement;
import org.apache.arrow.adbc.driver.flightsql.GetInfoMetadataReader;
import org.apache.arrow.adbc.driver.flightsql.GetObjectsMetadataReaders;
import org.apache.arrow.adbc.sql.SqlQuirks;
import org.apache.arrow.flight.CallHeaders;
import org.apache.arrow.flight.CallOption;
import org.apache.arrow.flight.FlightCallHeaders;
import org.apache.arrow.flight.FlightClient;
import org.apache.arrow.flight.FlightClientMiddleware;
import org.apache.arrow.flight.FlightEndpoint;
import org.apache.arrow.flight.HeaderCallOption;
import org.apache.arrow.flight.Location;
import org.apache.arrow.flight.Ticket;
import org.apache.arrow.flight.auth2.BasicAuthCredentialWriter;
import org.apache.arrow.flight.client.ClientCookieMiddleware;
import org.apache.arrow.flight.grpc.CredentialCallOption;
import org.apache.arrow.flight.impl.Flight;
import org.apache.arrow.flight.sql.FlightSqlClient;
import org.apache.arrow.memory.BufferAllocator;
import org.apache.arrow.util.AutoCloseables;
import org.apache.arrow.vector.ipc.ArrowReader;
import org.checkerframework.checker.initialization.qual.UnknownInitialization;
import org.checkerframework.checker.nullness.qual.Nullable;

public class FlightSqlConnection
implements AdbcConnection {
    private final BufferAllocator allocator;
    private final AtomicInteger counter = new AtomicInteger(0);
    private final FlightSqlClientWithCallOptions client;
    private final SqlQuirks quirks;
    private final Map<String, Object> parameters;
    private final LoadingCache<Location, FlightSqlClientWithCallOptions> clientCache;
    private // Could not load outer class - annotation placement on inner may be incorrect
     @Nullable ClientCookieMiddleware.Factory cookieMiddlewareFactory;
    private CallOption[] callOptions;
    private byte @Nullable [] mtlsCertChainBytes;
    private byte @Nullable [] mtlsPrivateKeyBytes;
    private byte @Nullable [] tlsRootCertsBytes;

    FlightSqlConnection(BufferAllocator allocator, SqlQuirks quirks, Location location, Map<String, Object> parameters) throws AdbcException {
        this.allocator = allocator;
        this.quirks = quirks;
        this.parameters = parameters;
        this.callOptions = new CallOption[0];
        FlightSqlClient flightSqlClient = new FlightSqlClient(this.createInitialConnection(location));
        this.client = new FlightSqlClientWithCallOptions(flightSqlClient, this.callOptions);
        this.clientCache = Caffeine.newBuilder().expireAfterAccess(5L, TimeUnit.MINUTES).removalListener((key, value, cause) -> {
            if (value == null) {
                return;
            }
            try {
                value.close();
            }
            catch (Exception ex) {
                if (ex instanceof InterruptedException) {
                    Thread.currentThread().interrupt();
                }
                throw new RuntimeException(ex);
            }
        }).build(loc -> {
            FlightClient client = this.buildClient((Location)loc);
            client.handshake(this.callOptions);
            return new FlightSqlClientWithCallOptions(new FlightSqlClient(client), this.callOptions);
        });
        this.clientCache.put((Object)location, (Object)this.client);
    }

    public void commit() throws AdbcException {
        throw AdbcException.notImplemented((String)"[Flight SQL] Transaction methods are not supported");
    }

    public AdbcStatement createStatement() throws AdbcException {
        return new FlightSqlStatement(this.allocator, this.client, this.clientCache, this.quirks);
    }

    public ArrowReader readPartition(ByteBuffer descriptor) throws AdbcException {
        FlightEndpoint endpoint;
        try {
            Flight.FlightEndpoint protoEndpoint = Flight.FlightEndpoint.parseFrom((ByteBuffer)descriptor);
            Location[] locations = new Location[protoEndpoint.getLocationCount()];
            int index = 0;
            for (Flight.Location protoLocation : protoEndpoint.getLocationList()) {
                Location location = new Location(protoLocation.getUri());
                locations[index++] = location;
            }
            endpoint = new FlightEndpoint(new Ticket(protoEndpoint.getTicket().getTicket().toByteArray()), locations);
        }
        catch (InvalidProtocolBufferException | URISyntaxException e) {
            throw AdbcException.invalidArgument((String)("[Flight SQL] Partition descriptor is invalid: " + e.getMessage())).withCause(e);
        }
        return new FlightInfoReader(this.allocator, this.client, this.clientCache, Collections.singletonList(endpoint));
    }

    public AdbcStatement bulkIngest(String targetTableName, BulkIngestMode mode) throws AdbcException {
        return FlightSqlStatement.ingestRoot(this.allocator, this.client, this.clientCache, this.quirks, targetTableName, mode);
    }

    public ArrowReader getObjects(AdbcConnection.GetObjectsDepth depth, String catalogPattern, String dbSchemaPattern, String tableNamePattern, String[] tableTypes, String columnNamePattern) throws AdbcException {
        return GetObjectsMetadataReaders.CreateGetObjectsReader(this.allocator, this.client, this.clientCache, depth, catalogPattern, dbSchemaPattern, tableNamePattern, tableTypes, columnNamePattern);
    }

    public ArrowReader getInfo(int @Nullable [] infoCodes) throws AdbcException {
        try {
            return GetInfoMetadataReader.CreateGetInfoMetadataReader(this.allocator, this.client, this.clientCache, infoCodes);
        }
        catch (Exception e) {
            throw AdbcException.invalidState((String)"[Flight SQL] Failed to get info").withCause((Throwable)e);
        }
    }

    public void rollback() throws AdbcException {
        throw AdbcException.notImplemented((String)"[Flight SQL] Transaction methods are not supported");
    }

    public boolean getAutoCommit() throws AdbcException {
        return true;
    }

    public void setAutoCommit(boolean enableAutoCommit) throws AdbcException {
        if (!enableAutoCommit) {
            throw AdbcException.notImplemented((String)"[Flight SQL] Transaction methods are not supported");
        }
    }

    public void close() throws Exception {
        this.clientCache.invalidateAll();
        AutoCloseables.close((AutoCloseable[])new AutoCloseable[]{this.client, this.allocator});
    }

    public String toString() {
        return "FlightSqlConnection{client=" + this.client + "}";
    }

    private FlightClient createInitialConnection(@UnknownInitialization FlightSqlConnection this, Location location) throws AdbcException {
        boolean useCookieMiddleware;
        try {
            if (this.parameters != null) {
                InputStream tlsRootCerts;
                InputStream mtlsPrivateKey;
                InputStream mtlsCertChain = (InputStream)FlightSqlConnectionProperties.MTLS_CERT_CHAIN.get(this.parameters);
                if (mtlsCertChain != null) {
                    this.mtlsCertChainBytes = FlightSqlConnection.inputStreamToBytes(mtlsCertChain);
                }
                if ((mtlsPrivateKey = (InputStream)FlightSqlConnectionProperties.MTLS_PRIVATE_KEY.get(this.parameters)) != null) {
                    this.mtlsPrivateKeyBytes = FlightSqlConnection.inputStreamToBytes(mtlsPrivateKey);
                }
                if ((tlsRootCerts = (InputStream)FlightSqlConnectionProperties.TLS_ROOT_CERTS.get(this.parameters)) != null) {
                    this.tlsRootCertsBytes = FlightSqlConnection.inputStreamToBytes(tlsRootCerts);
                }
            }
        }
        catch (IOException ex) {
            throw new AdbcException(String.format("Error reading stream for one of the options %s, %s, %s.", FlightSqlConnectionProperties.MTLS_CERT_CHAIN.getKey(), FlightSqlConnectionProperties.MTLS_PRIVATE_KEY.getKey(), FlightSqlConnectionProperties.TLS_ROOT_CERTS.getKey()), (Throwable)ex, AdbcStatusCode.IO, null, 0);
        }
        if (this.parameters != null && (useCookieMiddleware = Boolean.TRUE.equals(FlightSqlConnectionProperties.WITH_COOKIE_MIDDLEWARE.get(this.parameters)))) {
            this.cookieMiddlewareFactory = new ClientCookieMiddleware.Factory();
        }
        FlightClient client = this.buildClient(location);
        ArrayList<Object> options = new ArrayList<Object>();
        FlightCallHeaders callHeaders = new FlightCallHeaders();
        for (Map.Entry<String, Object> parameter : this.parameters.entrySet()) {
            if (!parameter.getKey().startsWith("adbc.flight.sql.rpc.call_header.")) continue;
            String userHeaderName = parameter.getKey().substring("adbc.flight.sql.rpc.call_header.".length());
            if (parameter.getValue() instanceof String) {
                callHeaders.insert(userHeaderName, (String)parameter.getValue());
                continue;
            }
            if (parameter.getValue() instanceof byte[]) {
                callHeaders.insert(userHeaderName, (byte[])parameter.getValue());
                continue;
            }
            throw new AdbcException(String.format("Header values must be String or byte[]. The header failing was %s.", parameter.getKey()), null, AdbcStatusCode.INVALID_ARGUMENT, null, 0);
        }
        options.add(new HeaderCallOption((CallHeaders)callHeaders));
        String username = (String)AdbcDriver.PARAM_USERNAME.get(this.parameters);
        String password = (String)AdbcDriver.PARAM_PASSWORD.get(this.parameters);
        if (username != null && password != null) {
            Optional bearerToken = client.authenticateBasicToken(username, password);
            options.add((CallOption)bearerToken.orElse(new CredentialCallOption((Consumer)new BasicAuthCredentialWriter(username, password))));
            this.callOptions = options.toArray(new CallOption[0]);
        } else {
            this.callOptions = options.toArray(new CallOption[0]);
            client.handshake(this.callOptions);
        }
        return client;
    }

    private FlightClient buildClient(@UnknownInitialization FlightSqlConnection this, Location location) throws AdbcException {
        if (this.allocator == null) {
            throw new IllegalStateException("Internal error: allocator was not initialized");
        }
        FlightClient.Builder builder = FlightClient.builder().allocator(this.allocator.newChildAllocator("adbc-flightclient-connection-" + this.counter.getAndIncrement(), 0L, this.allocator.getLimit())).location(location);
        if (this.mtlsCertChainBytes != null && this.mtlsPrivateKeyBytes != null) {
            builder.clientCertificate((InputStream)new ByteArrayInputStream(this.mtlsCertChainBytes), (InputStream)new ByteArrayInputStream(this.mtlsPrivateKeyBytes));
        } else {
            if (this.mtlsCertChainBytes != null) {
                throw new AdbcException(String.format("Must provide both %s and %s or neither. %s provided only.", FlightSqlConnectionProperties.MTLS_CERT_CHAIN.getKey(), FlightSqlConnectionProperties.MTLS_PRIVATE_KEY.getKey(), FlightSqlConnectionProperties.MTLS_CERT_CHAIN.getKey()), null, AdbcStatusCode.INVALID_ARGUMENT, null, 0);
            }
            if (this.mtlsPrivateKeyBytes != null) {
                throw new AdbcException(String.format("Must provide both %s and %s or neither. %s provided only.", FlightSqlConnectionProperties.MTLS_PRIVATE_KEY.getKey(), FlightSqlConnectionProperties.MTLS_CERT_CHAIN.getKey(), FlightSqlConnectionProperties.MTLS_PRIVATE_KEY.getKey()), null, AdbcStatusCode.INVALID_ARGUMENT, null, 0);
            }
        }
        if (this.tlsRootCertsBytes != null) {
            builder.trustedCertificates((InputStream)new ByteArrayInputStream(this.tlsRootCertsBytes));
        }
        if (this.parameters != null) {
            String hostnameOverride;
            if (Boolean.TRUE.equals(FlightSqlConnectionProperties.TLS_SKIP_VERIFY.get(this.parameters))) {
                builder.verifyServer(false);
            }
            if ((hostnameOverride = (String)FlightSqlConnectionProperties.TLS_OVERRIDE_HOSTNAME.get(this.parameters)) != null) {
                builder.overrideHostname(hostnameOverride);
            }
        }
        if (this.cookieMiddlewareFactory != null) {
            builder.intercept((FlightClientMiddleware.Factory)this.cookieMiddlewareFactory);
        }
        return builder.build();
    }

    private static byte[] inputStreamToBytes(InputStream stream) throws IOException {
        byte[] bytes = new byte[stream.available()];
        DataInputStream dataInputStream = new DataInputStream(stream);
        dataInputStream.readFully(bytes);
        return bytes;
    }
}

