/*
 * Decompiled with CFR 0.152.
 */
package org.apache.arrow.adbc.driver.flightsql;

import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.arrow.adbc.core.AdbcConnection;
import org.apache.arrow.adbc.core.AdbcDatabase;
import org.apache.arrow.adbc.core.AdbcException;
import org.apache.arrow.adbc.driver.flightsql.FlightSqlConnection;
import org.apache.arrow.adbc.driver.flightsql.FlightSqlDriverUtil;
import org.apache.arrow.adbc.sql.SqlQuirks;
import org.apache.arrow.flight.FlightRuntimeException;
import org.apache.arrow.flight.Location;
import org.apache.arrow.memory.BufferAllocator;
import org.apache.arrow.util.AutoCloseables;

public final class FlightSqlDatabase
implements AdbcDatabase {
    private final BufferAllocator allocator;
    private final Location location;
    private final SqlQuirks quirks;
    private final AtomicInteger counter;
    private final Map<String, Object> parameters;

    FlightSqlDatabase(BufferAllocator allocator, Location location, SqlQuirks quirks, Map<String, Object> parameters) throws AdbcException {
        this.allocator = allocator;
        this.location = location;
        this.quirks = quirks;
        this.counter = new AtomicInteger();
        this.parameters = parameters;
    }

    public AdbcConnection connect() throws AdbcException {
        int count = this.counter.getAndIncrement();
        BufferAllocator connectionAllocator = this.allocator.newChildAllocator("adbc-flight-connection-" + count, 0L, this.allocator.getLimit());
        try {
            return new FlightSqlConnection(connectionAllocator, this.quirks, this.location, this.parameters);
        }
        catch (FlightRuntimeException ex) {
            AdbcException adbcException = FlightSqlDriverUtil.fromFlightException(ex);
            try {
                AutoCloseables.close((AutoCloseable[])new AutoCloseable[]{connectionAllocator});
            }
            catch (Exception e) {
                adbcException.addSuppressed((Throwable)e);
            }
            throw adbcException;
        }
        catch (Exception ex) {
            AdbcException adbcException = FlightSqlDriverUtil.fromGeneralException(ex);
            try {
                AutoCloseables.close((AutoCloseable[])new AutoCloseable[]{connectionAllocator});
            }
            catch (Exception e) {
                adbcException.addSuppressed((Throwable)e);
            }
            throw adbcException;
        }
    }

    public void close() throws Exception {
    }

    public String toString() {
        return "FlightSqlDatabase{target='" + this.location + "'}";
    }
}

