/*
 * Decompiled with CFR 0.152.
 */
package org.apache.arrow.adbc.driver.flightsql;

import java.net.URISyntaxException;
import java.util.Map;
import java.util.Objects;
import org.apache.arrow.adbc.core.AdbcDatabase;
import org.apache.arrow.adbc.core.AdbcDriver;
import org.apache.arrow.adbc.core.AdbcException;
import org.apache.arrow.adbc.driver.flightsql.FlightSqlDatabase;
import org.apache.arrow.adbc.sql.SqlQuirks;
import org.apache.arrow.flight.Location;
import org.apache.arrow.memory.BufferAllocator;
import org.apache.arrow.util.Preconditions;

public class FlightSqlDriver
implements AdbcDriver {
    private final BufferAllocator allocator;

    public FlightSqlDriver(BufferAllocator allocator) {
        this.allocator = Objects.requireNonNull(allocator);
    }

    public AdbcDatabase open(Map<String, Object> parameters) throws AdbcException {
        Location location;
        String uri = (String)PARAM_URI.get(parameters);
        if (uri == null) {
            Object target = parameters.get("adbc.url");
            if (!(target instanceof String)) {
                throw AdbcException.invalidArgument((String)("[Flight SQL] Must provide String " + PARAM_URI + " parameter"));
            }
            uri = (String)target;
        }
        try {
            location = new Location(uri);
        }
        catch (URISyntaxException e) {
            throw AdbcException.invalidArgument((String)String.format("[Flight SQL] Location %s is invalid: %s", uri, e)).withCause((Throwable)e);
        }
        Object quirks = parameters.get("adbc.sql.quirks");
        if (quirks != null) {
            Preconditions.checkArgument((boolean)(quirks instanceof SqlQuirks), (Object)String.format("[Flight SQL] %s must be a SqlQuirks instance, not %s", "adbc.sql.quirks", quirks.getClass().getName()));
        } else {
            quirks = new SqlQuirks();
        }
        return new FlightSqlDatabase(this.allocator, location, (SqlQuirks)quirks, parameters);
    }
}

