/*
 * Decompiled with CFR 0.152.
 */
package org.apache.arrow.adbc.driver.flightsql;

import com.github.benmanes.caffeine.cache.LoadingCache;
import java.io.IOException;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.Objects;
import org.apache.arrow.adbc.core.AdbcException;
import org.apache.arrow.adbc.core.AdbcStatusCode;
import org.apache.arrow.adbc.core.ErrorDetail;
import org.apache.arrow.adbc.driver.flightsql.FlightSqlClientWithCallOptions;
import org.apache.arrow.flight.CallOption;
import org.apache.arrow.flight.FlightEndpoint;
import org.apache.arrow.flight.FlightRuntimeException;
import org.apache.arrow.flight.FlightStatusCode;
import org.apache.arrow.flight.FlightStream;
import org.apache.arrow.flight.Location;
import org.checkerframework.checker.nullness.qual.Nullable;

final class FlightSqlDriverUtil {
    private FlightSqlDriverUtil() {
        throw new AssertionError((Object)"Do not instantiate this class");
    }

    static String prefixExceptionMessage(@Nullable String s) {
        if (s == null) {
            return "[Flight SQL] (No or unknown error)";
        }
        return "[Flight SQL] " + s;
    }

    static AdbcException fromSqlException(SQLException e) {
        return new AdbcException(FlightSqlDriverUtil.prefixExceptionMessage(e.getMessage()), e.getCause(), AdbcStatusCode.UNKNOWN, e.getSQLState(), e.getErrorCode());
    }

    static AdbcException fromGeneralException(Exception ex) {
        return new AdbcException(ex.getMessage(), (Throwable)ex, AdbcStatusCode.UNKNOWN, null, 0);
    }

    static AdbcStatusCode fromFlightStatusCode(FlightStatusCode code) {
        switch (code) {
            case OK: {
                throw new IllegalArgumentException("Cannot convert OK status");
            }
            case UNKNOWN: {
                return AdbcStatusCode.UNKNOWN;
            }
            case INTERNAL: {
                return AdbcStatusCode.INTERNAL;
            }
            case INVALID_ARGUMENT: {
                return AdbcStatusCode.INVALID_ARGUMENT;
            }
            case TIMED_OUT: {
                return AdbcStatusCode.TIMEOUT;
            }
            case NOT_FOUND: {
                return AdbcStatusCode.NOT_FOUND;
            }
            case ALREADY_EXISTS: {
                return AdbcStatusCode.ALREADY_EXISTS;
            }
            case CANCELLED: {
                return AdbcStatusCode.CANCELLED;
            }
            case UNAUTHENTICATED: {
                return AdbcStatusCode.UNAUTHENTICATED;
            }
            case UNAUTHORIZED: {
                return AdbcStatusCode.UNAUTHORIZED;
            }
            case UNIMPLEMENTED: {
                return AdbcStatusCode.NOT_IMPLEMENTED;
            }
            case UNAVAILABLE: {
                return AdbcStatusCode.IO;
            }
        }
        return AdbcStatusCode.UNKNOWN;
    }

    static AdbcException fromFlightException(FlightRuntimeException e) {
        ArrayList<ErrorDetail> errorDetails = new ArrayList<ErrorDetail>();
        for (String key : e.status().metadata().keys()) {
            if (key.endsWith("-bin")) {
                for (Object value : e.status().metadata().getAllByte(key)) {
                    errorDetails.add(new ErrorDetail(key, value));
                }
                continue;
            }
            Iterator iterator = e.status().metadata().getAll(key).iterator();
            while (iterator.hasNext()) {
                Object value;
                value = (String)iterator.next();
                errorDetails.add(new ErrorDetail(key, value));
            }
        }
        return new AdbcException(e.getMessage(), e.getCause(), FlightSqlDriverUtil.fromFlightStatusCode(e.status().code()), null, 0, errorDetails);
    }

    static FlightStream tryLoadNextStream(FlightEndpoint endpoint, FlightSqlClientWithCallOptions rootClient, LoadingCache<Location, FlightSqlClientWithCallOptions> clientCache) throws IOException {
        if (endpoint.getLocations().isEmpty()) {
            return rootClient.getStream(endpoint.getTicket(), new CallOption[0]);
        }
        ArrayList locations = new ArrayList(endpoint.getLocations());
        Collections.shuffle(locations);
        IOException failure = null;
        for (Location location : locations) {
            @Nullable FlightSqlClientWithCallOptions client = (FlightSqlClientWithCallOptions)clientCache.get((Object)location);
            if (client == null) {
                throw new IllegalStateException("Could not connect to " + location);
            }
            try {
                return client.getStream(endpoint.getTicket(), new CallOption[0]);
            }
            catch (RuntimeException e) {
                if (failure == null) {
                    failure = new IOException("Failed to get stream from location " + location + ": " + e, e);
                    continue;
                }
                failure.addSuppressed(new IOException("Failed to get stream from location " + location + ": " + e, e));
            }
        }
        if (failure == null) {
            throw new IllegalStateException("FlightEndpoint had no locations");
        }
        throw (IOException)Objects.requireNonNull(failure);
    }
}

